/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import org.apache.pulsar.broker.BookKeeperClientFactory;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.zookeeper.ZkBookieRackAffinityMapping;
import org.apache.pulsar.zookeeper.ZkIsolatedBookieEnsemblePlacementPolicy;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;

public class BookKeeperClientFactoryImpl
implements BookKeeperClientFactory {
    private ZooKeeperCache rackawarePolicyZkCache;
    private ZooKeeperCache clientIsolationZkCache;

    @Override
    public BookKeeper create(ServiceConfiguration conf, ZooKeeper zkClient) throws IOException {
        ClientConfiguration bkConf = new ClientConfiguration();
        if (conf.getBookkeeperClientAuthenticationPlugin() != null && conf.getBookkeeperClientAuthenticationPlugin().trim().length() > 0) {
            bkConf.setClientAuthProviderFactoryClass(conf.getBookkeeperClientAuthenticationPlugin());
            bkConf.setProperty(conf.getBookkeeperClientAuthenticationParametersName(), (Object)conf.getBookkeeperClientAuthenticationParameters());
        }
        bkConf.setThrottleValue(0);
        bkConf.setAddEntryTimeout((int)conf.getBookkeeperClientTimeoutInSeconds());
        bkConf.setReadEntryTimeout((int)conf.getBookkeeperClientTimeoutInSeconds());
        bkConf.setSpeculativeReadTimeout(conf.getBookkeeperClientSpeculativeReadTimeoutInMillis());
        bkConf.setNumChannelsPerBookie(16);
        bkConf.setUseV2WireProtocol(true);
        bkConf.setLedgerManagerFactoryClassName(HierarchicalLedgerManagerFactory.class.getName());
        if (conf.isBookkeeperClientHealthCheckEnabled()) {
            bkConf.enableBookieHealthCheck();
            bkConf.setBookieHealthCheckInterval(conf.getBookkeeperHealthCheckIntervalSec(), TimeUnit.SECONDS);
            bkConf.setBookieErrorThresholdPerInterval(conf.getBookkeeperClientHealthCheckErrorThresholdPerInterval());
            bkConf.setBookieQuarantineTime((int)conf.getBookkeeperClientHealthCheckQuarantineTimeInSeconds(), TimeUnit.SECONDS);
        }
        if (conf.isBookkeeperClientRackawarePolicyEnabled()) {
            bkConf.setEnsemblePlacementPolicy(RackawareEnsemblePlacementPolicy.class);
            bkConf.setProperty("reppDnsResolverClass", (Object)ZkBookieRackAffinityMapping.class.getName());
            this.rackawarePolicyZkCache = new ZooKeeperCache(zkClient){};
            bkConf.setProperty("zk_cache_instance", (Object)this.rackawarePolicyZkCache);
        }
        if (conf.getBookkeeperClientIsolationGroups() != null && !conf.getBookkeeperClientIsolationGroups().isEmpty()) {
            bkConf.setEnsemblePlacementPolicy(ZkIsolatedBookieEnsemblePlacementPolicy.class);
            bkConf.setProperty("isolationBookieGroups", (Object)conf.getBookkeeperClientIsolationGroups());
            if (bkConf.getProperty("zk_cache_instance") == null) {
                this.clientIsolationZkCache = new ZooKeeperCache(zkClient){};
                bkConf.setProperty("zk_cache_instance", (Object)this.clientIsolationZkCache);
            }
        }
        try {
            return new BookKeeper(bkConf, zkClient);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() {
        if (this.rackawarePolicyZkCache != null) {
            this.rackawarePolicyZkCache.stop();
        }
        if (this.clientIsolationZkCache != null) {
            this.clientIsolationZkCache.stop();
        }
    }
}

