/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.io.Closeable;
import java.io.IOException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.mledger.ManagedLedgerFactoryConfig;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.pulsar.broker.BookKeeperClientFactory;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedLedgerClientFactory
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ManagedLedgerClientFactory.class);
    private final ManagedLedgerFactory managedLedgerFactory;
    private final BookKeeper bkClient;

    public ManagedLedgerClientFactory(ServiceConfiguration conf, ZooKeeper zkClient, BookKeeperClientFactory bookkeeperProvider) throws Exception {
        this.bkClient = bookkeeperProvider.create(conf, zkClient);
        ManagedLedgerFactoryConfig managedLedgerFactoryConfig = new ManagedLedgerFactoryConfig();
        managedLedgerFactoryConfig.setMaxCacheSize((long)conf.getManagedLedgerCacheSizeMB() * 1024L * 1024L);
        managedLedgerFactoryConfig.setCacheEvictionWatermark(conf.getManagedLedgerCacheEvictionWatermark());
        this.managedLedgerFactory = new ManagedLedgerFactoryImpl(this.bkClient, zkClient, managedLedgerFactoryConfig);
    }

    public ManagedLedgerFactory getManagedLedgerFactory() {
        return this.managedLedgerFactory;
    }

    @Override
    public void close() throws IOException {
        try {
            this.managedLedgerFactory.shutdown();
            log.info("Closed managed ledger factory");
            this.bkClient.close();
            log.info("Closed BookKeeper client");
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new IOException(e);
        }
    }
}

