/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.bookkeeper.mledger.proto.PendingBookieOpsStats;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.loadbalance.LoadManager;
import org.apache.pulsar.broker.loadbalance.ResourceUnit;
import org.apache.pulsar.broker.loadbalance.impl.SimpleLoadManagerImpl;
import org.apache.pulsar.broker.stats.AllocatorStatsGenerator;
import org.apache.pulsar.broker.stats.BookieClientStatsGenerator;
import org.apache.pulsar.broker.stats.MBeanStatsGenerator;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.stats.AllocatorStats;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.apache.pulsar.policies.data.loadbalancer.LoadReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/broker-stats")
@Api(value="/broker-stats", description="Stats for broker", tags={"broker-stats"})
@Produces(value={"application/json"})
public class BrokerStats
extends AdminResource {
    private static final Logger log = LoggerFactory.getLogger(BrokerStats.class);

    @GET
    @Path(value="/metrics")
    @ApiOperation(value="Gets the metrics for Monitoring", notes="Requested should be executed by Monitoring agent on each broker to fetch the metrics", response=Metrics.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public Collection<Metrics> getMetrics() throws Exception {
        this.validateSuperUserAccess();
        try {
            Collection<Metrics> metrics = this.pulsar().getMetricsGenerator().generate();
            return metrics;
        }
        catch (Exception e) {
            log.error("[{}] Failed to generate metrics", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
    }

    @GET
    @Path(value="/mbeans")
    @ApiOperation(value="Get all the mbean details of this broker JVM", response=Metrics.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public Collection<Metrics> getMBeans() throws Exception {
        this.validateSuperUserAccess();
        try {
            Collection<Metrics> metrics = MBeanStatsGenerator.generate(this.pulsar());
            return metrics;
        }
        catch (Exception e) {
            log.error("[{}] Failed to generate mbean stats", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
    }

    @GET
    @Path(value="/destinations")
    @ApiOperation(value="Get all the destination stats by namesapce", response=OutputStream.class, responseContainer="OutputStream")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public StreamingOutput getDestinations2() throws Exception {
        this.validateSuperUserAccess();
        return output -> this.pulsar().getBrokerService().getDimensionMetrics(statsBuf -> {
            try {
                output.write(statsBuf.array(), statsBuf.arrayOffset(), statsBuf.readableBytes());
            }
            catch (Exception e) {
                throw new WebApplicationException((Throwable)e);
            }
        });
    }

    @GET
    @Path(value="/allocator-stats/{allocator}")
    @ApiOperation(value="Get the stats for the Netty allocator. Available allocators are 'default' and 'ml-cache'", response=AllocatorStats.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public AllocatorStats getAllocatorStats(@PathParam(value="allocator") String allocatorName) throws Exception {
        this.validateSuperUserAccess();
        try {
            return AllocatorStatsGenerator.generate(allocatorName);
        }
        catch (IllegalArgumentException e) {
            throw new RestException(Response.Status.NOT_ACCEPTABLE, e.getMessage());
        }
        catch (Exception e) {
            log.error("[{}] Failed to generate allocator stats", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
    }

    @GET
    @Path(value="/bookieops")
    @ApiOperation(value="Get pending bookie client op stats by namesapce", response=PendingBookieOpsStats.class, responseContainer="Map")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public Map<String, Map<String, PendingBookieOpsStats>> getPendingBookieOpsStats() throws Exception {
        this.validateSuperUserAccess();
        try {
            return BookieClientStatsGenerator.generate(this.pulsar());
        }
        catch (Exception e) {
            log.error("[{}] Failed to generate pending bookie ops stats for destinations", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
    }

    @GET
    @Path(value="/load-report")
    @ApiOperation(value="Get Load for this broker", notes="consists of destinationstats & systemResourceUsage", response=LoadReport.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public LoadManagerReport getLoadReport() throws Exception {
        this.validateSuperUserAccess();
        try {
            return this.pulsar().getLoadManager().get().generateLoadReport();
        }
        catch (Exception e) {
            log.error("[{}] Failed to generate LoadReport for broker, reason [{}]", new Object[]{this.clientAppId(), e.getMessage(), e});
            throw new RestException(e);
        }
    }

    @GET
    @Path(value="/broker-resource-availability/{property}/{cluster}/{namespace}")
    @ApiOperation(value="Broker availability report", notes="This API gives the current broker availability in percent, each resource percentage usage is calculated and thensum of all of the resource usage percent is called broker-resource-availability<br/><br/>THIS API IS ONLY FOR USE BY TESTING FOR CONFIRMING NAMESPACE ALLOCATION ALGORITHM", response=ResourceUnit.class, responseContainer="Map")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Load-manager doesn't support operation")})
    public Map<Long, Collection<ResourceUnit>> getBrokerResourceAvailability(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) throws Exception {
        try {
            NamespaceName ns = NamespaceName.get((String)property, (String)cluster, (String)namespace);
            LoadManager lm = this.pulsar().getLoadManager().get();
            if (lm instanceof SimpleLoadManagerImpl) {
                return ((SimpleLoadManagerImpl)lm).getResourceAvailabilityFor((ServiceUnitId)ns).asMap();
            }
            throw new RestException(Response.Status.CONFLICT, String.valueOf(lm.getClass().getName()) + " does not support this operation");
        }
        catch (Exception e) {
            log.error("Unable to get Resource Availability - [{}]", (Throwable)e);
            throw new RestException(e);
        }
    }
}

