/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.naming.NamedEntity;
import org.apache.pulsar.common.policies.data.PropertyAdmin;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/properties")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/properties", description="Properties admin apis", tags={"properties"})
public class Properties
extends AdminResource {
    private static final Logger log = LoggerFactory.getLogger(Properties.class);

    @GET
    @ApiOperation(value="Get the list of properties.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property doesn't exist")})
    public List<String> getProperties() {
        this.validateSuperUserAccess();
        try {
            List<String> properties = this.globalZk().getChildren(Properties.path("policies"), false);
            properties.sort(null);
            return properties;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get properties list", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
    }

    @GET
    @Path(value="/{property}")
    @ApiOperation(value="Get the admin configuration for a given property.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property doesn't exist")})
    public PropertyAdmin getPropertyAdmin(@PathParam(value="property") String property) {
        this.validateSuperUserAccess();
        try {
            return (PropertyAdmin)this.propertiesCache().get(Properties.path("policies", property)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Property does not exist"));
        }
        catch (Exception e) {
            log.error("[{}] Failed to get property {}", new Object[]{this.clientAppId(), property, e});
            throw new RestException(e);
        }
    }

    @PUT
    @Path(value="/{property}")
    @ApiOperation(value="Create a new property.", notes="This operation requires Pulsar super-user privileges.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Property already exist"), @ApiResponse(code=412, message="Property name is not valid")})
    public void createProperty(@PathParam(value="property") String property, PropertyAdmin config) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        try {
            NamedEntity.checkName((String)property);
            this.zkCreate(Properties.path("policies", property), Properties.jsonMapper().writeValueAsBytes((Object)config));
            log.info("[{}] Created property {}", (Object)this.clientAppId(), (Object)property);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            log.warn("[{}] Failed to create already existing property {}", (Object)this.clientAppId(), (Object)property);
            throw new RestException(Response.Status.CONFLICT, "Property already exist");
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Failed to create property with invalid name {}", new Object[]{this.clientAppId(), property, e});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Property name is not valid");
        }
        catch (Exception e) {
            log.error("[{}] Failed to create property {}", new Object[]{this.clientAppId(), property, e});
            throw new RestException(e);
        }
    }

    @POST
    @Path(value="/{property}")
    @ApiOperation(value="Update the admins for a property.", notes="This operation requires Pulsar super-user privileges.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property does not exist"), @ApiResponse(code=409, message="Property already exist")})
    public void updateProperty(@PathParam(value="property") String property, PropertyAdmin newPropertyAdmin) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        Stat nodeStat = new Stat();
        try {
            byte[] content = this.globalZk().getData(Properties.path("policies", property), null, nodeStat);
            PropertyAdmin oldPropertyAdmin = (PropertyAdmin)Properties.jsonMapper().readValue(content, PropertyAdmin.class);
            ArrayList clustersWithActiveNamespaces = Lists.newArrayList();
            if (oldPropertyAdmin.getAllowedClusters().size() > newPropertyAdmin.getAllowedClusters().size()) {
                oldPropertyAdmin.getAllowedClusters().removeAll(newPropertyAdmin.getAllowedClusters());
                log.debug("Following clusters are being removed : [{}]", (Object)oldPropertyAdmin.getAllowedClusters());
                for (String cluster : oldPropertyAdmin.getAllowedClusters()) {
                    List<Object> activeNamespaces = Lists.newArrayList();
                    try {
                        activeNamespaces = this.globalZk().getChildren(Properties.path("policies", property, cluster), false);
                        if (activeNamespaces.size() == 0) continue;
                        clustersWithActiveNamespaces.add(cluster);
                    }
                    catch (KeeperException.NoNodeException noNodeException) {}
                }
                if (!clustersWithActiveNamespaces.isEmpty()) {
                    String msg = String.format("Failed to update the property because active namespaces are present in colos %s. Please delete those namespaces first", clustersWithActiveNamespaces);
                    throw new RestException(Response.Status.CONFLICT, msg);
                }
            }
            String propertyPath = Properties.path("policies", property);
            this.globalZk().setData(propertyPath, Properties.jsonMapper().writeValueAsBytes((Object)newPropertyAdmin), -1);
            this.globalZkCache().invalidate(propertyPath);
            log.info("[{}] updated property {}", (Object)this.clientAppId(), (Object)property);
        }
        catch (RestException re) {
            throw re;
        }
        catch (KeeperException.NoNodeException noNodeException) {
            log.warn("[{}] Failed to update property {}: does not exist", (Object)this.clientAppId(), (Object)property);
            throw new RestException(Response.Status.NOT_FOUND, "Property does not exist");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update property {}", new Object[]{this.clientAppId(), property, e});
            throw new RestException(e);
        }
    }

    @DELETE
    @Path(value="/{property}")
    @ApiOperation(value="elete a property and all namespaces and destinations under it.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property does not exist"), @ApiResponse(code=409, message="The property still has active namespaces")})
    public void deleteProperty(@PathParam(value="property") String property) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        boolean isPropertyEmpty = false;
        try {
            isPropertyEmpty = this.getListOfNamespaces(property).isEmpty();
        }
        catch (KeeperException.NoNodeException noNodeException) {
            log.warn("[{}] Failed to delete property {}: does not exist", (Object)this.clientAppId(), (Object)property);
            throw new RestException(Response.Status.NOT_FOUND, "The property does not exist");
        }
        catch (Exception e) {
            log.error("[{}] Failed to get property status {}", new Object[]{this.clientAppId(), property, e});
            throw new RestException(e);
        }
        if (!isPropertyEmpty) {
            log.warn("[{}] Failed to delete property {}: not empty", (Object)this.clientAppId(), (Object)property);
            throw new RestException(Response.Status.CONFLICT, "The property still has active namespaces");
        }
        try {
            for (String cluster : this.globalZk().getChildren(Properties.path("policies", property), false)) {
                this.globalZk().delete(Properties.path("policies", property, cluster), -1);
            }
            this.globalZk().delete(Properties.path("policies", property), -1);
            log.info("[{}] Deleted property {}", (Object)this.clientAppId(), (Object)property);
        }
        catch (Exception e) {
            log.error("[{}] Failed to delete property {}", new Object[]{this.clientAppId(), property, e});
            throw new RestException(e);
        }
    }
}

