/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.lookup;

import io.netty.buffer.ByteBuf;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.lookup.LookupResult;
import org.apache.pulsar.broker.web.NoSwaggerDocumentation;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.api.Commands;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.lookup.data.LookupData;
import org.apache.pulsar.common.naming.DestinationDomain;
import org.apache.pulsar.common.naming.DestinationName;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.util.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v2/destination/")
@NoSwaggerDocumentation
public class DestinationLookup
extends PulsarWebResource {
    private static final Logger log = LoggerFactory.getLogger(DestinationLookup.class);

    @GET
    @Path(value="{destination-domain}/{property}/{cluster}/{namespace}/{dest}")
    @Produces(value={"application/json"})
    public void lookupDestinationAsync(@PathParam(value="destination-domain") String destinationDomain, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="dest") @Encoded String dest, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse asyncResponse) {
        dest = Codec.decode((String)dest);
        DestinationDomain domain = null;
        try {
            domain = DestinationDomain.getEnum((String)destinationDomain);
        }
        catch (IllegalArgumentException e) {
            log.error("[{}] Invalid destination-domain {}", new Object[]{this.clientAppId(), destinationDomain, e});
            throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Unsupported destination domain " + destinationDomain);
        }
        DestinationName topic = DestinationName.get((String)domain.value(), (String)property, (String)cluster, (String)namespace, (String)dest);
        if (!this.pulsar().getBrokerService().getLookupRequestSemaphore().tryAcquire()) {
            log.warn("No broker was found available for topic {}", (Object)topic);
            asyncResponse.resume((Throwable)new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE));
            return;
        }
        try {
            this.validateClusterOwnership(topic.getCluster());
            this.checkConnect(topic);
            this.validateGlobalNamespaceOwnership(topic.getNamespaceObject());
        }
        catch (WebApplicationException we) {
            log.error("Validation check failed: {}", (Object)we.getMessage());
            this.completeLookupResponseExceptionally(asyncResponse, we);
            return;
        }
        catch (Throwable t) {
            log.error("Validation check failed: {}", (Object)t.getMessage(), (Object)t);
            this.completeLookupResponseExceptionally(asyncResponse, (Throwable)((Object)new RestException(t)));
            return;
        }
        CompletableFuture<Optional<LookupResult>> lookupFuture = this.pulsar().getNamespaceService().getBrokerServiceUrlAsync(topic, authoritative);
        ((CompletableFuture)lookupFuture.thenAccept(optionalResult -> {
            if (optionalResult == null || !optionalResult.isPresent()) {
                log.warn("No broker was found available for topic {}", (Object)topic);
                this.completeLookupResponseExceptionally(asyncResponse, new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE));
                return;
            }
            LookupResult result = (LookupResult)optionalResult.get();
            if (result.isRedirect()) {
                URI redirect;
                boolean newAuthoritative = this.isLeaderBroker();
                try {
                    String redirectUrl = this.isRequestHttps() ? result.getLookupData().getHttpUrlTls() : result.getLookupData().getHttpUrl();
                    redirect = new URI(String.format("%s%s%s?authoritative=%s", redirectUrl, "/lookup/v2/destination/", topic.getLookupName(), newAuthoritative));
                }
                catch (URISyntaxException e) {
                    log.error("Error in preparing redirect url for {}: {}", new Object[]{topic, e.getMessage(), e});
                    this.completeLookupResponseExceptionally(asyncResponse, e);
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Redirect lookup for topic {} to {}", (Object)topic, (Object)redirect);
                }
                this.completeLookupResponseExceptionally(asyncResponse, new WebApplicationException(Response.temporaryRedirect((URI)redirect).build()));
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Lookup succeeded for topic {} -- broker: {}", (Object)topic, (Object)result.getLookupData());
                }
                this.completeLookupResponseSuccessfully(asyncResponse, result.getLookupData());
            }
        })).exceptionally(exception -> {
            log.warn("Failed to lookup broker for topic {}: {}", new Object[]{topic, exception.getMessage(), exception});
            this.completeLookupResponseExceptionally(asyncResponse, (Throwable)exception);
            return null;
        });
    }

    @GET
    @Path(value="{destination-domain}/{property}/{cluster}/{namespace}/{dest}/bundle")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=405, message="Invalid destination domain type")})
    public String getNamespaceBundle(@PathParam(value="destination-domain") String destinationDomain, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="dest") @Encoded String dest) {
        dest = Codec.decode((String)dest);
        DestinationDomain domain = null;
        try {
            domain = DestinationDomain.getEnum((String)destinationDomain);
        }
        catch (IllegalArgumentException e) {
            log.error("[{}] Invalid destination-domain {}", new Object[]{this.clientAppId(), destinationDomain, e});
            throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Bundle lookup can not be done on destination domain " + destinationDomain);
        }
        DestinationName topic = DestinationName.get((String)domain.value(), (String)property, (String)cluster, (String)namespace, (String)dest);
        this.validateSuperUserAccess();
        try {
            NamespaceBundle bundle = this.pulsar().getNamespaceService().getBundle(topic);
            return bundle.getBundleRange();
        }
        catch (Exception e) {
            log.error("[{}] Failed to get namespace bundle for {}", new Object[]{this.clientAppId(), topic, e});
            throw new RestException(e);
        }
    }

    public static CompletableFuture<ByteBuf> lookupDestinationAsync(PulsarService pulsarService, DestinationName fqdn, boolean authoritative, String clientAppId, AuthenticationDataSource authenticationData, long requestId) {
        CompletableFuture validationFuture = new CompletableFuture();
        CompletableFuture<ByteBuf> lookupfuture = new CompletableFuture<ByteBuf>();
        String cluster = fqdn.getCluster();
        ((CompletableFuture)DestinationLookup.getClusterDataIfDifferentCluster(pulsarService, cluster, clientAppId).thenAccept(differentClusterData -> {
            if (differentClusterData != null) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Redirecting the lookup call to {}/{} cluster={}", new Object[]{clientAppId, differentClusterData.getBrokerServiceUrl(), differentClusterData.getBrokerServiceUrlTls(), cluster});
                }
                validationFuture.complete(Commands.newLookupResponse((String)differentClusterData.getBrokerServiceUrl(), (String)differentClusterData.getBrokerServiceUrlTls(), (boolean)true, (PulsarApi.CommandLookupTopicResponse.LookupType)PulsarApi.CommandLookupTopicResponse.LookupType.Redirect, (long)requestId, (boolean)false));
            } else {
                try {
                    DestinationLookup.checkAuthorization(pulsarService, fqdn, clientAppId, authenticationData);
                }
                catch (RestException authException) {
                    log.warn("Failed to authorized {} on cluster {}", (Object)clientAppId, (Object)fqdn.toString());
                    validationFuture.complete(Commands.newLookupErrorResponse((PulsarApi.ServerError)PulsarApi.ServerError.AuthorizationError, (String)authException.getMessage(), (long)requestId));
                    return;
                }
                catch (Exception e) {
                    log.warn("Unknown error while authorizing {} on cluster {}", (Object)clientAppId, (Object)fqdn.toString());
                    validationFuture.completeExceptionally(e);
                    return;
                }
                ((CompletableFuture)DestinationLookup.checkLocalOrGetPeerReplicationCluster(pulsarService, fqdn.getNamespaceObject()).thenAccept(peerClusterData -> {
                    if (peerClusterData == null) {
                        validationFuture.complete(null);
                        return;
                    }
                    validationFuture.complete(Commands.newLookupResponse((String)peerClusterData.getBrokerServiceUrl(), (String)peerClusterData.getBrokerServiceUrlTls(), (boolean)true, (PulsarApi.CommandLookupTopicResponse.LookupType)PulsarApi.CommandLookupTopicResponse.LookupType.Redirect, (long)requestId, (boolean)false));
                })).exceptionally(ex -> {
                    validationFuture.complete(Commands.newLookupErrorResponse((PulsarApi.ServerError)PulsarApi.ServerError.MetadataError, (String)ex.getMessage(), (long)requestId));
                    return null;
                });
            }
        })).exceptionally(ex -> {
            validationFuture.completeExceptionally((Throwable)ex);
            return null;
        });
        ((CompletableFuture)validationFuture.thenAccept(validaitonFailureResponse -> {
            if (validaitonFailureResponse != null) {
                lookupfuture.complete((ByteBuf)validaitonFailureResponse);
            } else {
                ((CompletableFuture)pulsarService.getNamespaceService().getBrokerServiceUrlAsync(fqdn, authoritative).thenAccept(lookupResult -> {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Lookup result {}", (Object)fqdn.toString(), lookupResult);
                    }
                    if (!lookupResult.isPresent()) {
                        lookupfuture.complete(Commands.newLookupErrorResponse((PulsarApi.ServerError)PulsarApi.ServerError.ServiceNotReady, (String)("No broker was available to own " + fqdn), (long)requestId));
                        return;
                    }
                    LookupData lookupData = ((LookupResult)lookupResult.get()).getLookupData();
                    if (((LookupResult)lookupResult.get()).isRedirect()) {
                        boolean newAuthoritative = DestinationLookup.isLeaderBroker(pulsarService);
                        lookupfuture.complete(Commands.newLookupResponse((String)lookupData.getBrokerUrl(), (String)lookupData.getBrokerUrlTls(), (boolean)newAuthoritative, (PulsarApi.CommandLookupTopicResponse.LookupType)PulsarApi.CommandLookupTopicResponse.LookupType.Redirect, (long)requestId, (boolean)false));
                    } else {
                        lookupfuture.complete(Commands.newLookupResponse((String)lookupData.getBrokerUrl(), (String)lookupData.getBrokerUrlTls(), (boolean)true, (PulsarApi.CommandLookupTopicResponse.LookupType)PulsarApi.CommandLookupTopicResponse.LookupType.Connect, (long)requestId, (boolean)false));
                    }
                })).exceptionally(ex -> {
                    if (ex instanceof CompletionException && ex.getCause() instanceof IllegalStateException) {
                        log.info("Failed to lookup {} for topic {} with error {}", new Object[]{clientAppId, fqdn.toString(), ex.getCause().getMessage()});
                    } else {
                        log.warn("Failed to lookup {} for topic {} with error {}", new Object[]{clientAppId, fqdn.toString(), ex.getMessage(), ex});
                    }
                    lookupfuture.complete(Commands.newLookupErrorResponse((PulsarApi.ServerError)PulsarApi.ServerError.ServiceNotReady, (String)ex.getMessage(), (long)requestId));
                    return null;
                });
            }
        })).exceptionally(ex -> {
            if (ex instanceof CompletionException && ex.getCause() instanceof IllegalStateException) {
                log.info("Failed to lookup {} for topic {} with error {}", new Object[]{clientAppId, fqdn.toString(), ex.getCause().getMessage()});
            } else {
                log.warn("Failed to lookup {} for topic {} with error {}", new Object[]{clientAppId, fqdn.toString(), ex.getMessage(), ex});
            }
            lookupfuture.complete(Commands.newLookupErrorResponse((PulsarApi.ServerError)PulsarApi.ServerError.ServiceNotReady, (String)ex.getMessage(), (long)requestId));
            return null;
        });
        return lookupfuture;
    }

    private void completeLookupResponseExceptionally(AsyncResponse asyncResponse, Throwable t) {
        this.pulsar().getBrokerService().getLookupRequestSemaphore().release();
        asyncResponse.resume(t);
    }

    private void completeLookupResponseSuccessfully(AsyncResponse asyncResponse, LookupData lookupData) {
        this.pulsar().getBrokerService().getLookupRequestSemaphore().release();
        asyncResponse.resume((Object)lookupData);
    }
}

