/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.common.naming.DestinationName;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.util.RateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchRateLimiter {
    private final String topicName;
    private final BrokerService brokerService;
    private RateLimiter dispatchRateLimiterOnMessage;
    private RateLimiter dispatchRateLimiterOnByte;
    private static final Logger log = LoggerFactory.getLogger(DispatchRateLimiter.class);

    public DispatchRateLimiter(PersistentTopic topic) {
        this.topicName = topic.getName();
        this.brokerService = topic.getBrokerService();
        this.updateDispatchRate();
        this.registerLocalPoliciesListener();
    }

    public long getAvailableDispatchRateLimitOnMsg() {
        return this.dispatchRateLimiterOnMessage == null ? -1L : this.dispatchRateLimiterOnMessage.getAvailablePermits();
    }

    public boolean tryDispatchPermit(long msgPermits, long bytePermits) {
        boolean acquiredBytePermit;
        boolean acquiredMsgPermit = msgPermits <= 0L || this.dispatchRateLimiterOnMessage == null || this.dispatchRateLimiterOnMessage.tryAcquire(msgPermits);
        boolean bl = acquiredBytePermit = bytePermits <= 0L || this.dispatchRateLimiterOnByte == null || this.dispatchRateLimiterOnByte.tryAcquire(bytePermits);
        return acquiredMsgPermit && acquiredBytePermit;
    }

    public boolean hasMessageDispatchPermit() {
        return !(this.dispatchRateLimiterOnMessage != null && this.dispatchRateLimiterOnMessage.getAvailablePermits() <= 0L || this.dispatchRateLimiterOnByte != null && this.dispatchRateLimiterOnByte.getAvailablePermits() <= 0L);
    }

    public boolean isDispatchRateLimitingEnabled() {
        return this.dispatchRateLimiterOnMessage != null || this.dispatchRateLimiterOnByte != null;
    }

    public void updateDispatchRate() {
        DispatchRate dispatchRate = this.getPoliciesDispatchRate();
        if (dispatchRate == null) {
            dispatchRate = new DispatchRate(this.brokerService.pulsar().getConfiguration().getDispatchThrottlingRatePerTopicInMsg(), this.brokerService.pulsar().getConfiguration().getDispatchThrottlingRatePerTopicInByte(), 1);
        }
        this.updateDispatchRate(dispatchRate);
        log.info("[{}] configured message-dispatch rate at broker {}", (Object)this.topicName, (Object)dispatchRate);
    }

    private void registerLocalPoliciesListener() {
        this.brokerService.pulsar().getConfigurationCache().policiesCache().registerListener((path, data, stat) -> {
            DispatchRate dispatchRate;
            NamespaceName namespace = DestinationName.get((String)this.topicName).getNamespaceObject();
            String cluster = this.brokerService.pulsar().getConfiguration().getClusterName();
            String policiesPath = PulsarWebResource.path("policies", namespace.toString());
            if (policiesPath.equals(path) && (dispatchRate = (DispatchRate)data.clusterDispatchRate.get(cluster)) != null) {
                DispatchRate clusterDispatchRate = new DispatchRate(this.brokerService.pulsar().getConfiguration().getDispatchThrottlingRatePerTopicInMsg(), this.brokerService.pulsar().getConfiguration().getDispatchThrottlingRatePerTopicInByte(), 1);
                if (!this.isDispatchRateEnabled(dispatchRate) && this.isDispatchRateEnabled(clusterDispatchRate)) {
                    dispatchRate = clusterDispatchRate;
                }
                this.updateDispatchRate(dispatchRate);
            }
        });
    }

    public DispatchRate getPoliciesDispatchRate() {
        NamespaceName namespace = DestinationName.get((String)this.topicName).getNamespaceObject();
        String cluster = this.brokerService.pulsar().getConfiguration().getClusterName();
        String path = PulsarWebResource.path("policies", namespace.toString());
        Optional policies = Optional.empty();
        try {
            policies = (Optional)this.brokerService.pulsar().getConfigurationCache().policiesCache().getAsync(path).get(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.warn("Failed to get message-rate for {}", (Object)this.topicName, (Object)e);
        }
        return policies.map(p -> {
            DispatchRate dispatchRate = (DispatchRate)p.clusterDispatchRate.get(cluster);
            return this.isDispatchRateEnabled(dispatchRate) ? dispatchRate : null;
        }).orElse(null);
    }

    public synchronized void updateDispatchRate(DispatchRate dispatchRate) {
        log.info("[{}] setting message-dispatch-rate {}", (Object)this.topicName, (Object)dispatchRate);
        long msgRate = dispatchRate.dispatchThrottlingRatePerTopicInMsg;
        long byteRate = dispatchRate.dispatchThrottlingRatePerTopicInByte;
        long ratePerid = dispatchRate.ratePeriodInSecond;
        if (msgRate > 0L) {
            if (this.dispatchRateLimiterOnMessage == null) {
                this.dispatchRateLimiterOnMessage = new RateLimiter(this.brokerService.pulsar().getExecutor(), msgRate, ratePerid, TimeUnit.SECONDS);
            } else {
                this.dispatchRateLimiterOnMessage.setRate(msgRate, (long)dispatchRate.ratePeriodInSecond, TimeUnit.SECONDS);
            }
        } else if (this.dispatchRateLimiterOnMessage != null) {
            this.dispatchRateLimiterOnMessage.close();
            this.dispatchRateLimiterOnMessage = null;
        }
        if (byteRate > 0L) {
            if (this.dispatchRateLimiterOnByte == null) {
                this.dispatchRateLimiterOnByte = new RateLimiter(this.brokerService.pulsar().getExecutor(), byteRate, ratePerid, TimeUnit.SECONDS);
            } else {
                this.dispatchRateLimiterOnByte.setRate(byteRate, (long)dispatchRate.ratePeriodInSecond, TimeUnit.SECONDS);
            }
        } else if (this.dispatchRateLimiterOnByte != null) {
            this.dispatchRateLimiterOnByte.close();
            this.dispatchRateLimiterOnByte = null;
        }
    }

    public long getDispatchRateOnMsg() {
        return this.dispatchRateLimiterOnMessage != null ? this.dispatchRateLimiterOnMessage.getRate() : -1L;
    }

    public long getDispatchRateOnByte() {
        return this.dispatchRateLimiterOnByte != null ? this.dispatchRateLimiterOnByte.getRate() : -1L;
    }

    private boolean isDispatchRateEnabled(DispatchRate dispatchRate) {
        return dispatchRate != null && (dispatchRate.dispatchThrottlingRatePerTopicInMsg > 0 || dispatchRate.dispatchThrottlingRatePerTopicInByte > 0L);
    }

    public void close() {
        if (this.dispatchRateLimiterOnMessage != null) {
            this.dispatchRateLimiterOnMessage.close();
            this.dispatchRateLimiterOnMessage = null;
        }
        if (this.dispatchRateLimiterOnByte != null) {
            this.dispatchRateLimiterOnByte.close();
            this.dispatchRateLimiterOnByte = null;
        }
    }
}

