/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.TreeMap;
import org.apache.bookkeeper.mledger.proto.PendingBookieOpsStats;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.common.naming.DestinationName;

public class BookieClientStatsGenerator {
    private final PulsarService pulsar;
    private Map<String, Map<String, PendingBookieOpsStats>> nsBookieClientStatsMap;

    public BookieClientStatsGenerator(PulsarService pulsar) {
        this.pulsar = pulsar;
        this.nsBookieClientStatsMap = Maps.newTreeMap();
    }

    public static Map<String, Map<String, PendingBookieOpsStats>> generate(PulsarService pulsar) throws Exception {
        return new BookieClientStatsGenerator(pulsar).generate();
    }

    private Map<String, Map<String, PendingBookieOpsStats>> generate() throws Exception {
        if (this.pulsar.getBrokerService() != null && this.pulsar.getBrokerService().getTopics() != null) {
            this.pulsar.getBrokerService().getTopics().forEach((name, topicFuture) -> {
                PersistentTopic persistentTopic = topicFuture.getNow(null);
                if (persistentTopic != null) {
                    DestinationName destinationName = DestinationName.get((String)persistentTopic.getName());
                    this.put(destinationName, persistentTopic.getManagedLedger().getStats().getPendingBookieOpsStats());
                }
            });
        }
        return this.nsBookieClientStatsMap;
    }

    private void put(DestinationName destinationName, PendingBookieOpsStats bookieOpsStats) {
        String namespace = destinationName.getNamespace();
        if (!this.nsBookieClientStatsMap.containsKey(namespace)) {
            TreeMap destBookieClientStatsMap = Maps.newTreeMap();
            destBookieClientStatsMap.put(destinationName.toString(), bookieOpsStats);
            this.nsBookieClientStatsMap.put(namespace, destBookieClientStatsMap);
        } else {
            this.nsBookieClientStatsMap.get(namespace).put(destinationName.toString(), bookieOpsStats);
        }
    }
}

