/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.authentication.AuthenticationDataHttps;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.naming.DestinationName;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundles;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PropertyAdmin;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PulsarWebResource {
    private static final Logger log = LoggerFactory.getLogger(PulsarWebResource.class);
    @Context
    protected ServletContext servletContext;
    @Context
    protected HttpServletRequest httpRequest;
    @Context
    protected UriInfo uri;
    private PulsarService pulsar;
    protected static final int NOT_IMPLEMENTED = 501;

    protected PulsarService pulsar() {
        if (this.pulsar == null) {
            this.pulsar = (PulsarService)this.servletContext.getAttribute("pulsar");
        }
        return this.pulsar;
    }

    protected ServiceConfiguration config() {
        return this.pulsar().getConfiguration();
    }

    public static String path(String ... parts) {
        StringBuilder sb = new StringBuilder();
        sb.append("/admin/");
        Joiner.on((char)'/').appendTo(sb, (Object[])parts);
        return sb.toString();
    }

    public static String joinPath(String ... parts) {
        StringBuilder sb = new StringBuilder();
        Joiner.on((char)'/').appendTo(sb, (Object[])parts);
        return sb.toString();
    }

    public static String splitPath(String source, int slice) {
        Iterable parts = Splitter.on((char)'/').limit(slice).split((CharSequence)source);
        Iterator s = parts.iterator();
        String result = new String();
        int i = 0;
        while (i < slice) {
            result = (String)s.next();
            ++i;
        }
        return result;
    }

    public String clientAppId() {
        return (String)this.httpRequest.getAttribute(AuthenticationFilter.AuthenticatedRoleAttributeName);
    }

    public AuthenticationDataHttps clientAuthData() {
        return (AuthenticationDataHttps)this.httpRequest.getAttribute(AuthenticationFilter.AuthenticatedDataAttributeName);
    }

    public boolean isRequestHttps() {
        return "https".equalsIgnoreCase(this.httpRequest.getScheme());
    }

    public static boolean isClientAuthenticated(String appId) {
        return appId != null;
    }

    protected void validateSuperUserAccess() {
        if (this.config().isAuthenticationEnabled()) {
            String appId = this.clientAppId();
            if (log.isDebugEnabled()) {
                log.debug("[{}] Check super user access: Authenticated: {} -- Role: {}", new Object[]{this.uri.getRequestUri(), PulsarWebResource.isClientAuthenticated(appId), appId});
            }
            if (!this.config().getSuperUserRoles().contains(appId)) {
                throw new RestException(Response.Status.UNAUTHORIZED, "This operation requires super-user access");
            }
        }
    }

    protected void validateAdminAccessOnProperty(String property) {
        try {
            PulsarWebResource.validateAdminAccessOnProperty(this.pulsar(), this.clientAppId(), property);
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Failed to get property admin data for property {}", (Object)property);
            throw new RestException(e);
        }
    }

    protected static void validateAdminAccessOnProperty(PulsarService pulsar, String clientAppId, String property) throws RestException, Exception {
        if (pulsar.getConfiguration().isAuthenticationEnabled() && pulsar.getConfiguration().isAuthorizationEnabled()) {
            PropertyAdmin propertyAdmin;
            log.debug("check admin access on property: {} - Authenticated: {} -- role: {}", new Object[]{property, PulsarWebResource.isClientAuthenticated(clientAppId), clientAppId});
            try {
                propertyAdmin = (PropertyAdmin)pulsar.getConfigurationCache().propertiesCache().get(PulsarWebResource.path("policies", property)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Property does not exist"));
            }
            catch (KeeperException.NoNodeException noNodeException) {
                log.warn("Failed to get property admin data for non existing property {}", (Object)property);
                throw new RestException(Response.Status.NOT_FOUND, "Property does not exist");
            }
            if (!PulsarWebResource.isClientAuthenticated(clientAppId)) {
                throw new RestException(Response.Status.FORBIDDEN, "Need to authenticate to perform the request");
            }
            if (pulsar.getConfiguration().getSuperUserRoles().contains(clientAppId)) {
                log.debug("granting access to super-user {} on property {}", (Object)clientAppId, (Object)property);
            } else {
                if (!propertyAdmin.getAdminRoles().contains(clientAppId)) {
                    throw new RestException(Response.Status.UNAUTHORIZED, "Don't have permission to administrate resources on this property");
                }
                log.debug("Successfully authorized {} on property {}", (Object)clientAppId, (Object)property);
            }
        }
    }

    protected void validateClusterForProperty(String property, String cluster) {
        PropertyAdmin propertyAdmin;
        try {
            propertyAdmin = (PropertyAdmin)this.pulsar().getConfigurationCache().propertiesCache().get(PulsarWebResource.path("policies", property)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Property does not exist"));
        }
        catch (Exception e) {
            log.error("Failed to get property admin data for property");
            throw new RestException(e);
        }
        if (!propertyAdmin.getAllowedClusters().contains(cluster)) {
            String msg = String.format("Cluster [%s] is not in the list of allowed clusters list for property [%s]", cluster, property);
            log.info(msg);
            throw new RestException(Response.Status.FORBIDDEN, msg);
        }
        log.info("Successfully validated clusters on property [{}]", (Object)property);
    }

    protected void validateClusterOwnership(String cluster) throws WebApplicationException {
        try {
            ClusterData differentClusterData = PulsarWebResource.getClusterDataIfDifferentCluster(this.pulsar(), cluster, this.clientAppId()).get();
            if (differentClusterData != null) {
                URI redirect = this.getRedirectionUrl(differentClusterData);
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Redirecting the rest call to {}: cluster={}", new Object[]{this.clientAppId(), redirect, cluster});
                }
                throw new WebApplicationException(Response.temporaryRedirect((URI)redirect).build());
            }
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception e) {
            if (e.getCause() instanceof WebApplicationException) {
                throw (WebApplicationException)e.getCause();
            }
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, String.format("Failed to validate Cluster configuration : cluster=%s  emsg=%s", cluster, e.getMessage()));
        }
    }

    private URI getRedirectionUrl(ClusterData differentClusterData) throws MalformedURLException {
        URL webUrl = null;
        webUrl = this.pulsar.getConfiguration().isTlsEnabled() && !differentClusterData.getServiceUrlTls().isEmpty() ? new URL(differentClusterData.getServiceUrlTls()) : new URL(differentClusterData.getServiceUrl());
        return UriBuilder.fromUri((URI)this.uri.getRequestUri()).host(webUrl.getHost()).port(webUrl.getPort()).build(new Object[0]);
    }

    protected static CompletableFuture<ClusterData> getClusterDataIfDifferentCluster(PulsarService pulsar, String cluster, String clientAppId) {
        CompletableFuture<ClusterData> clusterDataFuture;
        block5: {
            clusterDataFuture = new CompletableFuture<ClusterData>();
            if (!PulsarWebResource.isValidCluster(pulsar, cluster)) {
                try {
                    if (!pulsar.getConfiguration().getClusterName().equals(cluster)) {
                        ((CompletableFuture)pulsar.getConfigurationCache().clustersCache().getAsync(PulsarWebResource.path("clusters", cluster)).thenAccept(clusterDataResult -> {
                            if (clusterDataResult.isPresent()) {
                                clusterDataFuture.complete((ClusterData)clusterDataResult.get());
                            } else {
                                log.warn("[{}] Cluster does not exist: requested={}", (Object)clientAppId, (Object)cluster);
                                clusterDataFuture.completeExceptionally((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Cluster does not exist: cluster=" + cluster)));
                            }
                        })).exceptionally(ex -> {
                            clusterDataFuture.completeExceptionally((Throwable)ex);
                            return null;
                        });
                        break block5;
                    }
                    clusterDataFuture.complete(null);
                }
                catch (Exception e) {
                    clusterDataFuture.completeExceptionally(e);
                }
            } else {
                clusterDataFuture.complete(null);
            }
        }
        return clusterDataFuture;
    }

    protected static boolean isValidCluster(PulsarService pulsarSevice, String cluster) {
        if (cluster.equals("global")) {
            return true;
        }
        return !pulsarSevice.getConfiguration().isAuthorizationEnabled();
    }

    protected void validateNamespaceOwnershipWithBundles(String property, String cluster, String namespace, boolean authoritative, boolean readOnly, BundlesData bundleData) {
        NamespaceName fqnn = NamespaceName.get((String)property, (String)cluster, (String)namespace);
        try {
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(fqnn, bundleData);
            for (NamespaceBundle bundle : bundles.getBundles()) {
                this.validateBundleOwnership(bundle, authoritative, readOnly);
            }
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception oe) {
            log.debug(String.format("Failed to find owner for namespace %s", fqnn), (Throwable)oe);
            throw new RestException(oe);
        }
    }

    protected void validateBundleOwnership(String property, String cluster, String namespace, boolean authoritative, boolean readOnly, NamespaceBundle bundle) {
        NamespaceName fqnn = NamespaceName.get((String)property, (String)cluster, (String)namespace);
        try {
            this.validateBundleOwnership(bundle, authoritative, readOnly);
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception oe) {
            log.debug(String.format("Failed to find owner for namespace %s", fqnn), (Throwable)oe);
            throw new RestException(oe);
        }
    }

    protected NamespaceBundle validateNamespaceBundleRange(NamespaceName fqnn, BundlesData bundles, String bundleRange) {
        try {
            Preconditions.checkArgument((boolean)bundleRange.contains("_"), (Object)"Invalid bundle range");
            String[] boundaries = bundleRange.split("_");
            Long lowerEndpoint = Long.decode(boundaries[0]);
            Long upperEndpoint = Long.decode(boundaries[1]);
            Range hashRange = Range.range((Comparable)lowerEndpoint, (BoundType)BoundType.CLOSED, (Comparable)upperEndpoint, (BoundType)(upperEndpoint.equals(NamespaceBundles.FULL_UPPER_BOUND) ? BoundType.CLOSED : BoundType.OPEN));
            NamespaceBundle nsBundle = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundle(fqnn, (Range<Long>)hashRange);
            NamespaceBundles nsBundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(fqnn, bundles);
            nsBundles.validateBundle(nsBundle);
            return nsBundle;
        }
        catch (Exception e) {
            log.error("[{}] Failed to validate namespace bundle {}/{}", new Object[]{this.clientAppId(), fqnn.toString(), bundleRange, e});
            throw new RestException(e);
        }
    }

    protected boolean isBundleOwnedByAnyBroker(NamespaceName fqnn, BundlesData bundles, String bundleRange) {
        NamespaceBundle nsBundle = this.validateNamespaceBundleRange(fqnn, bundles, bundleRange);
        NamespaceService nsService = this.pulsar().getNamespaceService();
        try {
            return nsService.getWebServiceUrl(nsBundle, false, this.isRequestHttps(), true).isPresent();
        }
        catch (Exception e) {
            log.error("[{}] Failed to check whether namespace bundle is owned {}/{}", new Object[]{this.clientAppId(), fqnn.toString(), bundleRange, e});
            throw new RestException(e);
        }
    }

    protected NamespaceBundle validateNamespaceBundleOwnership(NamespaceName fqnn, BundlesData bundles, String bundleRange, boolean authoritative, boolean readOnly) {
        try {
            NamespaceBundle nsBundle = this.validateNamespaceBundleRange(fqnn, bundles, bundleRange);
            this.validateBundleOwnership(nsBundle, authoritative, readOnly);
            return nsBundle;
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception e) {
            log.error("[{}] Failed to validate namespace bundle {}/{}", new Object[]{this.clientAppId(), fqnn.toString(), bundleRange, e});
            throw new RestException(e);
        }
    }

    public void validateBundleOwnership(NamespaceBundle bundle, boolean authoritative, boolean readOnly) throws Exception {
        NamespaceService nsService = this.pulsar().getNamespaceService();
        try {
            Optional<URL> webUrl = nsService.getWebServiceUrl(bundle, authoritative, this.isRequestHttps(), readOnly);
            if (webUrl == null || !webUrl.isPresent()) {
                log.warn("Unable to get web service url");
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Failed to find ownership for ServiceUnit:" + bundle.toString());
            }
            if (!nsService.isServiceUnitOwned(bundle)) {
                boolean newAuthoritative = this.isLeaderBroker();
                URI redirect = UriBuilder.fromUri((URI)this.uri.getRequestUri()).host(webUrl.get().getHost()).port(webUrl.get().getPort()).replaceQueryParam("authoritative", new Object[]{newAuthoritative}).build(new Object[0]);
                log.debug("{} is not a service unit owned", (Object)bundle);
                log.debug("Redirecting the rest call to {}", (Object)redirect);
                throw new WebApplicationException(Response.temporaryRedirect((URI)redirect).build());
            }
        }
        catch (IllegalArgumentException iae) {
            log.debug(String.format("Failed to find owner for ServiceUnit %s", bundle), (Throwable)iae);
            throw new RestException(Response.Status.PRECONDITION_FAILED, "ServiceUnit format is not expected. ServiceUnit " + bundle);
        }
        catch (IllegalStateException ise) {
            log.debug(String.format("Failed to find owner for ServiceUnit %s", bundle), (Throwable)ise);
            throw new RestException(Response.Status.PRECONDITION_FAILED, "ServiceUnit bundle is actived. ServiceUnit " + bundle);
        }
        catch (NullPointerException nullPointerException) {
            log.warn("Unable to get web service url");
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Failed to find ownership for ServiceUnit:" + bundle);
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
    }

    protected void validateDestinationOwnership(DestinationName fqdn, boolean authoritative) {
        NamespaceService nsService = this.pulsar().getNamespaceService();
        try {
            Optional<URL> webUrl = nsService.getWebServiceUrl((ServiceUnitId)fqdn, authoritative, this.isRequestHttps(), false);
            if (webUrl == null || !webUrl.isPresent()) {
                log.info("Unable to get web service url");
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Failed to find ownership for destination:" + fqdn);
            }
            if (!nsService.isServiceUnitOwned((ServiceUnitId)fqdn)) {
                boolean newAuthoritative = PulsarWebResource.isLeaderBroker(this.pulsar());
                URI redirect = UriBuilder.fromUri((URI)this.uri.getRequestUri()).host(webUrl.get().getHost()).port(webUrl.get().getPort()).replaceQueryParam("authoritative", new Object[]{newAuthoritative}).build(new Object[0]);
                log.debug("Redirecting the rest call to {}", (Object)redirect);
                throw new WebApplicationException(Response.temporaryRedirect((URI)redirect).build());
            }
        }
        catch (IllegalArgumentException iae) {
            log.debug(String.format("Failed to find owner for destination:%s", fqdn), (Throwable)iae);
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Can't find owner for destination " + fqdn);
        }
        catch (IllegalStateException ise) {
            log.debug(String.format("Failed to find owner for destination:%s", fqdn), (Throwable)ise);
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Can't find owner for destination " + fqdn);
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception oe) {
            log.debug(String.format("Failed to find owner for destination:%s", fqdn), (Throwable)oe);
            throw new RestException(oe);
        }
    }

    protected void validateGlobalNamespaceOwnership(NamespaceName namespace) {
        try {
            ClusterData peerClusterData = PulsarWebResource.checkLocalOrGetPeerReplicationCluster(this.pulsar(), namespace).get(30L, TimeUnit.SECONDS);
            if (peerClusterData != null) {
                URI redirect = this.getRedirectionUrl(peerClusterData);
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Redirecting the rest call to {}: cluster={}", (Object)redirect, (Object)peerClusterData);
                }
                throw new WebApplicationException(Response.temporaryRedirect((URI)redirect).build());
            }
        }
        catch (InterruptedException e) {
            log.warn("Time-out {} sec while validating policy on {} ", (Object)30, (Object)namespace);
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, String.format("Failed to validate global cluster configuration : ns=%s  emsg=%s", namespace, e.getMessage()));
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() instanceof WebApplicationException) {
                throw (WebApplicationException)e.getCause();
            }
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, String.format("Failed to validate global cluster configuration : ns=%s  emsg=%s", namespace, e.getMessage()));
        }
    }

    protected static CompletableFuture<ClusterData> checkLocalOrGetPeerReplicationCluster(PulsarService pulsarService, NamespaceName namespace) {
        if (!namespace.isGlobal()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<ClusterData> validationFuture = new CompletableFuture<ClusterData>();
        String localCluster = pulsarService.getConfiguration().getClusterName();
        String path = AdminResource.path("policies", namespace.getProperty(), namespace.getCluster(), namespace.getLocalName());
        ((CompletableFuture)pulsarService.getConfigurationCache().policiesCache().getAsync(path).thenAccept(policiesResult -> {
            if (policiesResult.isPresent()) {
                Policies policies = (Policies)policiesResult.get();
                if (policies.replication_clusters.isEmpty()) {
                    String msg = String.format("Global namespace does not have any clusters configured : local_cluster=%s ns=%s", localCluster, namespace.toString());
                    log.warn(msg);
                    validationFuture.completeExceptionally((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, msg)));
                } else if (!policies.replication_clusters.contains(localCluster)) {
                    ClusterData ownerPeerCluster = PulsarWebResource.getOwnerFromPeerClusterList(pulsarService, policies.replication_clusters);
                    if (ownerPeerCluster != null) {
                        validationFuture.complete(ownerPeerCluster);
                        return;
                    }
                    String msg = String.format("Global namespace missing local cluster name in replication list : local_cluster=%s ns=%s repl_clusters=%s", localCluster, namespace.toString(), policies.replication_clusters);
                    log.warn(msg);
                    validationFuture.completeExceptionally((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, msg)));
                } else {
                    validationFuture.complete(null);
                }
            } else {
                String msg = String.format("Policies not found for %s namespace", namespace.toString());
                log.error(msg);
                validationFuture.completeExceptionally((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, msg)));
            }
        })).exceptionally(ex -> {
            String msg = String.format("Failed to validate global cluster configuration : cluster=%s ns=%s  emsg=%s", localCluster, namespace, ex.getMessage());
            log.error(msg);
            validationFuture.completeExceptionally((Throwable)((Object)new RestException((Throwable)ex)));
            return null;
        });
        return validationFuture;
    }

    private static ClusterData getOwnerFromPeerClusterList(PulsarService pulsar, List<String> replicationClusters) {
        Optional cluster;
        String currentCluster;
        block6: {
            currentCluster = pulsar.getConfiguration().getClusterName();
            if (replicationClusters == null || replicationClusters.isEmpty() || StringUtils.isBlank((CharSequence)currentCluster)) {
                return null;
            }
            cluster = pulsar.getConfigurationCache().clustersCache().get(PulsarWebResource.path("clusters", currentCluster));
            if (cluster.isPresent() && ((ClusterData)cluster.get()).getPeerClusterNames() != null) break block6;
            return null;
        }
        try {
            HashSet replicationClusterSet = Sets.newHashSet(replicationClusters);
            for (String peerCluster : ((ClusterData)cluster.get()).getPeerClusterNames()) {
                if (!replicationClusterSet.contains(peerCluster)) continue;
                return (ClusterData)pulsar.getConfigurationCache().clustersCache().get(PulsarWebResource.path("clusters", peerCluster)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Peer cluster " + peerCluster + " data not found"));
            }
        }
        catch (Exception e) {
            log.error("Failed to get peer-cluster {}-{}", (Object)currentCluster, (Object)e.getMessage());
            if (e instanceof RestException) {
                throw (RestException)((Object)e);
            }
            throw new RestException(e);
        }
        return null;
    }

    protected void checkConnect(DestinationName destination) throws RestException, Exception {
        PulsarWebResource.checkAuthorization(this.pulsar(), destination, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    protected static void checkAuthorization(PulsarService pulsarService, DestinationName destination, String role, AuthenticationDataSource authenticationData) throws RestException, Exception {
        if (!pulsarService.getConfiguration().isAuthorizationEnabled()) {
            return;
        }
        if (!pulsarService.getBrokerService().getAuthorizationService().canLookup(destination, role, authenticationData)) {
            log.warn("[{}] Role {} is not allowed to lookup topic", (Object)destination, (Object)role);
            throw new RestException(Response.Status.UNAUTHORIZED, "Don't have permission to connect to this namespace");
        }
    }

    public void setPulsar(PulsarService pulsar) {
        this.pulsar = pulsar;
    }

    protected boolean isLeaderBroker() {
        return PulsarWebResource.isLeaderBroker(this.pulsar());
    }

    protected static boolean isLeaderBroker(PulsarService pulsar) {
        String leaderAddress = pulsar.getLeaderElectionService().getCurrentLeader().getServiceUrl();
        String myAddress = pulsar.getWebServiceAddress();
        return myAddress.equals(leaderAddress);
    }
}

