/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.ComparisonChain;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.client.api.RawMessage;
import org.apache.pulsar.client.impl.RawMessageImpl;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.compaction.CompactedTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactedTopicImpl
implements CompactedTopic {
    static final long NEWER_THAN_COMPACTED = -4276948922L;
    private static final Logger log = LoggerFactory.getLogger(CompactedTopicImpl.class);

    @Override
    public void newCompactedLedger(Position p, long compactedLedgerId) {
    }

    static CompletableFuture<Long> findStartPoint(PositionImpl p, long lastEntryId, AsyncLoadingCache<Long, PulsarApi.MessageIdData> cache) {
        CompletableFuture<Long> promise = new CompletableFuture<Long>();
        CompactedTopicImpl.findStartPointLoop(p, 0L, lastEntryId, promise, cache);
        return promise;
    }

    private static void findStartPointLoop(PositionImpl p, long start, long end, CompletableFuture<Long> promise, AsyncLoadingCache<Long, PulsarApi.MessageIdData> cache) {
        long midpoint = start + (end - start) / 2L;
        CompletableFuture startEntry = cache.get((Object)start);
        CompletableFuture middleEntry = cache.get((Object)midpoint);
        CompletableFuture endEntry = cache.get((Object)end);
        ((CompletableFuture)CompletableFuture.allOf(startEntry, middleEntry, endEntry).thenRun(() -> {
            if (CompactedTopicImpl.comparePositionAndMessageId(p, (PulsarApi.MessageIdData)startEntry.join()) < 0) {
                promise.complete(start);
            } else if (CompactedTopicImpl.comparePositionAndMessageId(p, (PulsarApi.MessageIdData)middleEntry.join()) < 0) {
                CompactedTopicImpl.findStartPointLoop(p, start, midpoint, promise, cache);
            } else if (CompactedTopicImpl.comparePositionAndMessageId(p, (PulsarApi.MessageIdData)endEntry.join()) < 0) {
                CompactedTopicImpl.findStartPointLoop(p, midpoint + 1L, end, promise, cache);
            } else {
                promise.complete(-4276948922L);
            }
        })).exceptionally(exception -> {
            promise.completeExceptionally((Throwable)exception);
            return null;
        });
    }

    static AsyncLoadingCache<Long, PulsarApi.MessageIdData> createCache(LedgerHandle lh, long maxSize) {
        return Caffeine.newBuilder().maximumSize(maxSize).buildAsync((entryId, executor) -> CompactedTopicImpl.readOneMessageId(lh, entryId));
    }

    private static CompletableFuture<PulsarApi.MessageIdData> readOneMessageId(LedgerHandle lh, long entryId) {
        CompletableFuture<PulsarApi.MessageIdData> promise = new CompletableFuture<PulsarApi.MessageIdData>();
        lh.asyncReadEntries(entryId, entryId, (rc, _lh, seq, ctx) -> {
            if (rc != 0) {
                promise.completeExceptionally((Throwable)BKException.create((int)rc));
            } else {
                try {
                    Throwable throwable = null;
                    Object var9_10 = null;
                    try (RawMessage m = RawMessageImpl.deserializeFrom(((LedgerEntry)seq.nextElement()).getEntryBuffer());){
                        promise.complete(m.getMessageIdData());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (NoSuchElementException e) {
                    log.error("No such entry {} in ledger {}", (Object)entryId, (Object)lh.getId());
                    promise.completeExceptionally(e);
                }
            }
        }, null);
        return promise;
    }

    private static int comparePositionAndMessageId(PositionImpl p, PulsarApi.MessageIdData m) {
        return ComparisonChain.start().compare(p.getLedgerId(), m.getLedgerId()).compare(p.getEntryId(), m.getEntryId()).result();
    }
}

