/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.lookup.v1;

import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.apache.pulsar.broker.lookup.TopicLookupBase;
import org.apache.pulsar.broker.web.NoSwaggerDocumentation;
import org.apache.pulsar.common.naming.TopicName;

@Path(value="/v2/destination/")
@NoSwaggerDocumentation
public class TopicLookup
extends TopicLookupBase {
    @GET
    @Path(value="{topic-domain}/{property}/{cluster}/{namespace}/{topic}")
    @Produces(value={"application/json"})
    public void lookupTopicAsync(@PathParam(value="topic-domain") String topicDomain, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse asyncResponse) {
        TopicName topicName = this.getTopicName(topicDomain, property, cluster, namespace, encodedTopic);
        this.internalLookupTopicAsync(topicName, authoritative, asyncResponse);
    }

    @GET
    @Path(value="{topic-domain}/{property}/{cluster}/{namespace}/{topic}/bundle")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=405, message="Invalid topic domain type")})
    public String getNamespaceBundle(@PathParam(value="topic-domain") String topicDomain, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        TopicName topicName = this.getTopicName(topicDomain, property, cluster, namespace, encodedTopic);
        return this.internalGetNamespaceBundle(topicName);
    }
}

