/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.SslContext;
import java.util.Set;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.common.api.ByteBufPair;
import org.apache.pulsar.common.util.SecurityUtility;

public class PulsarChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String TLS_HANDLER = "tls";
    BrokerService brokerService;
    ServiceConfiguration serviceConfig;
    boolean enableTLS;

    public PulsarChannelInitializer(BrokerService brokerService, ServiceConfiguration serviceConfig, boolean enableTLS) {
        this.brokerService = brokerService;
        this.serviceConfig = serviceConfig;
        this.enableTLS = enableTLS;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        if (this.enableTLS) {
            SslContext sslCtx = SecurityUtility.createNettySslContextForServer((boolean)this.serviceConfig.isTlsAllowInsecureConnection(), (String)this.serviceConfig.getTlsTrustCertsFilePath(), (String)this.serviceConfig.getTlsCertificateFilePath(), (String)this.serviceConfig.getTlsKeyFilePath(), (Set)this.serviceConfig.getTlsCiphers(), (Set)this.serviceConfig.getTlsProtocols(), (boolean)this.serviceConfig.getTlsRequireTrustedClientCertOnConnect());
            ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)sslCtx.newHandler(ch.alloc()));
        }
        ch.pipeline().addLast("ByteBufPairEncoder", (ChannelHandler)ByteBufPair.ENCODER);
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0x500000, 0, 4, 0, 4));
        ch.pipeline().addLast("handler", (ChannelHandler)new ServerCnx(this.brokerService));
    }
}

