/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.nonpersistent;

import java.util.List;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.util.Rate;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.service.AbstractDispatcherSingleActiveConsumer;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentDispatcher;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentTopic;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.Policies;

public final class NonPersistentDispatcherSingleActiveConsumer
extends AbstractDispatcherSingleActiveConsumer
implements NonPersistentDispatcher {
    private final NonPersistentTopic topic;
    private final Rate msgDrop;
    private final Subscription subscription;
    private final ServiceConfiguration serviceConfig;

    public NonPersistentDispatcherSingleActiveConsumer(PulsarApi.CommandSubscribe.SubType subscriptionType, int partitionIndex, NonPersistentTopic topic, Subscription subscription) {
        super(subscriptionType, partitionIndex, topic.getName());
        this.topic = topic;
        this.subscription = subscription;
        this.msgDrop = new Rate();
        this.serviceConfig = topic.getBrokerService().pulsar().getConfiguration();
    }

    @Override
    public void sendMessages(List<Entry> entries) {
        Consumer currentConsumer = AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this);
        if (currentConsumer != null && currentConsumer.getAvailablePermits() > 0 && currentConsumer.isWritable()) {
            currentConsumer.sendMessages(entries);
        } else {
            entries.forEach(entry -> {
                int totalMsgs = Consumer.getBatchSizeforEntry(entry.getDataBuffer(), this.subscription, -1L);
                if (totalMsgs > 0) {
                    this.msgDrop.recordEvent();
                }
                entry.release();
            });
        }
    }

    @Override
    protected boolean isConsumersExceededOnTopic() {
        int maxConsumersPerTopic;
        Policies policies;
        try {
            policies = this.topic.getBrokerService().pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", TopicName.get((String)this.topicName).getNamespace())).orElseGet(() -> new Policies());
        }
        catch (Exception exception) {
            policies = new Policies();
        }
        int n = maxConsumersPerTopic = policies.max_consumers_per_topic > 0 ? policies.max_consumers_per_topic : this.serviceConfig.getMaxConsumersPerTopic();
        return maxConsumersPerTopic > 0 && maxConsumersPerTopic <= this.topic.getNumberOfConsumers();
    }

    @Override
    protected boolean isConsumersExceededOnSubscription() {
        int maxConsumersPerSubscription;
        Policies policies;
        try {
            policies = this.topic.getBrokerService().pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", TopicName.get((String)this.topicName).getNamespace())).orElseGet(() -> new Policies());
        }
        catch (Exception exception) {
            policies = new Policies();
        }
        int n = maxConsumersPerSubscription = policies.max_consumers_per_subscription > 0 ? policies.max_consumers_per_subscription : this.serviceConfig.getMaxConsumersPerSubscription();
        return maxConsumersPerSubscription > 0 && maxConsumersPerSubscription <= this.consumers.size();
    }

    @Override
    public Rate getMesssageDropRate() {
        return this.msgDrop;
    }

    @Override
    public boolean hasPermits() {
        return AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this) != null && AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this).getAvailablePermits() > 0;
    }

    @Override
    public void consumerFlow(Consumer consumer, int additionalNumberOfMessages) {
    }

    @Override
    protected void scheduleReadOnActiveConsumer() {
    }

    @Override
    protected void readMoreEntries(Consumer consumer) {
    }

    @Override
    protected void cancelPendingRead() {
    }
}

