/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import java.util.HashMap;
import java.util.Map;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerMBeanImpl;
import org.apache.bookkeeper.mledger.util.StatsBuckets;
import org.apache.pulsar.broker.stats.prometheus.AggregatedReplicationStats;
import org.apache.pulsar.common.util.SimpleTextOutputStream;

class TopicStats {
    int subscriptionsCount;
    int producersCount;
    int consumersCount;
    double rateIn;
    double rateOut;
    double throughputIn;
    double throughputOut;
    long storageSize;
    public long msgBacklog;
    StatsBuckets storageWriteLatencyBuckets = new StatsBuckets(ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC);
    StatsBuckets entrySizeBuckets = new StatsBuckets(ManagedLedgerMBeanImpl.ENTRY_SIZE_BUCKETS_BYTES);
    double storageWriteRate;
    double storageReadRate;
    Map<String, AggregatedReplicationStats> replicationStats = new HashMap<String, AggregatedReplicationStats>();

    TopicStats() {
    }

    public void reset() {
        this.subscriptionsCount = 0;
        this.producersCount = 0;
        this.consumersCount = 0;
        this.rateIn = 0.0;
        this.rateOut = 0.0;
        this.throughputIn = 0.0;
        this.throughputOut = 0.0;
        this.storageSize = 0L;
        this.msgBacklog = 0L;
        this.storageWriteRate = 0.0;
        this.storageReadRate = 0.0;
        this.replicationStats.clear();
        this.storageWriteLatencyBuckets.reset();
        this.entrySizeBuckets.reset();
    }

    static void printTopicStats(SimpleTextOutputStream stream, String cluster, String namespace, String topic, TopicStats stats) {
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_subscriptions_count", stats.subscriptionsCount);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_producers_count", stats.producersCount);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_consumers_count", stats.consumersCount);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_rate_in", stats.rateIn);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_rate_out", stats.rateOut);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_throughput_in", stats.throughputIn);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_throughput_out", stats.throughputOut);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_size", stats.storageSize);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_msg_backlog", stats.msgBacklog);
        long[] latencyBuckets = stats.storageWriteLatencyBuckets.getBuckets();
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_0_5", latencyBuckets[0]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_1", latencyBuckets[1]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_5", latencyBuckets[2]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_10", latencyBuckets[3]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_20", latencyBuckets[4]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_50", latencyBuckets[5]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_100", latencyBuckets[6]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_200", latencyBuckets[7]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_1000", latencyBuckets[8]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_overflow", latencyBuckets[9]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_count", stats.storageWriteLatencyBuckets.getCount());
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_sum", stats.storageWriteLatencyBuckets.getSum());
        long[] entrySizeBuckets = stats.entrySizeBuckets.getBuckets();
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_128", entrySizeBuckets[0]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_512", entrySizeBuckets[1]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_1_kb", entrySizeBuckets[2]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_2_kb", entrySizeBuckets[3]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_4_kb", entrySizeBuckets[4]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_16_kb", entrySizeBuckets[5]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_100_kb", entrySizeBuckets[6]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_1_mb", entrySizeBuckets[7]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_overflow", entrySizeBuckets[8]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_count", stats.entrySizeBuckets.getCount());
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_sum", stats.entrySizeBuckets.getSum());
    }

    private static void metric(SimpleTextOutputStream stream, String cluster, String namespace, String topic, String name, double value) {
        stream.write(name).write("{cluster=\"").write(cluster).write("\", namespace=\"").write(namespace).write("\", topic=\"").write(topic).write("\"} ");
        stream.write(value).write(' ').write(System.currentTimeMillis()).write('\n');
    }
}

