/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.RawMessage;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.util.protobuf.ByteBufCodedInputStream;
import org.apache.pulsar.common.util.protobuf.ByteBufCodedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawMessageImpl
implements RawMessage {
    private static final Logger log = LoggerFactory.getLogger(RawMessageImpl.class);
    private final PulsarApi.MessageIdData id;
    private ByteBuf headersAndPayload;

    public RawMessageImpl(PulsarApi.MessageIdData id, ByteBuf headersAndPayload) {
        this.id = id;
        this.headersAndPayload = headersAndPayload.retainedSlice();
    }

    @Override
    public MessageId getMessageId() {
        return new BatchMessageIdImpl(this.id.getLedgerId(), this.id.getEntryId(), this.id.getPartition(), this.id.getBatchIndex());
    }

    @Override
    public PulsarApi.MessageIdData getMessageIdData() {
        return this.id;
    }

    @Override
    public ByteBuf getHeadersAndPayload() {
        return this.headersAndPayload.slice();
    }

    @Override
    public void close() {
        this.headersAndPayload.release();
        this.headersAndPayload = Unpooled.EMPTY_BUFFER;
    }

    @Override
    public ByteBuf serialize() {
        ByteBuf headersAndPayload = this.headersAndPayload.slice();
        int idSize = this.id.getSerializedSize();
        int headerSize = 4 + idSize + 4;
        int totalSize = headerSize + headersAndPayload.readableBytes();
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.buffer(totalSize);
        buf.writeInt(idSize);
        try {
            ByteBufCodedOutputStream outStream = ByteBufCodedOutputStream.get((ByteBuf)buf);
            this.id.writeTo(outStream);
            outStream.recycle();
        }
        catch (IOException e) {
            log.error("IO exception serializing to ByteBuf (this shouldn't happen as operation is in-memory)", (Throwable)e);
            throw new RuntimeException(e);
        }
        buf.writeInt(headersAndPayload.readableBytes());
        buf.writeBytes(headersAndPayload);
        return buf;
    }

    public static RawMessage deserializeFrom(ByteBuf buffer) {
        try {
            int idSize = buffer.readInt();
            int writerIndex = buffer.writerIndex();
            buffer.writerIndex(buffer.readerIndex() + idSize);
            ByteBufCodedInputStream stream = ByteBufCodedInputStream.get((ByteBuf)buffer);
            PulsarApi.MessageIdData.Builder builder = PulsarApi.MessageIdData.newBuilder();
            PulsarApi.MessageIdData id = builder.mergeFrom(stream, null).build();
            buffer.writerIndex(writerIndex);
            builder.recycle();
            int payloadAndMetadataSize = buffer.readInt();
            ByteBuf metadataAndPayload = buffer.slice(buffer.readerIndex(), payloadAndMetadataSize);
            return new RawMessageImpl(id, metadataAndPayload);
        }
        catch (IOException e) {
            log.error("IO exception deserializing ByteBuf (this shouldn't happen as operation is in-memory)", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

