/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZookeeperClientFactoryImpl;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarClusterMetadataSetup {
    private static final Logger log = LoggerFactory.getLogger(PulsarClusterMetadataSetup.class);

    public static void main(String[] args) throws Exception {
        Policies policies;
        String defaultNamespacePath;
        Arguments arguments = new Arguments();
        JCommander jcommander = new JCommander();
        try {
            jcommander.addObject((Object)arguments);
            jcommander.parse(args);
            if (arguments.help) {
                jcommander.usage();
                return;
            }
        }
        catch (Exception e) {
            jcommander.usage();
            throw e;
        }
        if (arguments.configurationStore == null && arguments.globalZookeeper == null) {
            System.err.println("Configuration store address argument is required (--configuration-store)");
            jcommander.usage();
            System.exit(1);
        }
        if (arguments.configurationStore != null && arguments.globalZookeeper != null) {
            System.err.println("Configuration store argument (--configuration-store) supercedes the deprecated (--global-zookeeper) argument");
            jcommander.usage();
            System.exit(1);
        }
        if (arguments.configurationStore == null) {
            arguments.configurationStore = arguments.globalZookeeper;
        }
        log.info("Setting up cluster {} with zk={} configuration-store ={}", new Object[]{arguments.cluster, arguments.zookeeper, arguments.configurationStore});
        ZookeeperClientFactoryImpl zkfactory = new ZookeeperClientFactoryImpl();
        ZooKeeper localZk = (ZooKeeper)zkfactory.create(arguments.zookeeper, ZooKeeperClientFactory.SessionType.ReadWrite, 30000).get();
        ZooKeeper configStoreZk = (ZooKeeper)zkfactory.create(arguments.configurationStore, ZooKeeperClientFactory.SessionType.ReadWrite, 30000).get();
        ServerConfiguration bkConf = new ServerConfiguration();
        bkConf.setLedgerManagerFactoryClass(HierarchicalLedgerManagerFactory.class);
        bkConf.setZkServers(arguments.zookeeper);
        if (localZk.exists("/ledgers", false) == null && !BookKeeperAdmin.format((ServerConfiguration)bkConf, (boolean)false, (boolean)false)) {
            throw new IOException("Failed to initialize BookKeeper metadata");
        }
        localZk.create("/managed-ledgers", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        localZk.create("/namespace", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        try {
            ZkUtils.createFullPathOptimistic((ZooKeeper)configStoreZk, (String)"/admin/policies", (byte[])new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {}
        try {
            ZkUtils.createFullPathOptimistic((ZooKeeper)configStoreZk, (String)"/admin/clusters", (byte[])new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {}
        ClusterData clusterData = new ClusterData(arguments.clusterWebServiceUrl, arguments.clusterWebServiceUrlTls, arguments.clusterBrokerServiceUrl, arguments.clusterBrokerServiceUrlTls);
        byte[] clusterDataJson = ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)clusterData);
        configStoreZk.create("/admin/clusters/" + arguments.cluster, clusterDataJson, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        ClusterData globalClusterData = new ClusterData(null, null);
        byte[] globalClusterDataJson = ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)globalClusterData);
        try {
            configStoreZk.create("/admin/clusters/global", globalClusterDataJson, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {}
        String publicTenantPath = "/admin/policies/public";
        Stat stat = configStoreZk.exists(publicTenantPath, false);
        if (stat == null) {
            TenantInfo publicTenant = new TenantInfo(Collections.emptySet(), Collections.singleton(arguments.cluster));
            try {
                ZkUtils.createFullPathOptimistic((ZooKeeper)configStoreZk, (String)publicTenantPath, (byte[])ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)publicTenant), ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {}
        } else {
            byte[] content = configStoreZk.getData(publicTenantPath, false, null);
            TenantInfo publicTenant = (TenantInfo)ObjectMapperFactory.getThreadLocal().readValue(content, TenantInfo.class);
            if (!publicTenant.getAllowedClusters().contains(arguments.cluster)) {
                publicTenant.getAllowedClusters().add(arguments.cluster);
                configStoreZk.setData(publicTenantPath, ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)publicTenant), stat.getVersion());
            }
        }
        if ((stat = configStoreZk.exists(defaultNamespacePath = "/admin/policies/public/default", false)) == null) {
            policies = new Policies();
            policies.bundles = PulsarClusterMetadataSetup.getBundles(16);
            policies.replication_clusters = Collections.singleton(arguments.cluster);
            try {
                ZkUtils.createFullPathOptimistic((ZooKeeper)configStoreZk, (String)defaultNamespacePath, (byte[])ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)policies), ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {}
        } else {
            byte[] content = configStoreZk.getData(defaultNamespacePath, false, null);
            policies = (Policies)ObjectMapperFactory.getThreadLocal().readValue(content, Policies.class);
            if (!policies.replication_clusters.contains(arguments.cluster)) {
                policies.replication_clusters.add(arguments.cluster);
                configStoreZk.setData(defaultNamespacePath, ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)policies), stat.getVersion());
            }
        }
        log.info("Cluster metadata for '{}' setup correctly", (Object)arguments.cluster);
    }

    private static BundlesData getBundles(int numBundles) {
        Long maxVal = 0x100000000L;
        Long segSize = maxVal / (long)numBundles;
        ArrayList partitions = Lists.newArrayList();
        partitions.add(String.format("0x%08x", 0L));
        Long curPartition = segSize;
        int i = 0;
        while (i < numBundles) {
            if (i != numBundles - 1) {
                partitions.add(String.format("0x%08x", curPartition));
            } else {
                partitions.add(String.format("0x%08x", maxVal - 1L));
            }
            curPartition = curPartition + segSize;
            ++i;
        }
        return new BundlesData((List)partitions);
    }

    private static class Arguments {
        @Parameter(names={"-c", "--cluster"}, description="Cluster name", required=true)
        private String cluster;
        @Parameter(names={"-uw", "--web-service-url"}, description="Web-service URL for new cluster", required=true)
        private String clusterWebServiceUrl;
        @Parameter(names={"-tw", "--web-service-url-tls"}, description="Web-service URL for new cluster with TLS encryption", required=false)
        private String clusterWebServiceUrlTls;
        @Parameter(names={"-ub", "--broker-service-url"}, description="Broker-service URL for new cluster", required=false)
        private String clusterBrokerServiceUrl;
        @Parameter(names={"-tb", "--broker-service-url-tls"}, description="Broker-service URL for new cluster with TLS encryption", required=false)
        private String clusterBrokerServiceUrlTls;
        @Parameter(names={"-zk", "--zookeeper"}, description="Local ZooKeeper quorum connection string", required=true)
        private String zookeeper;
        @Parameter(names={"-gzk", "--global-zookeeper"}, description="Global ZooKeeper quorum connection string", required=false, hidden=true)
        private String globalZookeeper;
        @Parameter(names={"-cs", "--configuration-store"}, description="Configuration Store connection string", required=false)
        private String configurationStore;
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        private boolean help = false;

        private Arguments() {
        }
    }
}

