/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v1;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.pulsar.broker.admin.impl.BrokerStatsBase;
import org.apache.pulsar.broker.loadbalance.ResourceUnit;

@Path(value="/broker-stats")
@Api(value="/broker-stats", description="Stats for broker", tags={"broker-stats"})
@Produces(value={"application/json"})
public class BrokerStats
extends BrokerStatsBase {
    @GET
    @Path(value="/broker-resource-availability/{property}/{cluster}/{namespace}")
    @ApiOperation(value="Broker availability report", notes="This API gives the current broker availability in percent, each resource percentage usage is calculated and thensum of all of the resource usage percent is called broker-resource-availability<br/><br/>THIS API IS ONLY FOR USE BY TESTING FOR CONFIRMING NAMESPACE ALLOCATION ALGORITHM", response=ResourceUnit.class, responseContainer="Map")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Load-manager doesn't support operation")})
    public Map<Long, Collection<ResourceUnit>> getBrokerResourceAvailability(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalBrokerResourceAvailability(this.namespaceName);
    }
}

