/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.pulsar.broker.admin.impl.ResourceQuotasBase;
import org.apache.pulsar.common.policies.data.ResourceQuota;

@Path(value="/resource-quotas")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/resource-quotas", description="Quota admin APIs", tags={"resource-quotas"})
public class ResourceQuotas
extends ResourceQuotasBase {
    @Override
    @GET
    @ApiOperation(value="Get the default quota", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public ResourceQuota getDefaultResourceQuota() throws Exception {
        return super.getDefaultResourceQuota();
    }

    @Override
    @POST
    @ApiOperation(value="Set the default quota", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void setDefaultResourceQuota(ResourceQuota quota) throws Exception {
        super.setDefaultResourceQuota(quota);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{bundle}")
    @ApiOperation(value="Get resource quota of a namespace bundle.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public ResourceQuota getNamespaceBundleResourceQuota(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetNamespaceBundleResourceQuota(bundleRange);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{bundle}")
    @ApiOperation(value="Set resource quota on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setNamespaceBundleResourceQuota(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange, ResourceQuota quota) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetNamespaceBundleResourceQuota(bundleRange, quota);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{bundle}")
    @ApiOperation(value="Remove resource quota for a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeNamespaceBundleResourceQuota(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange) {
        this.validateNamespaceName(tenant, namespace);
        this.internalRemoveNamespaceBundleResourceQuota(bundleRange);
    }
}

