/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import java.io.IOException;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityCheck;
import org.apache.pulsar.common.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaType;

public class JsonSchemaCompatibilityCheck
implements SchemaCompatibilityCheck {
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public SchemaType getSchemaType() {
        return SchemaType.JSON;
    }

    @Override
    public boolean isCompatible(SchemaData from, SchemaData to) {
        try {
            JsonSchema fromSchema = (JsonSchema)this.objectMapper.readValue(from.getData(), JsonSchema.class);
            JsonSchema toSchema = (JsonSchema)this.objectMapper.readValue(to.getData(), JsonSchema.class);
            return fromSchema.getId().equals(toSchema.getId());
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

