/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.naming.NamedEntity;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantsBase
extends AdminResource {
    private static final Logger log = LoggerFactory.getLogger(TenantsBase.class);

    @GET
    @ApiOperation(value="Get the list of tenants.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="Tenant doesn't exist")})
    public List<String> getTenants() {
        this.validateSuperUserAccess();
        try {
            List<String> tenants = this.globalZk().getChildren(TenantsBase.path("policies"), false);
            tenants.sort(null);
            return tenants;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get tenants list", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
    }

    @GET
    @Path(value="/{tenant}")
    @ApiOperation(value="Get the admin configuration for a given tenant.")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="Tenant does not exist")})
    public TenantInfo getTenantAdmin(@PathParam(value="tenant") String tenant) {
        this.validateSuperUserAccess();
        try {
            return (TenantInfo)this.tenantsCache().get(TenantsBase.path("policies", tenant)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Tenant does not exist"));
        }
        catch (Exception e) {
            log.error("[{}] Failed to get tenant {}", new Object[]{this.clientAppId(), tenant, e});
            throw new RestException(e);
        }
    }

    @PUT
    @Path(value="/{tenant}")
    @ApiOperation(value="Create a new tenant.", notes="This operation requires Pulsar super-user privileges.")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=409, message="Tenant already exists"), @ApiResponse(code=412, message="Tenant name is not valid")})
    public void createTenant(@PathParam(value="tenant") String tenant, TenantInfo config) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        try {
            NamedEntity.checkName((String)tenant);
            this.zkCreate(TenantsBase.path("policies", tenant), TenantsBase.jsonMapper().writeValueAsBytes((Object)config));
            log.info("[{}] Created tenant {}", (Object)this.clientAppId(), (Object)tenant);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            log.warn("[{}] Failed to create already existing tenant {}", (Object)this.clientAppId(), (Object)tenant);
            throw new RestException(Response.Status.CONFLICT, "Tenant already exists");
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Failed to create tenant with invalid name {}", new Object[]{this.clientAppId(), tenant, e});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Tenant name is not valid");
        }
        catch (Exception e) {
            log.error("[{}] Failed to create tenant {}", new Object[]{this.clientAppId(), tenant, e});
            throw new RestException(e);
        }
    }

    @POST
    @Path(value="/{tenant}")
    @ApiOperation(value="Update the admins for a tenant.", notes="This operation requires Pulsar super-user privileges.")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="Tenant does not exist"), @ApiResponse(code=409, message="Tenant already exists")})
    public void updateTenant(@PathParam(value="tenant") String tenant, TenantInfo newTenantAdmin) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        Stat nodeStat = new Stat();
        try {
            byte[] content = this.globalZk().getData(TenantsBase.path("policies", tenant), null, nodeStat);
            TenantInfo oldTenantAdmin = (TenantInfo)TenantsBase.jsonMapper().readValue(content, TenantInfo.class);
            ArrayList clustersWithActiveNamespaces = Lists.newArrayList();
            if (oldTenantAdmin.getAllowedClusters().size() > newTenantAdmin.getAllowedClusters().size()) {
                oldTenantAdmin.getAllowedClusters().removeAll(newTenantAdmin.getAllowedClusters());
                log.debug("Following clusters are being removed : [{}]", (Object)oldTenantAdmin.getAllowedClusters());
                for (String cluster : oldTenantAdmin.getAllowedClusters()) {
                    List<Object> activeNamespaces = Lists.newArrayList();
                    try {
                        activeNamespaces = this.globalZk().getChildren(TenantsBase.path("policies", tenant, cluster), false);
                        if (activeNamespaces.size() == 0) continue;
                        clustersWithActiveNamespaces.add(cluster);
                    }
                    catch (KeeperException.NoNodeException noNodeException) {}
                }
                if (!clustersWithActiveNamespaces.isEmpty()) {
                    String msg = String.format("Failed to update the tenant because active namespaces are present in colos %s. Please delete those namespaces first", clustersWithActiveNamespaces);
                    throw new RestException(Response.Status.CONFLICT, msg);
                }
            }
            String tenantPath = TenantsBase.path("policies", tenant);
            this.globalZk().setData(tenantPath, TenantsBase.jsonMapper().writeValueAsBytes((Object)newTenantAdmin), -1);
            this.globalZkCache().invalidate(tenantPath);
            log.info("[{}] updated tenant {}", (Object)this.clientAppId(), (Object)tenant);
        }
        catch (RestException re) {
            throw re;
        }
        catch (KeeperException.NoNodeException noNodeException) {
            log.warn("[{}] Failed to update tenant {}: does not exist", (Object)this.clientAppId(), (Object)tenant);
            throw new RestException(Response.Status.NOT_FOUND, "Tenant does not exist");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update tenant {}", new Object[]{this.clientAppId(), tenant, e});
            throw new RestException(e);
        }
    }

    @DELETE
    @Path(value="/{tenant}")
    @ApiOperation(value="Delete a tenant and all namespaces and topics under it.")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="Tenant does not exist"), @ApiResponse(code=409, message="The tenant still has active namespaces")})
    public void deleteTenant(@PathParam(value="tenant") String tenant) {
        boolean isTenantEmpty;
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        try {
            isTenantEmpty = this.getListOfNamespaces(tenant).isEmpty();
        }
        catch (KeeperException.NoNodeException noNodeException) {
            log.warn("[{}] Failed to delete tenant {}: does not exist", (Object)this.clientAppId(), (Object)tenant);
            throw new RestException(Response.Status.NOT_FOUND, "The tenant does not exist");
        }
        catch (Exception e) {
            log.error("[{}] Failed to get tenant status {}", new Object[]{this.clientAppId(), tenant, e});
            throw new RestException(e);
        }
        if (!isTenantEmpty) {
            log.warn("[{}] Failed to delete tenant {}: not empty", (Object)this.clientAppId(), (Object)tenant);
            throw new RestException(Response.Status.CONFLICT, "The tenant still has active namespaces");
        }
        try {
            for (String cluster : this.globalZk().getChildren(TenantsBase.path("policies", tenant), false)) {
                this.globalZk().delete(TenantsBase.path("policies", tenant, cluster), -1);
            }
            this.globalZk().delete(TenantsBase.path("policies", tenant), -1);
            log.info("[{}] Deleted tenant {}", (Object)this.clientAppId(), (Object)tenant);
        }
        catch (Exception e) {
            log.error("[{}] Failed to delete tenant {}", new Object[]{this.clientAppId(), tenant, e});
            throw new RestException(e);
        }
    }
}

