/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.admin.impl.PersistentTopicsBase;
import org.apache.pulsar.client.admin.LongRunningProcessStatus;
import org.apache.pulsar.client.admin.OffloadProcessStatus;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.PartitionedTopicStats;
import org.apache.pulsar.common.policies.data.PersistentOfflineTopicStats;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.TopicStats;

@Path(value="/persistent")
@Produces(value={"application/json"})
@Api(value="/persistent", description="Persistent topic admin apis", tags={"persistent topic"})
public class PersistentTopics
extends PersistentTopicsBase {
    @GET
    @Path(value="/{tenant}/{namespace}")
    @ApiOperation(value="Get the list of topics under a namespace.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist")})
    public List<String> getList(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetList();
    }

    @GET
    @Path(value="/{tenant}/{namespace}/partitioned")
    @ApiOperation(value="Get the list of partitioned topics under a namespace.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist")})
    public List<String> getPartitionedTopicList(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetPartitionedTopicList();
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/permissions")
    @ApiOperation(value="Get permissions on a topic.", notes="Retrieve the effective permissions for a topic. These permissions are defined by the permissions set at thenamespace level combined (union) with any eventual specific permission set on the topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist")})
    public Map<String, Set<AuthAction>> getPermissionsOnTopic(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalGetPermissionsOnTopic();
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/permissions/{role}")
    @ApiOperation(value="Grant a new permission to a role on a single topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void grantPermissionsOnTopic(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="role") String role, Set<AuthAction> actions) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalGrantPermissionsOnTopic(role, actions);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/permissions/{role}")
    @ApiOperation(value="Revoke permissions on a topic.", notes="Revoke permissions to a role on a single topic. If the permission was not set at the topiclevel, but rather at the namespace level, this operation will return an error (HTTP status code 412).")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=412, message="Permissions are not set at the topic level")})
    public void revokePermissionsOnTopic(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="role") String role) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalRevokePermissionsOnTopic(role);
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{topic}/partitions")
    @ApiOperation(value="Create a partitioned topic.", notes="It needs to be called before creating a producer on a partitioned topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Partitioned topic already exist")})
    public void createPartitionedTopic(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, int numPartitions, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalCreatePartitionedTopic(numPartitions, authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/partitions")
    @ApiOperation(value="Increment partitons of an existing partitioned topic.", notes="It only increments partitions of existing non-global partitioned-topic")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Partitioned topic does not exist")})
    public void updatePartitionedTopic(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, int numPartitions) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalUpdatePartitionedTopic(numPartitions);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/partitions")
    @ApiOperation(value="Get partitioned topic metadata.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public PartitionedTopicMetadata getPartitionedMetadata(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalGetPartitionedMetadata(authoritative);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/partitions")
    @ApiOperation(value="Delete a partitioned topic.", notes="It will also delete all the partitions of the topic if it exists.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Partitioned topic does not exist")})
    public void deletePartitionedTopic(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="force") @DefaultValue(value="false") boolean force, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalDeletePartitionedTopic(authoritative, force);
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{topic}/unload")
    @ApiOperation(value="Unload a topic")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist")})
    public void unloadTopic(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalUnloadTopic(authoritative);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}")
    @ApiOperation(value="Delete a topic.", notes="The topic cannot be deleted if delete is not forcefully and there's any active subscription or producer connected to the it. Force delete ignores connected clients and deletes topic by explicitly closing them.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Topic has active producers/subscriptions")})
    public void deleteTopic(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="force") @DefaultValue(value="false") boolean force, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalDeleteTopic(authoritative, force);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/subscriptions")
    @ApiOperation(value="Get the list of persistent subscriptions for a given topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist")})
    public List<String> getSubscriptions(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalGetSubscriptions(authoritative);
    }

    @GET
    @Path(value="{tenant}/{namespace}/{topic}/stats")
    @ApiOperation(value="Get the stats for the topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist")})
    public TopicStats getStats(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalGetStats(authoritative);
    }

    @GET
    @Path(value="{tenant}/{namespace}/{topic}/internalStats")
    @ApiOperation(value="Get the internal stats for the topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist")})
    public PersistentTopicInternalStats getInternalStats(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalGetInternalStats(authoritative);
    }

    @GET
    @Path(value="{tenant}/{namespace}/{topic}/internal-info")
    @ApiOperation(value="Get the internal stats for the topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist")})
    public void getManagedLedgerInfo(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @Suspended AsyncResponse asyncResponse) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalGetManagedLedgerInfo(asyncResponse);
    }

    @GET
    @Path(value="{tenant}/{namespace}/{topic}/partitioned-stats")
    @ApiOperation(value="Get the stats for the partitioned topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist")})
    public PartitionedTopicStats getPartitionedStats(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalGetPartitionedStats(authoritative);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}")
    @ApiOperation(value="Delete a subscription.", notes="There should not be any active consumers on the subscription.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Subscription has active consumers")})
    public void deleteSubscription(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="subName") String subName, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalDeleteSubscription(subName, authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}/skip_all")
    @ApiOperation(value="Skip all messages on a topic subscription.", notes="Completely clears the backlog on the subscription.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=405, message="Operation not allowed on non-persistent topic"), @ApiResponse(code=404, message="Topic or subscription does not exist")})
    public void skipAllMessages(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="subName") String subName, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalSkipAllMessages(subName, authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}/skip/{numMessages}")
    @ApiOperation(value="Skip messages on a topic subscription.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic or subscription does not exist")})
    public void skipMessages(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="subName") String subName, @PathParam(value="numMessages") int numMessages, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalSkipMessages(subName, numMessages, authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}/expireMessages/{expireTimeInSeconds}")
    @ApiOperation(value="Expire messages on a topic subscription.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic or subscription does not exist")})
    public void expireTopicMessages(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="subName") String subName, @PathParam(value="expireTimeInSeconds") int expireTimeInSeconds, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalExpireMessages(subName, expireTimeInSeconds, authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/all_subscription/expireMessages/{expireTimeInSeconds}")
    @ApiOperation(value="Expire messages on all subscriptions of topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic or subscription does not exist")})
    public void expireMessagesForAllSubscriptions(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="expireTimeInSeconds") int expireTimeInSeconds, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalExpireMessagesForAllSubscriptions(expireTimeInSeconds, authoritative);
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subscriptionName}")
    @ApiOperation(value="Reset subscription to message position closest to given position.", notes="Creates a subscription on the topic at the specified message id")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic/Subscription does not exist"), @ApiResponse(code=405, message="Not supported for partitioned topics")})
    public void createSubscription(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String topic, @PathParam(value="subscriptionName") String subscriptionName, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, MessageIdImpl messageId) {
        this.validateTopicName(tenant, namespace, topic);
        this.internalCreateSubscription(subscriptionName, messageId, authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}/resetcursor/{timestamp}")
    @ApiOperation(value="Reset subscription to message position closest to absolute timestamp (in ms).", notes="It fence cursor and disconnects all active consumers before reseting cursor.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic/Subscription does not exist")})
    public void resetCursor(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="subName") String subName, @PathParam(value="timestamp") long timestamp, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalResetCursor(subName, timestamp, authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}/resetcursor")
    @ApiOperation(value="Reset subscription to message position closest to given position.", notes="It fence cursor and disconnects all active consumers before reseting cursor.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic/Subscription does not exist"), @ApiResponse(code=405, message="Not supported for partitioned topics")})
    public void resetCursorOnPosition(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="subName") String subName, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, MessageIdImpl messageId) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalResetCursorOnPosition(subName, authoritative, messageId);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}/position/{messagePosition}")
    @ApiOperation(value="Peek nth message on a topic subscription.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic, subscription or the message position does not exist")})
    public Response peekNthMessage(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="subName") String subName, @PathParam(value="messagePosition") int messagePosition, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalPeekNthMessage(subName, messagePosition, authoritative);
    }

    @GET
    @Path(value="{tenant}/{namespace}/{topic}/backlog")
    @ApiOperation(value="Get estimated backlog for offline topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public PersistentOfflineTopicStats getBacklog(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalGetBacklog(authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/terminate")
    @ApiOperation(value="Terminate a topic. A topic that is terminated will not accept any more messages to be published and will let consumer to drain existing messages in backlog")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=405, message="Operation not allowed on non-persistent topic"), @ApiResponse(code=404, message="Topic does not exist")})
    public MessageId terminate(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalTerminate(authoritative);
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{topic}/compaction")
    @ApiOperation(value="Trigger a compaction operation on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=405, message="Operation not allowed on persistent topic"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=409, message="Compaction already running")})
    public void compact(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalTriggerCompaction(authoritative);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/compaction")
    @ApiOperation(value="Get the status of a compaction operation for a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=405, message="Operation not allowed on persistent topic"), @ApiResponse(code=404, message="Topic does not exist, or compaction hasn't run")})
    public LongRunningProcessStatus compactionStatus(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalCompactionStatus(authoritative);
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{topic}/offload")
    @ApiOperation(value="Offload a prefix of a topic to long term storage")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=405, message="Operation not allowed on persistent topic"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=409, message="Offload already running")})
    public void triggerOffload(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, MessageIdImpl messageId) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalTriggerOffload(authoritative, messageId);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/offload")
    @ApiOperation(value="Offload a prefix of a topic to long term storage")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=405, message="Operation not allowed on persistent topic"), @ApiResponse(code=404, message="Topic does not exist")})
    public OffloadProcessStatus offloadStatus(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalOffloadStatus(authoritative);
    }
}

