/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import io.swagger.annotations.ApiOperation;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.service.schema.IncompatibleSchemaException;
import org.apache.pulsar.broker.service.schema.LongSchemaVersion;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.schema.DeleteSchemaResponse;
import org.apache.pulsar.common.schema.GetSchemaResponse;
import org.apache.pulsar.common.schema.PostSchemaPayload;
import org.apache.pulsar.common.schema.PostSchemaResponse;
import org.apache.pulsar.common.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.common.schema.SchemaVersion;
import org.apache.pulsar.common.util.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/schemas")
public class SchemasResource
extends AdminResource {
    private static final Logger log = LoggerFactory.getLogger(SchemasResource.class);
    private final Clock clock;

    public SchemasResource() {
        this(Clock.systemUTC());
    }

    @VisibleForTesting
    public SchemasResource(Clock clock) {
        this.clock = clock;
    }

    private long getLongSchemaVersion(SchemaVersion schemaVersion) {
        if (schemaVersion instanceof LongSchemaVersion) {
            return ((LongSchemaVersion)schemaVersion).getVersion();
        }
        return -1L;
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/schema")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get topic schema", response=GetSchemaResponse.class)
    public void getSchema(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @Suspended AsyncResponse response) {
        this.validateDestinationAndAdminOperation(tenant, namespace, topic);
        String schemaId = this.buildSchemaId(tenant, namespace, topic);
        this.pulsar().getSchemaRegistryService().getSchema(schemaId).handle((schema, error) -> {
            if (Objects.isNull(error)) {
                if (Objects.isNull(schema)) {
                    response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
                } else if (schema.schema.isDeleted()) {
                    response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
                } else {
                    response.resume((Object)Response.ok().encoding("application/json").entity((Object)GetSchemaResponse.builder().version(this.getLongSchemaVersion(schema.version)).type(schema.schema.getType()).timestamp(schema.schema.getTimestamp()).data(new String(schema.schema.getData())).properties(schema.schema.getProps()).build()).build());
                }
            } else {
                response.resume(error);
            }
            return null;
        });
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/schema/{version}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get topic schema")
    public void getSchema(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @PathParam(value="version") @Encoded String version, @Suspended AsyncResponse response) {
        this.validateDestinationAndAdminOperation(tenant, namespace, topic);
        String schemaId = this.buildSchemaId(tenant, namespace, topic);
        ByteBuffer bbVersion = ByteBuffer.allocate(64);
        bbVersion.putLong(Long.parseLong(version));
        SchemaVersion v = this.pulsar().getSchemaRegistryService().versionFromBytes(bbVersion.array());
        this.pulsar().getSchemaRegistryService().getSchema(schemaId, v).handle((schema, error) -> {
            if (Objects.isNull(error)) {
                if (Objects.isNull(schema)) {
                    response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
                } else if (schema.schema.isDeleted()) {
                    response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
                } else {
                    response.resume((Object)Response.ok().encoding("application/json").entity((Object)GetSchemaResponse.builder().version(this.getLongSchemaVersion(schema.version)).type(schema.schema.getType()).timestamp(schema.schema.getTimestamp()).data(new String(schema.schema.getData())).properties(schema.schema.getProps()).build()).build());
                }
            } else {
                response.resume(error);
            }
            return null;
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/schema")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete topic schema")
    public void deleteSchema(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @Suspended AsyncResponse response) {
        this.validateDestinationAndAdminOperation(tenant, namespace, topic);
        String schemaId = this.buildSchemaId(tenant, namespace, topic);
        this.pulsar().getSchemaRegistryService().deleteSchema(schemaId, StringUtils.defaultIfEmpty((String)this.clientAppId(), (String)"")).handle((version, error) -> {
            if (Objects.isNull(error)) {
                response.resume((Object)Response.ok().entity((Object)DeleteSchemaResponse.builder().version(this.getLongSchemaVersion((SchemaVersion)version)).build()).build());
            } else {
                response.resume(error);
            }
            return null;
        });
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/schema")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Post topic schema")
    public void postSchema(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, PostSchemaPayload payload, @Suspended AsyncResponse response) {
        this.validateDestinationAndAdminOperation(tenant, namespace, topic);
        ((CompletableFuture)this.pulsar().getSchemaRegistryService().putSchemaIfAbsent(this.buildSchemaId(tenant, namespace, topic), SchemaData.builder().data(payload.getSchema().getBytes(Charsets.UTF_8)).isDeleted(false).timestamp(this.clock.millis()).type(SchemaType.valueOf((String)payload.getType())).user(StringUtils.defaultIfEmpty((String)this.clientAppId(), (String)"")).build()).thenAccept(version -> {
            boolean bl = response.resume((Object)Response.accepted().entity((Object)PostSchemaResponse.builder().version(version).build()).build());
        })).exceptionally(error -> {
            if (error instanceof IncompatibleSchemaException) {
                response.resume((Object)Response.status((Response.Status)Response.Status.CONFLICT).build());
            } else {
                response.resume((Object)Response.serverError().build());
            }
            return null;
        });
    }

    private String buildSchemaId(String tenant, String namespace, String topic) {
        return TopicName.get((String)"persistent", (String)tenant, (String)namespace, (String)topic).getSchemaName();
    }

    private void validateDestinationAndAdminOperation(String tenant, String namespace, String topic) {
        TopicName destinationName = TopicName.get((String)"persistent", (String)tenant, (String)namespace, (String)Codec.decode((String)topic));
        try {
            this.validateAdminAccessForTenant(destinationName.getTenant());
            this.validateTopicOwnership(destinationName, false);
        }
        catch (RestException e) {
            if (e.getResponse().getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                throw new RestException(Response.Status.NOT_FOUND, "Not Found");
            }
            throw e;
        }
    }
}

