/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.offload.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.pulsar.broker.offload.OffloadIndexBlock;
import org.apache.pulsar.broker.offload.OffloadIndexBlockBuilder;
import org.apache.pulsar.broker.offload.impl.OffloadIndexBlockImpl;
import org.apache.pulsar.broker.offload.impl.OffloadIndexEntryImpl;

public class OffloadIndexBlockBuilderImpl
implements OffloadIndexBlockBuilder {
    private LedgerMetadata ledgerMetadata;
    private long dataObjectLength;
    private long dataHeaderLength;
    private List<OffloadIndexEntryImpl> entries = Lists.newArrayList();
    private int lastBlockSize;

    @Override
    public OffloadIndexBlockBuilder withDataObjectLength(long dataObjectLength) {
        this.dataObjectLength = dataObjectLength;
        return this;
    }

    @Override
    public OffloadIndexBlockBuilder withDataBlockHeaderLength(long dataHeaderLength) {
        this.dataHeaderLength = dataHeaderLength;
        return this;
    }

    @Override
    public OffloadIndexBlockBuilder withLedgerMetadata(LedgerMetadata metadata) {
        this.ledgerMetadata = metadata;
        return this;
    }

    @Override
    public OffloadIndexBlockBuilder addBlock(long firstEntryId, int partId, int blockSize) {
        long offset;
        Preconditions.checkState((this.dataHeaderLength > 0L ? 1 : 0) != 0);
        if (firstEntryId == 0L) {
            Preconditions.checkState((this.entries.size() == 0 ? 1 : 0) != 0);
            offset = 0L;
        } else {
            Preconditions.checkState((this.entries.size() > 0 ? 1 : 0) != 0);
            offset = this.entries.get(this.entries.size() - 1).getOffset() + (long)this.lastBlockSize;
        }
        this.lastBlockSize = blockSize;
        this.entries.add(OffloadIndexEntryImpl.of(firstEntryId, partId, offset, this.dataHeaderLength));
        return this;
    }

    @Override
    public OffloadIndexBlock fromStream(InputStream is) throws IOException {
        return OffloadIndexBlockImpl.get(is);
    }

    @Override
    public OffloadIndexBlock build() {
        Preconditions.checkState((this.ledgerMetadata != null ? 1 : 0) != 0);
        Preconditions.checkState((!this.entries.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((this.dataObjectLength > 0L ? 1 : 0) != 0);
        Preconditions.checkState((this.dataHeaderLength > 0L ? 1 : 0) != 0);
        return OffloadIndexBlockImpl.get(this.ledgerMetadata, this.dataObjectLength, this.dataHeaderLength, this.entries);
    }
}

