/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.offload.impl;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pulsar.broker.offload.BackedInputStream;
import org.apache.pulsar.broker.offload.impl.S3ManagedLedgerOffloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3BackedInputStreamImpl
extends BackedInputStream {
    private static final Logger log = LoggerFactory.getLogger(S3BackedInputStreamImpl.class);
    private final AmazonS3 s3client;
    private final String bucket;
    private final String key;
    private final S3ManagedLedgerOffloader.VersionCheck versionCheck;
    private final ByteBuf buffer;
    private final long objectLen;
    private final int bufferSize;
    private long cursor;
    private long bufferOffsetStart;
    private long bufferOffsetEnd;

    public S3BackedInputStreamImpl(AmazonS3 s3client, String bucket, String key, S3ManagedLedgerOffloader.VersionCheck versionCheck, long objectLen, int bufferSize) {
        this.s3client = s3client;
        this.bucket = bucket;
        this.key = key;
        this.versionCheck = versionCheck;
        this.buffer = PooledByteBufAllocator.DEFAULT.buffer(bufferSize, bufferSize);
        this.objectLen = objectLen;
        this.bufferSize = bufferSize;
        this.cursor = 0L;
        this.bufferOffsetEnd = -1L;
        this.bufferOffsetStart = -1L;
    }

    private boolean refillBufferIfNeeded() throws IOException {
        if (this.buffer.readableBytes() == 0) {
            if (this.cursor >= this.objectLen) {
                return false;
            }
            long startRange = this.cursor;
            long endRange = Math.min(this.cursor + (long)this.bufferSize - 1L, this.objectLen - 1L);
            GetObjectRequest req = new GetObjectRequest(this.bucket, this.key).withRange(startRange, endRange);
            log.debug("Reading range {}-{} from {}/{}", new Object[]{startRange, endRange, this.bucket, this.key});
            try {
                Throwable throwable = null;
                Object var7_7 = null;
                try (S3Object obj = this.s3client.getObject(req);){
                    this.versionCheck.check(this.key, obj.getObjectMetadata());
                    Long[] range = obj.getObjectMetadata().getContentRange();
                    long bytesRead = range[1] - range[0] + 1L;
                    this.buffer.clear();
                    this.bufferOffsetStart = range[0];
                    this.bufferOffsetEnd = range[1];
                    S3ObjectInputStream s = obj.getObjectContent();
                    int bytesToCopy = (int)bytesRead;
                    while (bytesToCopy > 0) {
                        bytesToCopy -= this.buffer.writeBytes((InputStream)s, bytesToCopy);
                    }
                    this.cursor += (long)this.buffer.readableBytes();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (AmazonClientException e) {
                throw new IOException("Error reading from S3", e);
            }
        }
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.refillBufferIfNeeded()) {
            return this.buffer.readUnsignedByte();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.refillBufferIfNeeded()) {
            int bytesToRead = Math.min(len, this.buffer.readableBytes());
            this.buffer.readBytes(b, off, bytesToRead);
            return bytesToRead;
        }
        return -1;
    }

    @Override
    public void seek(long position) {
        log.debug("Seeking to {} on {}/{}, current position {}", new Object[]{position, this.bucket, this.key, this.cursor});
        if (position >= this.bufferOffsetStart && position <= this.bufferOffsetEnd) {
            long newIndex = position - this.bufferOffsetStart;
            this.buffer.readerIndex((int)newIndex);
        } else {
            this.cursor = position;
            this.buffer.clear();
        }
    }

    @Override
    public void seekForward(long position) throws IOException {
        if (position < this.cursor) {
            throw new IOException(String.format("Error seeking, new position %d < current position %d", position, this.cursor));
        }
        this.seek(position);
    }

    @Override
    public void close() {
        this.buffer.release();
    }
}

