/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.SchemaValidationException;
import org.apache.avro.SchemaValidator;
import org.apache.avro.SchemaValidatorBuilder;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaType;

public class AvroSchemaCompatibilityCheck
implements SchemaCompatibilityCheck {
    private final SchemaCompatibilityStrategy compatibilityStrategy;

    public AvroSchemaCompatibilityCheck() {
        this(SchemaCompatibilityStrategy.FULL);
    }

    public AvroSchemaCompatibilityCheck(SchemaCompatibilityStrategy compatibilityStrategy) {
        this.compatibilityStrategy = compatibilityStrategy;
    }

    @Override
    public SchemaType getSchemaType() {
        return SchemaType.AVRO;
    }

    @Override
    public boolean isCompatible(SchemaData from, SchemaData to) {
        Schema.Parser fromParser = new Schema.Parser();
        Schema fromSchema = fromParser.parse(new String(from.getData()));
        Schema.Parser toParser = new Schema.Parser();
        Schema toSchema = toParser.parse(new String(to.getData()));
        SchemaValidator schemaValidator = AvroSchemaCompatibilityCheck.createSchemaValidator(this.compatibilityStrategy, true);
        try {
            schemaValidator.validate(toSchema, Arrays.asList(fromSchema));
        }
        catch (SchemaValidationException schemaValidationException) {
            return false;
        }
        return true;
    }

    private static SchemaValidator createSchemaValidator(SchemaCompatibilityStrategy compatibilityStrategy, boolean onlyLatestValidator) {
        SchemaValidatorBuilder validatorBuilder = new SchemaValidatorBuilder();
        switch (compatibilityStrategy) {
            case BACKWARD: {
                return AvroSchemaCompatibilityCheck.createLatestOrAllValidator(validatorBuilder.canReadStrategy(), onlyLatestValidator);
            }
            case FORWARD: {
                return AvroSchemaCompatibilityCheck.createLatestOrAllValidator(validatorBuilder.canBeReadStrategy(), onlyLatestValidator);
            }
        }
        return AvroSchemaCompatibilityCheck.createLatestOrAllValidator(validatorBuilder.mutualReadStrategy(), onlyLatestValidator);
    }

    private static SchemaValidator createLatestOrAllValidator(SchemaValidatorBuilder validatorBuilder, boolean onlyLatest) {
        return onlyLatest ? validatorBuilder.validateLatest() : validatorBuilder.validateAll();
    }
}

