/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.schema.DefaultSchemaRegistryService;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.SchemaRegistry;
import org.apache.pulsar.broker.service.schema.SchemaRegistryServiceImpl;
import org.apache.pulsar.broker.service.schema.SchemaStorage;
import org.apache.pulsar.common.schema.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SchemaRegistryService
extends SchemaRegistry {
    public static final String CreateMethodName = "create";
    public static final Logger log = LoggerFactory.getLogger(SchemaRegistryService.class);

    public static Map<SchemaType, SchemaCompatibilityCheck> getCheckers(Set<String> checkerClasses) throws Exception {
        HashMap checkers = Maps.newHashMap();
        for (String className : checkerClasses) {
            Class<?> checkerClass = Class.forName(className);
            SchemaCompatibilityCheck instance = (SchemaCompatibilityCheck)checkerClass.newInstance();
            checkers.put(instance.getSchemaType(), instance);
        }
        return checkers;
    }

    public static SchemaRegistryService create(PulsarService pulsar) {
        try {
            ServiceConfiguration config = pulsar.getConfiguration();
            Class<?> storageClass = Class.forName(config.getSchemaRegistryStorageClassName());
            Object factoryInstance = storageClass.newInstance();
            Method createMethod = storageClass.getMethod(CreateMethodName, PulsarService.class);
            SchemaStorage schemaStorage = (SchemaStorage)createMethod.invoke(factoryInstance, pulsar);
            Map<SchemaType, SchemaCompatibilityCheck> checkers = SchemaRegistryService.getCheckers(config.getSchemaRegistryCompatibilityCheckers());
            schemaStorage.start();
            return new SchemaRegistryServiceImpl(schemaStorage, checkers);
        }
        catch (Exception e) {
            log.warn("Unable to create schema registry storage, defaulting to empty storage: {}", (Throwable)e);
            return new DefaultSchemaRegistryService();
        }
    }

    @Override
    public void close() throws Exception;
}

