/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.RawMessage;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.RawMessageImpl;
import org.apache.pulsar.common.api.Commands;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.common.compression.CompressionCodecProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawBatchConverter {
    private static final Logger log = LoggerFactory.getLogger(RawBatchConverter.class);

    public static boolean isReadableBatch(RawMessage msg) {
        ByteBuf payload = msg.getHeadersAndPayload();
        PulsarApi.MessageMetadata metadata = Commands.parseMessageMetadata((ByteBuf)payload);
        try {
            boolean bl = metadata.hasNumMessagesInBatch() && metadata.getEncryptionKeysCount() == 0;
            return bl;
        }
        finally {
            metadata.recycle();
        }
    }

    public static List<ImmutablePair<MessageId, String>> extractIdsAndKeys(RawMessage msg) throws IOException {
        Preconditions.checkArgument((msg.getMessageIdData().getBatchIndex() == -1 ? 1 : 0) != 0);
        ByteBuf payload = msg.getHeadersAndPayload();
        PulsarApi.MessageMetadata metadata = Commands.parseMessageMetadata((ByteBuf)payload);
        int batchSize = metadata.getNumMessagesInBatch();
        PulsarApi.CompressionType compressionType = metadata.getCompression();
        CompressionCodec codec = CompressionCodecProvider.getCompressionCodec((PulsarApi.CompressionType)compressionType);
        int uncompressedSize = metadata.getUncompressedSize();
        ByteBuf uncompressedPayload = codec.decode(payload, uncompressedSize);
        metadata.recycle();
        ArrayList<ImmutablePair<MessageId, String>> idsAndKeys = new ArrayList<ImmutablePair<MessageId, String>>();
        int i = 0;
        while (i < batchSize) {
            PulsarApi.SingleMessageMetadata.Builder singleMessageMetadataBuilder = PulsarApi.SingleMessageMetadata.newBuilder();
            ByteBuf singleMessagePayload = Commands.deSerializeSingleMessageInBatch((ByteBuf)uncompressedPayload, (PulsarApi.SingleMessageMetadata.Builder)singleMessageMetadataBuilder, (int)0, (int)batchSize);
            BatchMessageIdImpl id = new BatchMessageIdImpl(msg.getMessageIdData().getLedgerId(), msg.getMessageIdData().getEntryId(), msg.getMessageIdData().getPartition(), i);
            if (!singleMessageMetadataBuilder.getCompactedOut()) {
                idsAndKeys.add((ImmutablePair<MessageId, String>)ImmutablePair.of((Object)id, (Object)singleMessageMetadataBuilder.getPartitionKey()));
            }
            singleMessageMetadataBuilder.recycle();
            singleMessagePayload.release();
            ++i;
        }
        uncompressedPayload.release();
        return idsAndKeys;
    }

    public static Optional<RawMessage> rebatchMessage(RawMessage msg, BiPredicate<String, MessageId> filter) throws IOException {
        Preconditions.checkArgument((msg.getMessageIdData().getBatchIndex() == -1 ? 1 : 0) != 0);
        ByteBuf payload = msg.getHeadersAndPayload();
        PulsarApi.MessageMetadata metadata = Commands.parseMessageMetadata((ByteBuf)payload);
        ByteBuf batchBuffer = PooledByteBufAllocator.DEFAULT.buffer(payload.capacity());
        PulsarApi.CompressionType compressionType = metadata.getCompression();
        CompressionCodec codec = CompressionCodecProvider.getCompressionCodec((PulsarApi.CompressionType)compressionType);
        int uncompressedSize = metadata.getUncompressedSize();
        ByteBuf uncompressedPayload = codec.decode(payload, uncompressedSize);
        try {
            int batchSize = metadata.getNumMessagesInBatch();
            int messagesRetained = 0;
            PulsarApi.SingleMessageMetadata.Builder emptyMetadataBuilder = PulsarApi.SingleMessageMetadata.newBuilder().setCompactedOut(true);
            int i = 0;
            while (i < batchSize) {
                PulsarApi.SingleMessageMetadata.Builder singleMessageMetadataBuilder = PulsarApi.SingleMessageMetadata.newBuilder();
                ByteBuf singleMessagePayload = Commands.deSerializeSingleMessageInBatch((ByteBuf)uncompressedPayload, (PulsarApi.SingleMessageMetadata.Builder)singleMessageMetadataBuilder, (int)0, (int)batchSize);
                BatchMessageIdImpl id = new BatchMessageIdImpl(msg.getMessageIdData().getLedgerId(), msg.getMessageIdData().getEntryId(), msg.getMessageIdData().getPartition(), i);
                if (!singleMessageMetadataBuilder.hasPartitionKey()) {
                    ++messagesRetained;
                    Commands.serializeSingleMessageInBatchWithPayload((PulsarApi.SingleMessageMetadata.Builder)singleMessageMetadataBuilder, (ByteBuf)singleMessagePayload, (ByteBuf)batchBuffer);
                } else if (filter.test(singleMessageMetadataBuilder.getPartitionKey(), (MessageId)id) && singleMessagePayload.readableBytes() > 0) {
                    ++messagesRetained;
                    Commands.serializeSingleMessageInBatchWithPayload((PulsarApi.SingleMessageMetadata.Builder)singleMessageMetadataBuilder, (ByteBuf)singleMessagePayload, (ByteBuf)batchBuffer);
                } else {
                    Commands.serializeSingleMessageInBatchWithPayload((PulsarApi.SingleMessageMetadata.Builder)emptyMetadataBuilder, (ByteBuf)Unpooled.EMPTY_BUFFER, (ByteBuf)batchBuffer);
                }
                singleMessageMetadataBuilder.recycle();
                singleMessagePayload.release();
                ++i;
            }
            emptyMetadataBuilder.recycle();
            if (messagesRetained > 0) {
                int newUncompressedSize = batchBuffer.readableBytes();
                ByteBuf compressedPayload = codec.encode(batchBuffer);
                PulsarApi.MessageMetadata.Builder metadataBuilder = metadata.toBuilder();
                metadataBuilder.setUncompressedSize(newUncompressedSize);
                PulsarApi.MessageMetadata newMetadata = metadataBuilder.build();
                ByteBuf metadataAndPayload = Commands.serializeMetadataAndPayload((Commands.ChecksumType)Commands.ChecksumType.Crc32c, (PulsarApi.MessageMetadata)newMetadata, (ByteBuf)compressedPayload);
                Optional<RawMessage> result = Optional.of(new RawMessageImpl(msg.getMessageIdData(), metadataAndPayload));
                metadataBuilder.recycle();
                newMetadata.recycle();
                metadataAndPayload.release();
                compressedPayload.release();
                Optional<RawMessage> optional = result;
                return optional;
            }
            Optional<RawMessage> optional = Optional.empty();
            return optional;
        }
        finally {
            batchBuffer.release();
            metadata.recycle();
            msg.close();
        }
    }
}

