/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.naming.NamedEntity;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantsBase
extends PulsarWebResource {
    private static final Logger log = LoggerFactory.getLogger(TenantsBase.class);

    @GET
    @ApiOperation(value="Get the list of existing tenants.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="Tenant doesn't exist")})
    public void getTenants(@Suspended AsyncResponse asyncResponse) {
        String clientAppId = this.clientAppId();
        try {
            this.validateSuperUserAccess();
        }
        catch (Exception e2) {
            asyncResponse.resume((Throwable)e2);
            return;
        }
        this.tenantResources().listTenantsAsync().whenComplete((tenants, e) -> {
            if (e != null) {
                log.error("[{}] Failed to get tenants list", (Object)clientAppId, e);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)e)));
                return;
            }
            ArrayList deepCopy = new ArrayList(tenants);
            deepCopy.sort(null);
            asyncResponse.resume(deepCopy);
        });
    }

    @GET
    @Path(value="/{tenant}")
    @ApiOperation(value="Get the admin configuration for a given tenant.")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="Tenant does not exist")})
    public void getTenantAdmin(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The tenant name") @PathParam(value="tenant") String tenant) {
        String clientAppId = this.clientAppId();
        try {
            this.validateSuperUserAccess();
        }
        catch (Exception e2) {
            asyncResponse.resume((Throwable)e2);
        }
        this.tenantResources().getTenantAsync(tenant).whenComplete((tenantInfo, e) -> {
            if (e != null) {
                log.error("[{}] Failed to get Tenant {}", (Object)clientAppId, (Object)e.getMessage());
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.INTERNAL_SERVER_ERROR, "Failed to get Tenant")));
                return;
            }
            boolean response = tenantInfo.isPresent() ? asyncResponse.resume(tenantInfo.get()) : asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Tenant does not exist")));
        });
    }

    @PUT
    @Path(value="/{tenant}")
    @ApiOperation(value="Create a new tenant.", notes="This operation requires Pulsar super-user privileges.")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=409, message="Tenant already exists"), @ApiResponse(code=412, message="Tenant name is not valid"), @ApiResponse(code=412, message="Clusters can not be empty"), @ApiResponse(code=412, message="Clusters do not exist")})
    public void createTenant(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The tenant name") @PathParam(value="tenant") String tenant, @ApiParam(value="TenantInfo") TenantInfoImpl tenantInfo) {
        String clientAppId = this.clientAppId();
        try {
            this.validateSuperUserAccess();
            this.validatePoliciesReadOnlyAccess();
            this.validateClusters((TenantInfo)tenantInfo);
            NamedEntity.checkName((String)tenant);
        }
        catch (IllegalArgumentException e2) {
            log.warn("[{}] Failed to create tenant with invalid name {}", new Object[]{this.clientAppId(), tenant, e2});
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Tenant name is not valid")));
            return;
        }
        catch (Exception e3) {
            asyncResponse.resume((Throwable)e3);
            return;
        }
        this.tenantResources().listTenantsAsync().whenComplete((tenants, e) -> {
            if (e != null) {
                log.error("[{}] Failed to create tenant ", (Object)clientAppId, (Object)e.getCause());
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)e)));
                return;
            }
            int maxTenants = this.pulsar().getConfiguration().getMaxTenants();
            if (maxTenants > 0 && tenants != null && tenants.size() >= maxTenants) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Exceed the maximum number of tenants")));
                return;
            }
            ((CompletableFuture)this.tenantResources().tenantExistsAsync(tenant).thenAccept(exist -> {
                if (exist.booleanValue()) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.CONFLICT, "Tenant already exist")));
                    return;
                }
                ((CompletableFuture)this.tenantResources().createTenantAsync(tenant, (TenantInfo)tenantInfo).thenAccept(r -> {
                    log.info("[{}] Created tenant {}", (Object)this.clientAppId(), (Object)tenant);
                    asyncResponse.resume((Object)Response.noContent().build());
                })).exceptionally(ex -> {
                    log.error("[{}] Failed to create tenant {}", new Object[]{clientAppId, tenant, ex});
                    asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
                    return null;
                });
            })).exceptionally(ex -> {
                log.error("[{}] Failed to create tenant {}", new Object[]{this.clientAppId(), tenant, ex});
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
                return null;
            });
        });
    }

    @POST
    @Path(value="/{tenant}")
    @ApiOperation(value="Update the admins for a tenant.", notes="This operation requires Pulsar super-user privileges.")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="Tenant does not exist"), @ApiResponse(code=409, message="Tenant already exists"), @ApiResponse(code=412, message="Clusters can not be empty"), @ApiResponse(code=412, message="Clusters do not exist")})
    public void updateTenant(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The tenant name") @PathParam(value="tenant") String tenant, @ApiParam(value="TenantInfo") TenantInfoImpl newTenantAdmin) {
        try {
            this.validateSuperUserAccess();
            this.validatePoliciesReadOnlyAccess();
            this.validateClusters((TenantInfo)newTenantAdmin);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)e);
            return;
        }
        String clientAddId = this.clientAppId();
        ((CompletableFuture)this.tenantResources().getTenantAsync(tenant).thenAccept(tenantAdmin -> {
            if (!tenantAdmin.isPresent()) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Tenant " + tenant + " not found")));
                return;
            }
            TenantInfo oldTenantAdmin = (TenantInfo)tenantAdmin.get();
            HashSet<String> newClusters = new HashSet<String>(newTenantAdmin.getAllowedClusters());
            ((CompletableFuture)this.canUpdateCluster(tenant, oldTenantAdmin.getAllowedClusters(), newClusters).thenApply(r -> {
                ((CompletableFuture)this.tenantResources().updateTenantAsync(tenant, old -> newTenantAdmin).thenAccept(done -> {
                    log.info("Successfully updated tenant info {}", (Object)tenant);
                    asyncResponse.resume((Object)Response.noContent().build());
                })).exceptionally(ex -> {
                    log.warn("Failed to update tenant {}", (Object)tenant, (Object)ex.getCause());
                    asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
                    return null;
                });
                return null;
            })).exceptionally(nsEx -> {
                asyncResponse.resume(nsEx.getCause());
                return null;
            });
        })).exceptionally(ex -> {
            log.error("[{}] Failed to get tenant {}", new Object[]{clientAddId, tenant, ex.getCause()});
            asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            return null;
        });
    }

    @DELETE
    @Path(value="/{tenant}")
    @ApiOperation(value="Delete a tenant and all namespaces and topics under it.")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="Tenant does not exist"), @ApiResponse(code=405, message="Broker doesn't allow forced deletion of tenants"), @ApiResponse(code=409, message="The tenant still has active namespaces")})
    public void deleteTenant(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") @ApiParam(value="The tenant name") String tenant, @QueryParam(value="force") @DefaultValue(value="false") boolean force) {
        try {
            this.validateSuperUserAccess();
            this.validatePoliciesReadOnlyAccess();
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)e);
            return;
        }
        this.internalDeleteTenant(asyncResponse, tenant, force);
    }

    protected void internalDeleteTenant(AsyncResponse asyncResponse, String tenant, boolean force) {
        if (force) {
            this.internalDeleteTenantForcefully(asyncResponse, tenant);
        } else {
            this.internalDeleteTenant(asyncResponse, tenant);
        }
    }

    protected void internalDeleteTenant(AsyncResponse asyncResponse, String tenant) {
        this.tenantResources().tenantExistsAsync(tenant).thenApply(exists -> {
            if (!exists.booleanValue()) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Tenant doesn't exist")));
                return null;
            }
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.hasActiveNamespace(tenant).thenCompose(ignore -> this.tenantResources().deleteTenantAsync(tenant))).thenCompose(ignore -> this.pulsar().getPulsarResources().getTopicResources().clearTenantPersistence(tenant))).thenCompose(ignore -> this.pulsar().getPulsarResources().getNamespaceResources().deleteTenantAsync(tenant))).thenCompose(ignore -> this.pulsar().getPulsarResources().getNamespaceResources().getPartitionedTopicResources().clearPartitionedTopicTenantAsync(tenant))).thenCompose(ignore -> this.pulsar().getPulsarResources().getLocalPolicies().deleteLocalPoliciesTenantAsync(tenant))).thenCompose(ignore -> this.pulsar().getPulsarResources().getNamespaceResources().deleteBundleDataTenantAsync(tenant))).whenComplete((ignore, ex) -> {
                if (ex != null) {
                    log.error("[{}] Failed to delete tenant {}", new Object[]{this.clientAppId(), tenant, ex});
                    if (ex.getCause() instanceof IllegalStateException) {
                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.CONFLICT, ex.getCause())));
                    } else {
                        asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
                    }
                } else {
                    log.info("[{}] Deleted tenant {}", (Object)this.clientAppId(), (Object)tenant);
                    asyncResponse.resume((Object)Response.noContent().build());
                }
            });
        });
    }

    protected void internalDeleteTenantForcefully(AsyncResponse asyncResponse, String tenant) {
        List namespaces;
        if (!this.pulsar().getConfiguration().isForceDeleteTenantAllowed()) {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Broker doesn't allow forced deletion of tenants")));
            return;
        }
        try {
            namespaces = this.tenantResources().getListOfNamespaces(tenant);
        }
        catch (Exception e) {
            log.error("[{}] Failed to get namespaces list of {}", new Object[]{this.clientAppId(), tenant, e});
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
            return;
        }
        ArrayList futures = Lists.newArrayList();
        try {
            for (String namespace : namespaces) {
                futures.add(this.pulsar().getAdminClient().namespaces().deleteNamespaceAsync(namespace, true));
            }
        }
        catch (Exception e) {
            log.error("[{}] Failed to force delete namespaces {}", new Object[]{this.clientAppId(), namespaces, e});
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
        FutureUtil.waitForAll((List)futures).handle((result, exception) -> {
            if (exception != null) {
                if (exception.getCause() instanceof PulsarAdminException) {
                    asyncResponse.resume((Throwable)((Object)new RestException((PulsarAdminException)exception.getCause())));
                } else {
                    log.error("[{}] Failed to force delete namespaces {}", new Object[]{this.clientAppId(), namespaces, exception});
                    asyncResponse.resume((Throwable)((Object)new RestException(exception.getCause())));
                }
                return null;
            }
            this.internalDeleteTenant(asyncResponse, tenant);
            asyncResponse.resume((Object)Response.noContent().build());
            return null;
        });
    }

    private void validateClusters(TenantInfo info) {
        List nonexistentClusters;
        if (info == null || info.getAllowedClusters().stream().filter(c -> !StringUtils.isBlank((CharSequence)c)).collect(Collectors.toSet()).isEmpty() || info.getAllowedClusters().stream().anyMatch(ac -> StringUtils.isBlank((CharSequence)ac))) {
            log.warn("[{}] Failed to validate due to clusters are empty", (Object)this.clientAppId());
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Clusters can not be empty");
        }
        try {
            Set availableClusters = this.clusterResources().list();
            Set allowedClusters = info.getAllowedClusters();
            nonexistentClusters = allowedClusters.stream().filter(cluster -> !availableClusters.contains(cluster) && !"global".equals(cluster)).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("[{}] Failed to get available clusters", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
        if (nonexistentClusters.size() > 0) {
            log.warn("[{}] Failed to validate due to clusters {} do not exist", (Object)this.clientAppId(), nonexistentClusters);
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Clusters do not exist");
        }
    }
}

