/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import java.util.ArrayList;
import java.util.List;
import org.apache.pulsar.broker.stats.ReplicationMetrics;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;

public class ClusterReplicationMetrics {
    private final List<Metrics> metricsList = new ArrayList<Metrics>();
    private final String localCluster;
    private final ConcurrentOpenHashMap<String, ReplicationMetrics> metricsMap;
    public static final String SEPARATOR = "_";
    public final boolean metricsEnabled;

    public ClusterReplicationMetrics(String localCluster, boolean metricsEnabled) {
        this.localCluster = localCluster;
        this.metricsMap = new ConcurrentOpenHashMap();
        this.metricsEnabled = metricsEnabled;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public ReplicationMetrics get(String namespaceCluster) {
        return (ReplicationMetrics)this.metricsMap.get((Object)namespaceCluster);
    }

    public void put(String namespaceCluster, ReplicationMetrics replicationMetrics) {
        this.metricsMap.put((Object)namespaceCluster, (Object)replicationMetrics);
    }

    public String getKeyName(String namespace, String cluster) {
        return namespace + SEPARATOR + cluster;
    }

    public void remove(String namespaceCluster) {
        ReplicationMetrics replicationMetrics = (ReplicationMetrics)this.metricsMap.get((Object)namespaceCluster);
        if (replicationMetrics != null) {
            replicationMetrics.recycle();
            this.metricsMap.remove((Object)namespaceCluster);
        }
    }

    public List<Metrics> get() {
        this.generate();
        return this.metricsList;
    }

    private void generate() {
        this.metricsMap.forEach((key, replicationMetrics) -> {
            int splitPoint = key.lastIndexOf(SEPARATOR);
            this.add(key.substring(0, splitPoint), key.substring(splitPoint + 1), (ReplicationMetrics)replicationMetrics);
            replicationMetrics.reset();
        });
    }

    private void add(String namespace, String remote, ReplicationMetrics replicationMetrics) {
        this.metricsList.add(replicationMetrics.add(namespace, this.localCluster, remote));
    }

    public void reset() {
        this.metricsList.clear();
    }
}

