/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer.impl;

import io.netty.util.HashedWheelTimer;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.transaction.buffer.impl.TransactionBufferHandlerImpl;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.transaction.TransactionBufferClient;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.client.impl.transaction.TransactionBufferHandler;
import org.apache.pulsar.common.api.proto.TxnAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBufferClientImpl
implements TransactionBufferClient {
    private static final Logger log = LoggerFactory.getLogger(TransactionBufferClientImpl.class);
    private final TransactionBufferHandler tbHandler;

    private TransactionBufferClientImpl(TransactionBufferHandler tbHandler) {
        this.tbHandler = tbHandler;
    }

    public static TransactionBufferClient create(PulsarClient pulsarClient, HashedWheelTimer timer) {
        TransactionBufferHandlerImpl handler = new TransactionBufferHandlerImpl(pulsarClient, timer);
        return new TransactionBufferClientImpl(handler);
    }

    public CompletableFuture<TxnID> commitTxnOnTopic(String topic, long txnIdMostBits, long txnIdLeastBits, long lowWaterMark) {
        return this.tbHandler.endTxnOnTopic(topic, txnIdMostBits, txnIdLeastBits, TxnAction.COMMIT, lowWaterMark);
    }

    public CompletableFuture<TxnID> abortTxnOnTopic(String topic, long txnIdMostBits, long txnIdLeastBits, long lowWaterMark) {
        return this.tbHandler.endTxnOnTopic(topic, txnIdMostBits, txnIdLeastBits, TxnAction.ABORT, lowWaterMark);
    }

    public CompletableFuture<TxnID> commitTxnOnSubscription(String topic, String subscription, long txnIdMostBits, long txnIdLeastBits, long lowWaterMark) {
        return this.tbHandler.endTxnOnSubscription(topic, subscription, txnIdMostBits, txnIdLeastBits, TxnAction.COMMIT, lowWaterMark);
    }

    public CompletableFuture<TxnID> abortTxnOnSubscription(String topic, String subscription, long txnIdMostBits, long txnIdLeastBits, long lowWaterMark) {
        return this.tbHandler.endTxnOnSubscription(topic, subscription, txnIdMostBits, txnIdLeastBits, TxnAction.ABORT, lowWaterMark);
    }

    public void close() {
        this.tbHandler.close();
    }
}

