/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.admin.impl.NamespacesBase;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.ResourceQuota;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceQuotasBase
extends NamespacesBase {
    private static final Logger log = LoggerFactory.getLogger(ResourceQuotasBase.class);

    public ResourceQuota getDefaultResourceQuota() throws Exception {
        this.validateSuperUserAccess();
        try {
            return this.pulsar().getBrokerService().getBundlesQuotas().getDefaultResourceQuota().get(this.config().getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error("[{}] Failed to get default resource quota", (Object)this.clientAppId());
            throw new RestException(e);
        }
    }

    public void setDefaultResourceQuota(ResourceQuota quota) throws Exception {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        try {
            this.pulsar().getBrokerService().getBundlesQuotas().setDefaultResourceQuota(quota).get(this.config().getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error("[{}] Failed to get default resource quota", (Object)this.clientAppId());
            throw new RestException(e);
        }
    }

    protected ResourceQuota internalGetNamespaceBundleResourceQuota(String bundleRange) {
        this.validateSuperUserAccess();
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (!this.namespaceName.isGlobal()) {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        NamespaceBundle nsBundle = this.validateNamespaceBundleRange(this.namespaceName, policies.bundles, bundleRange);
        try {
            return this.pulsar().getBrokerService().getBundlesQuotas().getResourceQuota(nsBundle).get(this.config().getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error("[{}] Failed to get resource quota for namespace bundle {}", (Object)this.clientAppId(), (Object)nsBundle.toString());
            throw new RestException(e);
        }
    }

    protected void internalSetNamespaceBundleResourceQuota(String bundleRange, ResourceQuota quota) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (!this.namespaceName.isGlobal()) {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        NamespaceBundle nsBundle = this.validateNamespaceBundleRange(this.namespaceName, policies.bundles, bundleRange);
        try {
            this.pulsar().getBrokerService().getBundlesQuotas().setResourceQuota(nsBundle, quota).get(this.config().getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
            log.info("[{}] Successfully set resource quota for namespace bundle {}", (Object)this.clientAppId(), (Object)nsBundle.toString());
        }
        catch (Exception e) {
            log.error("[{}] Failed to set resource quota for namespace bundle {}", (Object)this.clientAppId(), (Object)nsBundle.toString());
            throw new RestException(e);
        }
    }

    protected void internalRemoveNamespaceBundleResourceQuota(String bundleRange) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (!this.namespaceName.isGlobal()) {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        NamespaceBundle nsBundle = this.validateNamespaceBundleRange(this.namespaceName, policies.bundles, bundleRange);
        try {
            this.pulsar().getBrokerService().getBundlesQuotas().resetResourceQuota(nsBundle).get(this.config().getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
            log.info("[{}] Successfully unset resource quota for namespace bundle {}", (Object)this.clientAppId(), (Object)nsBundle.toString());
        }
        catch (Exception e) {
            log.error("[{}] Failed to unset resource quota for namespace bundle {}", (Object)this.clientAppId(), (Object)nsBundle.toString());
            throw new RestException(e);
        }
    }
}

