/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.intercept;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.intercept.BrokerInterceptorDefinitions;
import org.apache.pulsar.broker.intercept.BrokerInterceptorMetadata;
import org.apache.pulsar.broker.intercept.BrokerInterceptorUtils;
import org.apache.pulsar.broker.intercept.BrokerInterceptorWithClassLoader;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Producer;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.common.api.proto.BaseCommand;
import org.apache.pulsar.common.api.proto.CommandAck;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.intercept.InterceptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerInterceptors
implements BrokerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BrokerInterceptors.class);
    private final Map<String, BrokerInterceptorWithClassLoader> interceptors;

    public BrokerInterceptors(Map<String, BrokerInterceptorWithClassLoader> interceptors) {
        this.interceptors = interceptors;
    }

    public static BrokerInterceptor load(ServiceConfiguration conf) throws IOException {
        BrokerInterceptorDefinitions definitions = BrokerInterceptorUtils.searchForInterceptors(conf.getBrokerInterceptorsDirectory(), conf.getNarExtractionDirectory());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        conf.getBrokerInterceptors().forEach(interceptorName -> {
            BrokerInterceptorMetadata definition = definitions.interceptors().get(interceptorName);
            if (null == definition) {
                throw new RuntimeException("No broker interceptor is found for name `" + interceptorName + "`. Available broker interceptors are : " + definitions.interceptors());
            }
            try {
                BrokerInterceptorWithClassLoader interceptor = BrokerInterceptorUtils.load(definition, conf.getNarExtractionDirectory());
                if (interceptor != null) {
                    builder.put(interceptorName, (Object)interceptor);
                }
                log.info("Successfully loaded broker interceptor for name `{}`", interceptorName);
            }
            catch (IOException e) {
                log.error("Failed to load the broker interceptor for name `" + interceptorName + "`", (Throwable)e);
                throw new RuntimeException("Failed to load the broker interceptor for name `" + interceptorName + "`");
            }
        });
        ImmutableMap interceptors = builder.build();
        if (interceptors != null && !interceptors.isEmpty()) {
            return new BrokerInterceptors((Map<String, BrokerInterceptorWithClassLoader>)interceptors);
        }
        return null;
    }

    @Override
    public void beforeSendMessage(Subscription subscription, Entry entry, long[] ackSet, MessageMetadata msgMetadata) {
        for (BrokerInterceptorWithClassLoader value : this.interceptors.values()) {
            value.beforeSendMessage(subscription, entry, ackSet, msgMetadata);
        }
    }

    @Override
    public void consumerCreated(ServerCnx cnx, Consumer consumer, Map<String, String> metadata) {
        if (this.interceptors == null || this.interceptors.isEmpty()) {
            return;
        }
        for (BrokerInterceptorWithClassLoader value : this.interceptors.values()) {
            value.consumerCreated(cnx, consumer, metadata);
        }
    }

    @Override
    public void producerCreated(ServerCnx cnx, Producer producer, Map<String, String> metadata) {
        if (this.interceptors == null || this.interceptors.isEmpty()) {
            return;
        }
        for (BrokerInterceptorWithClassLoader value : this.interceptors.values()) {
            value.producerCreated(cnx, producer, metadata);
        }
    }

    @Override
    public void messageProduced(ServerCnx cnx, Producer producer, long startTimeNs, long ledgerId, long entryId, Topic.PublishContext publishContext) {
        if (this.interceptors == null || this.interceptors.isEmpty()) {
            return;
        }
        for (BrokerInterceptorWithClassLoader value : this.interceptors.values()) {
            value.messageProduced(cnx, producer, startTimeNs, ledgerId, entryId, publishContext);
        }
    }

    @Override
    public void messageDispatched(ServerCnx cnx, Consumer consumer, long ledgerId, long entryId, ByteBuf headersAndPayload) {
        if (this.interceptors == null || this.interceptors.isEmpty()) {
            return;
        }
        for (BrokerInterceptorWithClassLoader value : this.interceptors.values()) {
            value.messageDispatched(cnx, consumer, ledgerId, entryId, headersAndPayload);
        }
    }

    @Override
    public void messageAcked(ServerCnx cnx, Consumer consumer, CommandAck ackCmd) {
        if (this.interceptors == null || this.interceptors.isEmpty()) {
            return;
        }
        for (BrokerInterceptorWithClassLoader value : this.interceptors.values()) {
            value.messageAcked(cnx, consumer, ackCmd);
        }
    }

    @Override
    public void onConnectionCreated(ServerCnx cnx) {
        if (this.interceptors == null || this.interceptors.isEmpty()) {
            return;
        }
        for (BrokerInterceptorWithClassLoader value : this.interceptors.values()) {
            value.onConnectionCreated(cnx);
        }
    }

    @Override
    public void onPulsarCommand(BaseCommand command, ServerCnx cnx) throws InterceptException {
        for (BrokerInterceptorWithClassLoader value : this.interceptors.values()) {
            value.onPulsarCommand(command, cnx);
        }
    }

    @Override
    public void onConnectionClosed(ServerCnx cnx) {
        for (BrokerInterceptorWithClassLoader value : this.interceptors.values()) {
            value.onConnectionClosed(cnx);
        }
    }

    @Override
    public void onWebserviceRequest(ServletRequest request) throws IOException, ServletException, InterceptException {
        for (BrokerInterceptorWithClassLoader value : this.interceptors.values()) {
            value.onWebserviceRequest(request);
        }
    }

    @Override
    public void onWebserviceResponse(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        for (BrokerInterceptorWithClassLoader value : this.interceptors.values()) {
            value.onWebserviceResponse(request, response);
        }
    }

    @Override
    public void initialize(PulsarService pulsarService) throws Exception {
        for (BrokerInterceptorWithClassLoader v : this.interceptors.values()) {
            v.initialize(pulsarService);
        }
    }

    @Override
    public void close() {
        this.interceptors.values().forEach(BrokerInterceptorWithClassLoader::close);
    }
}

