/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.RedeliveryTracker;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.api.proto.MessageMetadata;

public interface Dispatcher {
    public void addConsumer(Consumer var1) throws BrokerServiceException;

    public void removeConsumer(Consumer var1) throws BrokerServiceException;

    public void consumerFlow(Consumer var1, int var2);

    public boolean isConsumerConnected();

    public List<Consumer> getConsumers();

    public boolean canUnsubscribe(Consumer var1);

    public CompletableFuture<Void> close();

    public boolean isClosed();

    public CompletableFuture<Void> disconnectActiveConsumers(boolean var1);

    public CompletableFuture<Void> disconnectAllConsumers(boolean var1);

    default public CompletableFuture<Void> disconnectAllConsumers() {
        return this.disconnectAllConsumers(false);
    }

    public void resetCloseFuture();

    public void reset();

    public CommandSubscribe.SubType getType();

    public void redeliverUnacknowledgedMessages(Consumer var1, long var2);

    public void redeliverUnacknowledgedMessages(Consumer var1, List<PositionImpl> var2);

    public void addUnAckedMessages(int var1);

    public RedeliveryTracker getRedeliveryTracker();

    default public Optional<DispatchRateLimiter> getRateLimiter() {
        return Optional.empty();
    }

    default public void updateRateLimiter() {
    }

    default public boolean initializeDispatchRateLimiterIfNeeded() {
        return false;
    }

    default public boolean trackDelayedDelivery(long ledgerId, long entryId, MessageMetadata msgMetadata) {
        return false;
    }

    default public long getNumberOfDelayedMessages() {
        return 0L;
    }

    default public void clearDelayedMessages() {
    }

    default public void cursorIsReset() {
    }

    default public void markDeletePositionMoveForward() {
    }

    default public boolean checkAndUnblockIfStuck() {
        return false;
    }
}

