/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.ObjectSet;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.AbstractBaseDispatcher;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.persistent.PersistentStickyKeyDispatcherMultipleConsumers;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDispatcherMultipleConsumers
extends AbstractBaseDispatcher {
    protected final CopyOnWriteArrayList<Consumer> consumerList = new CopyOnWriteArrayList();
    protected final ObjectSet<Consumer> consumerSet = new ObjectHashSet();
    protected volatile int currentConsumerRoundRobinIndex = 0;
    protected static final int FALSE = 0;
    protected static final int TRUE = 1;
    protected static final AtomicIntegerFieldUpdater<AbstractDispatcherMultipleConsumers> IS_CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractDispatcherMultipleConsumers.class, "isClosed");
    private volatile int isClosed = 0;
    private Random random = new Random(42L);
    private static final Logger log = LoggerFactory.getLogger(PersistentStickyKeyDispatcherMultipleConsumers.class);

    protected AbstractDispatcherMultipleConsumers(Subscription subscription, ServiceConfiguration serviceConfig) {
        super(subscription, serviceConfig);
    }

    @Override
    public boolean isConsumerConnected() {
        return !this.consumerList.isEmpty();
    }

    public CopyOnWriteArrayList<Consumer> getConsumers() {
        return this.consumerList;
    }

    @Override
    public synchronized boolean canUnsubscribe(Consumer consumer) {
        return this.consumerList.size() == 1 && this.consumerSet.contains((Object)consumer);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed == 1;
    }

    @Override
    public CommandSubscribe.SubType getType() {
        return CommandSubscribe.SubType.Shared;
    }

    public abstract boolean isConsumerAvailable(Consumer var1);

    protected void cancelPendingRead() {
    }

    public Consumer getNextConsumer() {
        int higherPriorityConsumerIndex;
        int currentRoundRobinConsumerPriority;
        if (this.consumerList.isEmpty() || IS_CLOSED_UPDATER.get(this) == 1) {
            return null;
        }
        if (this.currentConsumerRoundRobinIndex >= this.consumerList.size()) {
            this.currentConsumerRoundRobinIndex = 0;
        }
        if ((currentRoundRobinConsumerPriority = this.consumerList.get(this.currentConsumerRoundRobinIndex).getPriorityLevel()) != 0 && (higherPriorityConsumerIndex = this.getConsumerFromHigherPriority(currentRoundRobinConsumerPriority)) != -1) {
            this.currentConsumerRoundRobinIndex = higherPriorityConsumerIndex + 1;
            return this.consumerList.get(higherPriorityConsumerIndex);
        }
        int availableConsumerIndex = this.getNextConsumerFromSameOrLowerLevel(this.currentConsumerRoundRobinIndex);
        if (availableConsumerIndex != -1) {
            this.currentConsumerRoundRobinIndex = availableConsumerIndex + 1;
            return this.consumerList.get(availableConsumerIndex);
        }
        return null;
    }

    public Consumer getRandomConsumer() {
        if (this.consumerList.isEmpty() || IS_CLOSED_UPDATER.get(this) == 1) {
            return null;
        }
        return this.consumerList.get(this.random.nextInt(this.consumerList.size()));
    }

    private int getConsumerFromHigherPriority(int targetPriority) {
        Consumer consumer;
        for (int i = 0; i < this.currentConsumerRoundRobinIndex && (consumer = this.consumerList.get(i)).getPriorityLevel() < targetPriority; ++i) {
            if (!this.isConsumerAvailable(this.consumerList.get(i))) continue;
            return i;
        }
        return -1;
    }

    private int getNextConsumerFromSameOrLowerLevel(int currentRoundRobinIndex) {
        int targetPriority = this.consumerList.get(currentRoundRobinIndex).getPriorityLevel();
        int scanIndex = currentRoundRobinIndex;
        int endPriorityLevelIndex = currentRoundRobinIndex;
        do {
            Consumer scanConsumer;
            Consumer consumer = scanConsumer = scanIndex < this.consumerList.size() ? this.consumerList.get(scanIndex) : null;
            if (scanConsumer == null || scanConsumer.getPriorityLevel() != targetPriority) {
                endPriorityLevelIndex = scanIndex;
                scanIndex = this.getFirstConsumerIndexOfPriority(targetPriority);
                continue;
            }
            if (this.isConsumerAvailable(scanConsumer)) {
                return scanIndex;
            }
            ++scanIndex;
        } while (scanIndex != currentRoundRobinIndex);
        for (int i = endPriorityLevelIndex; i < this.consumerList.size(); ++i) {
            if (!this.isConsumerAvailable(this.consumerList.get(i))) continue;
            return i;
        }
        return -1;
    }

    private int getFirstConsumerIndexOfPriority(int targetPriority) {
        for (int i = 0; i < this.consumerList.size(); ++i) {
            if (this.consumerList.get(i).getPriorityLevel() != targetPriority) continue;
            return i;
        }
        return -1;
    }
}

