/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.util.collections.ConcurrentLongLongHashMap;
import org.apache.pulsar.common.util.collections.ConcurrentLongLongPairHashMap;
import org.apache.pulsar.utils.ConcurrentBitmapSortedLongPairSet;

@NotThreadSafe
public class MessageRedeliveryController {
    private final boolean allowOutOfOrderDelivery;
    private final ConcurrentBitmapSortedLongPairSet messagesToRedeliver;
    private final ConcurrentLongLongPairHashMap hashesToBeBlocked;
    private final ConcurrentLongLongHashMap hashesRefCount;

    public MessageRedeliveryController(boolean allowOutOfOrderDelivery) {
        this.allowOutOfOrderDelivery = allowOutOfOrderDelivery;
        this.messagesToRedeliver = new ConcurrentBitmapSortedLongPairSet();
        if (!allowOutOfOrderDelivery) {
            this.hashesToBeBlocked = ConcurrentLongLongPairHashMap.newBuilder().concurrencyLevel(2).expectedItems(128).autoShrink(true).build();
            this.hashesRefCount = ConcurrentLongLongHashMap.newBuilder().concurrencyLevel(2).expectedItems(128).autoShrink(true).build();
        } else {
            this.hashesToBeBlocked = null;
            this.hashesRefCount = null;
        }
    }

    public void add(long ledgerId, long entryId) {
        this.messagesToRedeliver.add(ledgerId, entryId);
    }

    public void add(long ledgerId, long entryId, long stickyKeyHash) {
        if (!this.allowOutOfOrderDelivery) {
            boolean inserted = this.hashesToBeBlocked.putIfAbsent(ledgerId, entryId, stickyKeyHash, 0L);
            if (!inserted) {
                this.hashesToBeBlocked.put(ledgerId, entryId, stickyKeyHash, 0L);
            } else {
                long stored = this.hashesRefCount.get(stickyKeyHash);
                this.hashesRefCount.put(stickyKeyHash, stored > 0L ? (stored = stored + 1L) : 1L);
            }
        }
        this.messagesToRedeliver.add(ledgerId, entryId);
    }

    public void remove(long ledgerId, long entryId) {
        if (!this.allowOutOfOrderDelivery) {
            this.removeFromHashBlocker(ledgerId, entryId);
        }
        this.messagesToRedeliver.remove(ledgerId, entryId);
    }

    private void removeFromHashBlocker(long ledgerId, long entryId) {
        boolean removed;
        ConcurrentLongLongPairHashMap.LongPair value = this.hashesToBeBlocked.get(ledgerId, entryId);
        if (value != null && (removed = this.hashesToBeBlocked.remove(ledgerId, entryId, value.first, 0L))) {
            long exists = this.hashesRefCount.get(value.first);
            if (exists == 1L) {
                this.hashesRefCount.remove(value.first, exists);
            } else if (exists > 0L) {
                this.hashesRefCount.put(value.first, exists - 1L);
            }
        }
    }

    public void removeAllUpTo(long markDeleteLedgerId, long markDeleteEntryId) {
        if (!this.allowOutOfOrderDelivery) {
            ArrayList keysToRemove = new ArrayList();
            this.hashesToBeBlocked.forEach((ledgerId, entryId, stickyKeyHash, none) -> {
                if (ComparisonChain.start().compare(ledgerId, markDeleteLedgerId).compare(entryId, markDeleteEntryId).result() <= 0) {
                    keysToRemove.add(new ConcurrentLongLongPairHashMap.LongPair(ledgerId, entryId));
                }
            });
            keysToRemove.forEach(longPair -> this.removeFromHashBlocker(longPair.first, longPair.second));
            keysToRemove.clear();
        }
        this.messagesToRedeliver.removeUpTo(markDeleteLedgerId, markDeleteEntryId + 1L);
    }

    public boolean isEmpty() {
        return this.messagesToRedeliver.isEmpty();
    }

    public void clear() {
        if (!this.allowOutOfOrderDelivery) {
            this.hashesToBeBlocked.clear();
            this.hashesRefCount.clear();
        }
        this.messagesToRedeliver.clear();
    }

    public String toString() {
        return this.messagesToRedeliver.toString();
    }

    public boolean containsStickyKeyHashes(Set<Integer> stickyKeyHashes) {
        if (!this.allowOutOfOrderDelivery) {
            for (Integer stickyKeyHash : stickyKeyHashes) {
                if (!this.hashesRefCount.containsKey((long)stickyKeyHash.intValue())) continue;
                return true;
            }
        }
        return false;
    }

    public Set<PositionImpl> getMessagesToReplayNow(int maxMessagesToRead) {
        return this.messagesToRedeliver.items(maxMessagesToRead, PositionImpl::new);
    }
}

