/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.stream.storage.impl.cluster.ZkClusterInitializer;
import org.apache.pulsar.broker.resources.NamespaceResources;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.broker.resources.TenantResources;
import org.apache.pulsar.common.conf.InternalConfigurationData;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.SystemTopicNames;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PoliciesUtil;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.util.CmdGenerateDocs;
import org.apache.pulsar.functions.worker.WorkerUtils;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.MetadataStoreLifecycle;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.bookkeeper.PulsarMetadataBookieDriver;
import org.apache.pulsar.metadata.bookkeeper.PulsarMetadataClientDriver;
import org.apache.pulsar.metadata.impl.MetadataStoreFactoryImpl;
import org.apache.pulsar.metadata.impl.ZKMetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarClusterMetadataSetup {
    private static final Logger log = LoggerFactory.getLogger(PulsarClusterMetadataSetup.class);

    private static void createMetadataNode(MetadataStore store, String path, byte[] data) throws InterruptedException, ExecutionException {
        block2: {
            try {
                store.put(path, data, Optional.of(-1L)).get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof MetadataStoreException.BadVersionException) break block2;
                throw e;
            }
        }
    }

    private static void initialDlogNamespaceMetadata(String configurationStore, String bkMetadataServiceUri) throws IOException {
        InternalConfigurationData internalConf = new InternalConfigurationData(configurationStore, configurationStore, null, bkMetadataServiceUri, null);
        WorkerUtils.initializeDlogNamespace((InternalConfigurationData)internalConf);
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("bookkeeper.metadata.bookie.drivers", PulsarMetadataBookieDriver.class.getName());
        System.setProperty("bookkeeper.metadata.client.drivers", PulsarMetadataClientDriver.class.getName());
        Arguments arguments = new Arguments();
        JCommander jcommander = new JCommander();
        try {
            jcommander.addObject((Object)arguments);
            jcommander.parse(args);
            if (arguments.help) {
                jcommander.usage();
                return;
            }
            if (arguments.generateDocs) {
                CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
                cmd.addCommand("initialize-cluster-metadata", (Object)arguments);
                cmd.run(null);
                return;
            }
        }
        catch (Exception e) {
            jcommander.usage();
            throw e;
        }
        if (arguments.metadataStoreUrl == null && arguments.zookeeper == null) {
            System.err.println("Metadata store address argument is required (--metadata-store)");
            jcommander.usage();
            System.exit(1);
        }
        if (arguments.configurationMetadataStore == null && arguments.configurationStore == null && arguments.globalZookeeper == null) {
            System.err.println("Configuration metadata store address argument is required (--configuration-metadata-store)");
            jcommander.usage();
            System.exit(1);
        }
        if (arguments.configurationMetadataStore != null && (arguments.configurationStore != null || arguments.globalZookeeper != null)) {
            System.err.println("Configuration metadata store argument (--configuration-metadata-store) supersedes the deprecated (--global-zookeeper and --configuration-store) argument");
            jcommander.usage();
            System.exit(1);
        }
        if (arguments.configurationMetadataStore == null) {
            String string = arguments.configurationMetadataStore = arguments.configurationStore == null ? arguments.globalZookeeper : arguments.configurationStore;
        }
        if (arguments.metadataStoreUrl == null) {
            arguments.metadataStoreUrl = "zk:" + arguments.zookeeper;
        }
        if (arguments.numTransactionCoordinators <= 0) {
            System.err.println("Number of transaction coordinators must greater than 0");
            System.exit(1);
        }
        try {
            PulsarClusterMetadataSetup.initializeCluster(arguments);
        }
        catch (Exception e) {
            System.err.println("Unexpected error occured.");
            e.printStackTrace(System.err);
            System.err.println("Terminating JVM...");
            Runtime.getRuntime().halt(1);
        }
    }

    private static void initializeCluster(Arguments arguments) throws Exception {
        log.info("Setting up cluster {} with metadata-store={} configuration-metadata-store={}", new Object[]{arguments.cluster, arguments.metadataStoreUrl, arguments.configurationMetadataStore});
        MetadataStoreExtended localStore = PulsarClusterMetadataSetup.initMetadataStore(arguments.metadataStoreUrl, arguments.zkSessionTimeoutMillis);
        MetadataStoreExtended configStore = PulsarClusterMetadataSetup.initMetadataStore(arguments.configurationMetadataStore, arguments.zkSessionTimeoutMillis);
        String metadataStoreUrlNoIdentifer = MetadataStoreFactoryImpl.removeIdentifierFromMetadataURL((String)arguments.metadataStoreUrl);
        if (arguments.existingBkMetadataServiceUri == null && arguments.bookieMetadataServiceUri == null) {
            ServerConfiguration bkConf = new ServerConfiguration();
            bkConf.setDelimiterParsingDisabled(true);
            bkConf.setMetadataServiceUri("metadata-store:" + arguments.metadataStoreUrl);
            bkConf.setZkTimeout(arguments.zkSessionTimeoutMillis);
            if (!((Boolean)localStore.exists("/ledgers").get()).booleanValue() && !BookKeeperAdmin.format((ServerConfiguration)bkConf, (boolean)false, (boolean)false)) {
                throw new IOException("Failed to initialize BookKeeper metadata");
            }
        }
        if (localStore instanceof ZKMetadataStore && configStore instanceof ZKMetadataStore) {
            Object uriStr = arguments.existingBkMetadataServiceUri != null ? arguments.existingBkMetadataServiceUri : (arguments.bookieMetadataServiceUri != null ? arguments.bookieMetadataServiceUri : "zk+null://" + metadataStoreUrlNoIdentifer + "/ledgers");
            PulsarClusterMetadataSetup.initialDlogNamespaceMetadata(arguments.configurationMetadataStore, (String)uriStr);
            ServiceURI bkMetadataServiceUri = ServiceURI.create((String)uriStr);
            if (arguments.numStreamStorageContainers > 0) {
                ZkClusterInitializer initializer = new ZkClusterInitializer(metadataStoreUrlNoIdentifer);
                initializer.initializeCluster(bkMetadataServiceUri.getUri(), arguments.numStreamStorageContainers);
            }
        }
        if (!((Boolean)localStore.exists("/bookies").get()).booleanValue()) {
            PulsarClusterMetadataSetup.createMetadataNode((MetadataStore)localStore, "/bookies", "{}".getBytes());
        }
        PulsarResources resources = new PulsarResources((MetadataStore)localStore, (MetadataStore)configStore);
        ClusterData clusterData = ClusterData.builder().serviceUrl(arguments.clusterWebServiceUrl).serviceUrlTls(arguments.clusterWebServiceUrlTls).brokerServiceUrl(arguments.clusterBrokerServiceUrl).brokerServiceUrlTls(arguments.clusterBrokerServiceUrlTls).build();
        if (!resources.getClusterResources().clusterExists(arguments.cluster)) {
            resources.getClusterResources().createCluster(arguments.cluster, clusterData);
        }
        ClusterData globalClusterData = ClusterData.builder().build();
        if (!resources.getClusterResources().clusterExists("global")) {
            resources.getClusterResources().createCluster("global", globalClusterData);
        }
        PulsarClusterMetadataSetup.createTenantIfAbsent(resources, "public", arguments.cluster);
        PulsarClusterMetadataSetup.createTenantIfAbsent(resources, NamespaceName.SYSTEM_NAMESPACE.getTenant(), arguments.cluster);
        PulsarClusterMetadataSetup.createNamespaceIfAbsent(resources, NamespaceName.get((String)"public", (String)"default"), arguments.cluster);
        PulsarClusterMetadataSetup.createNamespaceIfAbsent(resources, NamespaceName.SYSTEM_NAMESPACE, arguments.cluster);
        PulsarClusterMetadataSetup.createPartitionedTopic((MetadataStore)configStore, SystemTopicNames.TRANSACTION_COORDINATOR_ASSIGN, arguments.numTransactionCoordinators);
        localStore.close();
        configStore.close();
        log.info("Cluster metadata for '{}' setup correctly", (Object)arguments.cluster);
    }

    static void createTenantIfAbsent(PulsarResources resources, String tenant, String cluster) throws IOException, InterruptedException, ExecutionException {
        TenantResources tenantResources = resources.getTenantResources();
        if (!tenantResources.tenantExists(tenant)) {
            TenantInfoImpl publicTenant = new TenantInfoImpl(Collections.emptySet(), Collections.singleton(cluster));
            tenantResources.createTenant(tenant, (TenantInfo)publicTenant);
        } else {
            tenantResources.updateTenantAsync(tenant, ti -> {
                ti.getAllowedClusters().add(cluster);
                return ti;
            }).get();
        }
    }

    static void createNamespaceIfAbsent(PulsarResources resources, NamespaceName namespaceName, String cluster) throws IOException {
        NamespaceResources namespaceResources = resources.getNamespaceResources();
        if (!namespaceResources.namespaceExists(namespaceName)) {
            Policies policies2 = new Policies();
            policies2.bundles = PoliciesUtil.getBundles((int)16);
            policies2.replication_clusters = Collections.singleton(cluster);
            namespaceResources.createPolicies(namespaceName, policies2);
        } else {
            namespaceResources.setPolicies(namespaceName, policies -> {
                policies.replication_clusters.add(cluster);
                return policies;
            });
        }
    }

    static void createPartitionedTopic(MetadataStore configStore, TopicName topicName, int numPartitions) throws InterruptedException, IOException, ExecutionException {
        PulsarResources resources = new PulsarResources(null, configStore);
        NamespaceResources.PartitionedTopicResources partitionedTopicResources = resources.getNamespaceResources().getPartitionedTopicResources();
        Optional getResult = (Optional)partitionedTopicResources.getPartitionedTopicMetadataAsync(topicName).get();
        if (!getResult.isPresent()) {
            partitionedTopicResources.createPartitionedTopic(topicName, new PartitionedTopicMetadata(numPartitions));
        } else {
            PartitionedTopicMetadata existsMeta = (PartitionedTopicMetadata)getResult.get();
            if (existsMeta.partitions < numPartitions) {
                partitionedTopicResources.updatePartitionedTopicAsync(topicName, __ -> new PartitionedTopicMetadata(numPartitions)).get();
            }
        }
    }

    public static MetadataStoreExtended initMetadataStore(String connection, int sessionTimeout) throws Exception {
        MetadataStoreExtended store = MetadataStoreExtended.create((String)connection, (MetadataStoreConfig)MetadataStoreConfig.builder().sessionTimeoutMillis(sessionTimeout).build());
        if (store instanceof MetadataStoreLifecycle) {
            ((MetadataStoreLifecycle)store).initializeCluster().get();
        }
        return store;
    }

    private static class Arguments {
        @Parameter(names={"-c", "--cluster"}, description="Cluster name", required=true)
        private String cluster;
        @Parameter(names={"-uw", "--web-service-url"}, description="Web-service URL for new cluster", required=true)
        private String clusterWebServiceUrl;
        @Parameter(names={"-tw", "--web-service-url-tls"}, description="Web-service URL for new cluster with TLS encryption", required=false)
        private String clusterWebServiceUrlTls;
        @Parameter(names={"-ub", "--broker-service-url"}, description="Broker-service URL for new cluster", required=false)
        private String clusterBrokerServiceUrl;
        @Parameter(names={"-tb", "--broker-service-url-tls"}, description="Broker-service URL for new cluster with TLS encryption", required=false)
        private String clusterBrokerServiceUrlTls;
        @Parameter(names={"-zk", "--zookeeper"}, description="Local ZooKeeper quorum connection string", required=false, hidden=true)
        private String zookeeper;
        @Parameter(names={"-md", "--metadata-store"}, description="Metadata Store service url. eg: zk:my-zk:2181", required=false)
        private String metadataStoreUrl;
        @Parameter(names={"--zookeeper-session-timeout-ms"}, description="Local zookeeper session timeout ms")
        private int zkSessionTimeoutMillis = 30000;
        @Parameter(names={"-gzk", "--global-zookeeper"}, description="Global ZooKeeper quorum connection string", required=false, hidden=true)
        private String globalZookeeper;
        @Parameter(names={"-cs", "--configuration-store"}, description="Configuration Store connection string", hidden=true)
        private String configurationStore;
        @Parameter(names={"-cms", "--configuration-metadata-store"}, description="Configuration Metadata Store connection string", hidden=false)
        private String configurationMetadataStore;
        @Parameter(names={"--initial-num-stream-storage-containers"}, description="Num storage containers of BookKeeper stream storage")
        private int numStreamStorageContainers = 16;
        @Parameter(names={"--initial-num-transaction-coordinators"}, description="Num transaction coordinators will assigned in cluster")
        private int numTransactionCoordinators = 16;
        @Parameter(names={"--existing-bk-metadata-service-uri"}, description="The metadata service URI of the existing BookKeeper cluster that you want to use")
        private String existingBkMetadataServiceUri;
        @Deprecated
        @Parameter(names={"--bookkeeper-metadata-service-uri"}, description="The metadata service URI of the existing BookKeeper cluster that you want to use", hidden=true)
        private String bookieMetadataServiceUri;
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        private boolean help = false;
        @Parameter(names={"-g", "--generate-docs"}, description="Generate docs")
        private boolean generateDocs = false;

        private Arguments() {
        }
    }
}

