/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.systopic;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.systopic.SystemTopicClient;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SystemTopicClientBase<T>
implements SystemTopicClient<T> {
    protected final TopicName topicName;
    protected final PulsarClient client;
    protected final List<SystemTopicClient.Writer<T>> writers;
    protected final List<SystemTopicClient.Reader<T>> readers;
    private static final Logger log = LoggerFactory.getLogger(SystemTopicClientBase.class);

    public SystemTopicClientBase(PulsarClient client, TopicName topicName) {
        this.client = client;
        this.topicName = topicName;
        this.writers = Collections.synchronizedList(new ArrayList());
        this.readers = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public SystemTopicClient.Reader<T> newReader() throws PulsarClientException {
        try {
            return this.newReaderAsync().get();
        }
        catch (Exception e) {
            throw new PulsarClientException((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<SystemTopicClient.Reader<T>> newReaderAsync() {
        return this.newReaderAsyncInternal().thenApply(reader -> {
            this.readers.add((SystemTopicClient.Reader<T>)reader);
            return reader;
        });
    }

    @Override
    public SystemTopicClient.Writer<T> newWriter() throws PulsarClientException {
        try {
            return this.newWriterAsync().get();
        }
        catch (Exception e) {
            throw new PulsarClientException((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<SystemTopicClient.Writer<T>> newWriterAsync() {
        return this.newWriterAsyncInternal().thenApply(writer -> {
            this.writers.add((SystemTopicClient.Writer<T>)writer);
            return writer;
        });
    }

    protected abstract CompletableFuture<SystemTopicClient.Writer<T>> newWriterAsyncInternal();

    protected abstract CompletableFuture<SystemTopicClient.Reader<T>> newReaderAsyncInternal();

    @Override
    public CompletableFuture<Void> closeAsync() {
        ArrayList futures = new ArrayList();
        ArrayList tempWriters = Lists.newArrayList(this.writers);
        tempWriters.forEach(writer -> futures.add(writer.closeAsync()));
        ArrayList tempReaders = Lists.newArrayList(this.readers);
        tempReaders.forEach(reader -> futures.add(reader.closeAsync()));
        this.writers.clear();
        this.readers.clear();
        return FutureUtil.waitForAll(futures);
    }

    @Override
    public void close() throws Exception {
        this.closeAsync().get();
    }

    @Override
    public TopicName getTopicName() {
        return this.topicName;
    }

    @Override
    public List<SystemTopicClient.Reader<T>> getReaders() {
        return this.readers;
    }

    @Override
    public List<SystemTopicClient.Writer<T>> getWriters() {
        return this.writers;
    }
}

