/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.function.Supplier;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.api.WorkerImpl;

@Path(value="/worker")
public class Worker
extends AdminResource
implements Supplier<WorkerService> {
    private final WorkerImpl worker = new WorkerImpl((Supplier)this);

    @Override
    public WorkerService get() {
        return this.pulsar().getWorkerService();
    }

    @GET
    @ApiOperation(value="Fetches information about the Pulsar cluster running Pulsar Functions")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions")})
    @Path(value="/cluster")
    @Produces(value={"application/json"})
    public Response getCluster() {
        return this.worker.getCluster();
    }

    @GET
    @ApiOperation(value="Fetches info about the leader node of the Pulsar cluster running Pulsar Functions")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions")})
    @Path(value="/cluster/leader")
    @Produces(value={"application/json"})
    public Response getClusterLeader() {
        return this.worker.getClusterLeader();
    }

    @GET
    @ApiOperation(value="Fetches information about which Pulsar Functions are assigned to which Pulsar clusters", response=Function.Assignment.class, responseContainer="Map")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions")})
    @Path(value="/assignments")
    public Response getAssignments() {
        return this.worker.getAssignments();
    }
}

