/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Supplier;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.functions.proto.InstanceCommunication;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.api.WorkerImpl;

@Path(value="/worker-stats")
public class WorkerStats
extends AdminResource
implements Supplier<WorkerService> {
    private final WorkerImpl worker = new WorkerImpl((Supplier)this);

    @Override
    public WorkerService get() {
        return this.pulsar().getWorkerService();
    }

    @GET
    @Path(value="/metrics")
    @ApiOperation(value="Gets the metrics for Monitoring", notes="Request should be executed by Monitoring agent on each worker to fetch the worker-metrics", response=Metrics.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have admin permission")})
    public Collection<Metrics> getMetrics() throws Exception {
        return this.worker.getWorkerMetrcis(this.clientAppId());
    }

    @GET
    @Path(value="/functionsmetrics")
    @ApiOperation(value="Get metrics for all functions owned by worker", notes="Requested should be executed by Monitoring agent on each worker to fetch the metrics", response=InstanceCommunication.Metrics.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=503, message="Worker service is not running")})
    public Response getStats() throws IOException {
        return this.worker.getFunctionsMetrics(this.clientAppId());
    }
}

