/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.namespace;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OwnedBundle {
    private static final Logger LOG = LoggerFactory.getLogger(OwnedBundle.class);
    private final NamespaceBundle bundle;
    private final ReentrantReadWriteLock nsLock = new ReentrantReadWriteLock();
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private static final AtomicIntegerFieldUpdater<OwnedBundle> IS_ACTIVE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(OwnedBundle.class, "isActive");
    private volatile int isActive = 1;

    public OwnedBundle(NamespaceBundle suName) {
        this.bundle = suName;
        IS_ACTIVE_UPDATER.set(this, 1);
    }

    public OwnedBundle(NamespaceBundle suName, boolean active) {
        this.bundle = suName;
        IS_ACTIVE_UPDATER.set(this, active ? 1 : 0);
    }

    public NamespaceBundle getNamespaceBundle() {
        return this.bundle;
    }

    public void handleUnloadRequest(PulsarService pulsar, long timeout, TimeUnit timeoutUnit) throws Exception {
        long unloadBundleStartTime = System.nanoTime();
        while (!this.nsLock.writeLock().tryLock(1L, TimeUnit.SECONDS)) {
            LOG.warn("Contention on OwnedBundle rw lock. Retrying to acquire lock write lock");
        }
        try {
            if (!IS_ACTIVE_UPDATER.compareAndSet(this, 1, 0)) {
                throw new IllegalStateException("Namespace is not active. ns:" + this.bundle + "; state:" + IS_ACTIVE_UPDATER.get(this));
            }
        }
        finally {
            this.nsLock.writeLock().unlock();
        }
        int unloadedTopics = 0;
        try {
            LOG.info("Disabling ownership: {}", (Object)this.bundle);
            pulsar.getNamespaceService().getOwnershipCache().updateBundleState(this.bundle, false);
            try {
                unloadedTopics = pulsar.getBrokerService().unloadServiceUnit(this.bundle).get(timeout, timeoutUnit);
            }
            catch (TimeoutException timeoutException) {
                LOG.error("Failed to close topics in namespace {} in {}/{} timeout", new Object[]{this.bundle.toString(), timeout, timeoutUnit});
            }
            catch (Exception e) {
                LOG.error("Failed to close topics under namespace {}", (Object)this.bundle.toString(), (Object)e);
            }
            try {
                pulsar.getNamespaceService().getOwnershipCache().removeOwnership(this.bundle).get(timeout, timeoutUnit);
            }
            catch (Exception e) {
                pulsar.getNamespaceService().getOwnershipCache().updateBundleState(this.bundle, true);
                throw new RuntimeException(String.format("Failed to delete ownership node %s", this.bundle.toString()), e.getCause());
            }
        }
        catch (Exception e) {
            LOG.error("Failed to unload a namespace {}", (Object)this.bundle.toString(), (Object)e);
            throw new RuntimeException(e);
        }
        double unloadBundleTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - unloadBundleStartTime);
        LOG.info("Unloading {} namespace-bundle with {} topics completed in {} ms", new Object[]{this.bundle, unloadedTopics, unloadBundleTime});
    }

    public boolean isActive() {
        return IS_ACTIVE_UPDATER.get(this) == 1;
    }

    public void setActive(boolean active) {
        IS_ACTIVE_UPDATER.set(this, active ? 1 : 0);
    }
}

