/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedIdGenerator {
    private final String prefix;
    private final int generatorInstanceId;
    private final AtomicLong counter;
    private static final Logger log = LoggerFactory.getLogger(DistributedIdGenerator.class);

    public DistributedIdGenerator(ZooKeeper zk, String path, String prefix) throws Exception {
        this.prefix = prefix;
        this.counter = new AtomicLong(0L);
        if (zk.exists(path, false) == null) {
            try {
                ZkUtils.createFullPathOptimistic((ZooKeeper)zk, (String)path, (byte[])new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {}
        }
        String createdPath = zk.create(String.valueOf(path) + "/-", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        String[] parts = createdPath.split("/");
        String name = parts[parts.length - 1].replace('-', ' ').trim();
        this.generatorInstanceId = Integer.parseInt(name);
        log.info("Created sequential node at {} -- Generator Id is {}-{}", new Object[]{createdPath, prefix, this.generatorInstanceId});
    }

    public String getNextId() {
        return String.format("%s-%d-%d", this.prefix, this.generatorInstanceId, this.counter.getAndIncrement());
    }
}

