/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.broker.service.RedeliveryTracker;

public class InMemoryRedeliveryTracker
implements RedeliveryTracker {
    private ConcurrentHashMap<Position, AtomicInteger> trackerCache = new ConcurrentHashMap(16);

    @Override
    public int incrementAndGetRedeliveryCount(Position position) {
        this.trackerCache.putIfAbsent(position, new AtomicInteger(0));
        return this.trackerCache.get(position).incrementAndGet();
    }

    @Override
    public int getRedeliveryCount(Position position) {
        return this.trackerCache.getOrDefault(position, new AtomicInteger(0)).get();
    }

    @Override
    public void remove(Position position) {
        this.trackerCache.remove(position);
    }

    @Override
    public void removeBatch(List<Position> positions) {
        if (positions != null) {
            positions.forEach(this::remove);
        }
    }

    @Override
    public void clear() {
        this.trackerCache.clear();
    }
}

