/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.util.SafeRun;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.service.AbstractDispatcherSingleActiveConsumer;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Dispatcher;
import org.apache.pulsar.broker.service.RedeliveryTracker;
import org.apache.pulsar.broker.service.RedeliveryTrackerDisabled;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.impl.Backoff;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.util.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PersistentDispatcherSingleActiveConsumer
extends AbstractDispatcherSingleActiveConsumer
implements Dispatcher,
AsyncCallbacks.ReadEntriesCallback {
    private final PersistentTopic topic;
    private final ManagedCursor cursor;
    private final String name;
    private DispatchRateLimiter dispatchRateLimiter;
    private volatile boolean havePendingRead = false;
    private static final int MaxReadBatchSize = 100;
    private int readBatchSize;
    private final Backoff readFailureBackoff = new Backoff(15L, TimeUnit.SECONDS, 1L, TimeUnit.MINUTES, 0L, TimeUnit.MILLISECONDS);
    private final ServiceConfiguration serviceConfig;
    private ScheduledFuture<?> readOnActiveConsumerTask = null;
    private final RedeliveryTracker redeliveryTracker;
    private static final Logger log = LoggerFactory.getLogger(PersistentDispatcherSingleActiveConsumer.class);

    public PersistentDispatcherSingleActiveConsumer(ManagedCursor cursor, PulsarApi.CommandSubscribe.SubType subscriptionType, int partitionIndex, PersistentTopic topic) {
        super(subscriptionType, partitionIndex, topic.getName());
        this.topic = topic;
        this.name = String.valueOf(topic.getName()) + " / " + (cursor.getName() != null ? Codec.decode((String)cursor.getName()) : "");
        this.cursor = cursor;
        this.readBatchSize = 100;
        this.serviceConfig = topic.getBrokerService().pulsar().getConfiguration();
        this.dispatchRateLimiter = null;
        this.redeliveryTracker = RedeliveryTrackerDisabled.REDELIVERY_TRACKER_DISABLED;
    }

    @Override
    protected void scheduleReadOnActiveConsumer() {
        if (this.havePendingRead && this.cursor.cancelPendingReadRequest()) {
            this.havePendingRead = false;
        }
        if (this.havePendingRead) {
            return;
        }
        if (this.subscriptionType != PulsarApi.CommandSubscribe.SubType.Failover || this.serviceConfig.getActiveConsumerFailoverDelayTimeMillis() <= 0) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Rewind cursor and read more entries without delay", (Object)this.name);
            }
            this.cursor.rewind();
            Consumer activeConsumer = AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this);
            this.notifyActiveConsumerChanged(activeConsumer);
            this.readMoreEntries(activeConsumer);
            return;
        }
        if (this.readOnActiveConsumerTask != null) {
            return;
        }
        this.readOnActiveConsumerTask = this.topic.getBrokerService().executor().schedule(() -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Rewind cursor and read more entries after {} ms delay", (Object)this.name, (Object)this.serviceConfig.getActiveConsumerFailoverDelayTimeMillis());
            }
            this.cursor.rewind();
            Consumer activeConsumer = AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this);
            this.notifyActiveConsumerChanged(activeConsumer);
            this.readMoreEntries(activeConsumer);
            this.readOnActiveConsumerTask = null;
        }, (long)this.serviceConfig.getActiveConsumerFailoverDelayTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    protected boolean isConsumersExceededOnTopic() {
        int maxConsumersPerTopic;
        Policies policies;
        try {
            policies = this.topic.getBrokerService().pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", TopicName.get((String)this.topicName).getNamespace())).orElseGet(() -> new Policies());
        }
        catch (Exception exception) {
            policies = new Policies();
        }
        int n = maxConsumersPerTopic = policies.max_consumers_per_topic > 0 ? policies.max_consumers_per_topic : this.serviceConfig.getMaxConsumersPerTopic();
        return maxConsumersPerTopic > 0 && maxConsumersPerTopic <= this.topic.getNumberOfConsumers();
    }

    @Override
    protected boolean isConsumersExceededOnSubscription() {
        int maxConsumersPerSubscription;
        Policies policies;
        try {
            policies = this.topic.getBrokerService().pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", TopicName.get((String)this.topicName).getNamespace())).orElseGet(() -> new Policies());
        }
        catch (Exception exception) {
            policies = new Policies();
        }
        int n = maxConsumersPerSubscription = policies.max_consumers_per_subscription > 0 ? policies.max_consumers_per_subscription : this.serviceConfig.getMaxConsumersPerSubscription();
        return maxConsumersPerSubscription > 0 && maxConsumersPerSubscription <= this.consumers.size();
    }

    @Override
    protected void cancelPendingRead() {
        if (this.havePendingRead && this.cursor.cancelPendingReadRequest()) {
            this.havePendingRead = false;
        }
    }

    public void readEntriesComplete(List<Entry> entries, Object obj) {
        this.topic.getBrokerService().getTopicOrderedExecutor().executeOrdered((Object)this.topicName, (SafeRunnable)SafeRun.safeRun(() -> this.internalReadEntriesComplete(entries, obj)));
    }

    public synchronized void internalReadEntriesComplete(List<Entry> entries, Object obj) {
        Consumer readConsumer = (Consumer)obj;
        if (log.isDebugEnabled()) {
            log.debug("[{}-{}] Got messages: {}", new Object[]{this.name, readConsumer, entries.size()});
        }
        this.havePendingRead = false;
        if (this.readBatchSize < 100) {
            int newReadBatchSize = Math.min(this.readBatchSize * 2, 100);
            if (log.isDebugEnabled()) {
                log.debug("[{}-{}] Increasing read batch size from {} to {}", new Object[]{this.name, readConsumer, this.readBatchSize, newReadBatchSize});
            }
            this.readBatchSize = newReadBatchSize;
        }
        this.readFailureBackoff.reduceToHalf();
        Consumer currentConsumer = AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this);
        if (currentConsumer == null || readConsumer != currentConsumer) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] rewind because no available consumer found", (Object)this.name);
            }
            entries.forEach(Entry::release);
            this.cursor.rewind();
            if (currentConsumer != null) {
                this.notifyActiveConsumerChanged(currentConsumer);
                this.readMoreEntries(currentConsumer);
            }
        } else {
            currentConsumer.sendMessages(entries, (future, sentMsgInfo) -> {
                if (future.isSuccess()) {
                    if (this.serviceConfig.isDispatchThrottlingOnNonBacklogConsumerEnabled() || !this.cursor.isActive()) {
                        this.topic.getDispatchRateLimiter().tryDispatchPermit(sentMsgInfo.getTotalSentMessages(), sentMsgInfo.getTotalSentMessageBytes());
                        if (this.dispatchRateLimiter == null) {
                            this.dispatchRateLimiter = new DispatchRateLimiter(this.topic, this.name);
                        }
                        this.dispatchRateLimiter.tryDispatchPermit(sentMsgInfo.getTotalSentMessages(), sentMsgInfo.getTotalSentMessageBytes());
                    }
                    this.topic.getBrokerService().getTopicOrderedExecutor().executeOrdered((Object)this.topicName, (SafeRunnable)SafeRun.safeRun(() -> {
                        PersistentDispatcherSingleActiveConsumer persistentDispatcherSingleActiveConsumer = this;
                        synchronized (persistentDispatcherSingleActiveConsumer) {
                            Consumer newConsumer = this.getActiveConsumer();
                            if (newConsumer != null && !this.havePendingRead) {
                                this.readMoreEntries(newConsumer);
                            } else if (log.isDebugEnabled()) {
                                log.debug("[{}-{}] Ignoring write future complete. consumerAvailable={} havePendingRead={}", new Object[]{this.name, newConsumer, newConsumer != null, this.havePendingRead});
                            }
                        }
                    }));
                }
            });
        }
    }

    @Override
    public void consumerFlow(Consumer consumer, int additionalNumberOfMessages) {
        this.topic.getBrokerService().getTopicOrderedExecutor().executeOrdered((Object)this.topicName, (SafeRunnable)SafeRun.safeRun(() -> this.internalConsumerFlow(consumer, additionalNumberOfMessages)));
    }

    private synchronized void internalConsumerFlow(Consumer consumer, int additionalNumberOfMessages) {
        if (this.havePendingRead) {
            if (log.isDebugEnabled()) {
                log.debug("[{}-{}] Ignoring flow control message since we already have a pending read req", (Object)this.name, (Object)consumer);
            }
        } else if (AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this) != consumer) {
            if (log.isDebugEnabled()) {
                log.debug("[{}-{}] Ignoring flow control message since consumer is not active partition consumer", (Object)this.name, (Object)consumer);
            }
        } else if (this.readOnActiveConsumerTask != null) {
            if (log.isDebugEnabled()) {
                log.debug("[{}-{}] Ignoring flow control message since consumer is waiting for cursor to be rewinded", (Object)this.name, (Object)consumer);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("[{}-{}] Trigger new read after receiving flow control message", (Object)this.name, (Object)consumer);
            }
            this.readMoreEntries(consumer);
        }
    }

    @Override
    public void redeliverUnacknowledgedMessages(Consumer consumer) {
        this.topic.getBrokerService().getTopicOrderedExecutor().executeOrdered((Object)this.topicName, (SafeRunnable)SafeRun.safeRun(() -> this.internalRedeliverUnacknowledgedMessages(consumer)));
    }

    private synchronized void internalRedeliverUnacknowledgedMessages(Consumer consumer) {
        if (consumer != AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this)) {
            log.info("[{}-{}] Ignoring reDeliverUnAcknowledgedMessages: Only the active consumer can call resend", (Object)this.name, (Object)consumer);
            return;
        }
        if (this.readOnActiveConsumerTask != null) {
            log.info("[{}-{}] Ignoring reDeliverUnAcknowledgedMessages: consumer is waiting for cursor to be rewinded", (Object)this.name, (Object)consumer);
            return;
        }
        if (this.havePendingRead && this.cursor.cancelPendingReadRequest()) {
            this.havePendingRead = false;
        }
        if (!this.havePendingRead) {
            this.cursor.rewind();
            if (log.isDebugEnabled()) {
                log.debug("[{}-{}] Cursor rewinded, redelivering unacknowledged messages. ", (Object)this.name, (Object)consumer);
            }
            this.readMoreEntries(consumer);
        } else {
            log.info("[{}-{}] Ignoring reDeliverUnAcknowledgedMessages: cancelPendingRequest on cursor failed", (Object)this.name, (Object)consumer);
        }
    }

    @Override
    public void redeliverUnacknowledgedMessages(Consumer consumer, List<PositionImpl> positions) {
        positions.forEach(this.redeliveryTracker::incrementAndGetRedeliveryCount);
        this.redeliverUnacknowledgedMessages(consumer);
    }

    @Override
    protected void readMoreEntries(Consumer consumer) {
        if (consumer == null) {
            return;
        }
        int availablePermits = consumer.getAvailablePermits();
        if (availablePermits > 0) {
            if (!consumer.isWritable()) {
                availablePermits = 1;
            }
            int messagesToRead = Math.min(availablePermits, this.readBatchSize);
            if (this.serviceConfig.isDispatchThrottlingOnNonBacklogConsumerEnabled() || !this.cursor.isActive()) {
                DispatchRateLimiter topicRateLimiter = this.topic.getDispatchRateLimiter();
                if (topicRateLimiter.isDispatchRateLimitingEnabled()) {
                    if (!topicRateLimiter.hasMessageDispatchPermit()) {
                        if (log.isDebugEnabled()) {
                            log.debug("[{}] message-read exceeded topic message-rate {}/{}, schedule after a {}", new Object[]{this.name, topicRateLimiter.getDispatchRateOnMsg(), topicRateLimiter.getDispatchRateOnByte(), 1000});
                        }
                        this.topic.getBrokerService().executor().schedule(() -> {
                            Consumer currentConsumer = AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this);
                            if (currentConsumer != null && !this.havePendingRead) {
                                this.readMoreEntries(currentConsumer);
                            } else if (log.isDebugEnabled()) {
                                log.debug("[{}] Skipping read retry for topic: Current Consumer {}, havePendingRead {}", new Object[]{this.topic.getName(), currentConsumer, this.havePendingRead});
                            }
                        }, 1000L, TimeUnit.MILLISECONDS);
                        return;
                    }
                    long availablePermitsOnMsg = topicRateLimiter.getAvailableDispatchRateLimitOnMsg();
                    if (availablePermitsOnMsg > 0L) {
                        messagesToRead = Math.min(messagesToRead, (int)availablePermitsOnMsg);
                    }
                }
                if (this.dispatchRateLimiter == null) {
                    this.dispatchRateLimiter = new DispatchRateLimiter(this.topic, this.name);
                }
                if (this.dispatchRateLimiter.isDispatchRateLimitingEnabled()) {
                    if (!this.dispatchRateLimiter.hasMessageDispatchPermit()) {
                        if (log.isDebugEnabled()) {
                            log.debug("[{}] message-read exceeded subscription message-rate {}/{}, schedule after a {}", new Object[]{this.name, this.dispatchRateLimiter.getDispatchRateOnMsg(), this.dispatchRateLimiter.getDispatchRateOnByte(), 1000});
                        }
                        this.topic.getBrokerService().executor().schedule(() -> {
                            Consumer currentConsumer = AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this);
                            if (currentConsumer != null && !this.havePendingRead) {
                                this.readMoreEntries(currentConsumer);
                            } else if (log.isDebugEnabled()) {
                                log.debug("[{}] Skipping read retry: Current Consumer {}, havePendingRead {}", new Object[]{this.topic.getName(), currentConsumer, this.havePendingRead});
                            }
                        }, 1000L, TimeUnit.MILLISECONDS);
                        return;
                    }
                    long subPermitsOnMsg = this.dispatchRateLimiter.getAvailableDispatchRateLimitOnMsg();
                    if (subPermitsOnMsg > 0L) {
                        messagesToRead = Math.min(messagesToRead, (int)subPermitsOnMsg);
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}-{}] Schedule read of {} messages", new Object[]{this.name, consumer, messagesToRead});
            }
            this.havePendingRead = true;
            if (consumer.readCompacted()) {
                this.topic.compactedTopic.asyncReadEntriesOrWait(this.cursor, messagesToRead, this, consumer);
            } else {
                this.cursor.asyncReadEntriesOrWait(messagesToRead, (AsyncCallbacks.ReadEntriesCallback)this, (Object)consumer);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("[{}-{}] Consumer buffer is full, pause reading", (Object)this.name, (Object)consumer);
        }
    }

    public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
        this.topic.getBrokerService().getTopicOrderedExecutor().executeOrdered((Object)this.topicName, (SafeRunnable)SafeRun.safeRun(() -> this.internalReadEntriesFailed(exception, ctx)));
    }

    private synchronized void internalReadEntriesFailed(ManagedLedgerException exception, Object ctx) {
        this.havePendingRead = false;
        Consumer c = (Consumer)ctx;
        long waitTimeMillis = this.readFailureBackoff.next();
        if (exception instanceof ManagedLedgerException.NoMoreEntriesToReadException) {
            if (this.cursor.getNumberOfEntriesInBacklog() == 0L) {
                this.consumers.forEach(Consumer::reachedEndOfTopic);
            }
        } else if (!(exception instanceof ManagedLedgerException.TooManyRequestsException)) {
            log.error("[{}-{}] Error reading entries at {} : {} - Retrying to read in {} seconds", new Object[]{this.name, c, this.cursor.getReadPosition(), exception.getMessage(), (double)waitTimeMillis / 1000.0});
        } else if (log.isDebugEnabled()) {
            log.debug("[{}-{}] Got throttled by bookies while reading at {} : {} - Retrying to read in {} seconds", new Object[]{this.name, c, this.cursor.getReadPosition(), exception.getMessage(), (double)waitTimeMillis / 1000.0});
        }
        Preconditions.checkNotNull((Object)c);
        this.readBatchSize = 1;
        this.topic.getBrokerService().executor().schedule(() -> this.topic.getBrokerService().getTopicOrderedExecutor().executeOrdered((Object)this.topicName, (SafeRunnable)SafeRun.safeRun(() -> {
            PersistentDispatcherSingleActiveConsumer persistentDispatcherSingleActiveConsumer = this;
            synchronized (persistentDispatcherSingleActiveConsumer) {
                Consumer currentConsumer = AbstractDispatcherSingleActiveConsumer.ACTIVE_CONSUMER_UPDATER.get(this);
                if (currentConsumer != null && !this.havePendingRead) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}-{}] Retrying read operation", (Object)this.name, (Object)c);
                    }
                    if (currentConsumer != c) {
                        this.notifyActiveConsumerChanged(currentConsumer);
                    }
                    this.readMoreEntries(currentConsumer);
                } else {
                    log.info("[{}-{}] Skipping read retry: Current Consumer {}, havePendingRead {}", new Object[]{this.name, c, currentConsumer, this.havePendingRead});
                }
            }
        })), waitTimeMillis, TimeUnit.MILLISECONDS);
    }

    public DispatchRateLimiter getDispatchRateLimiter() {
        if ((this.serviceConfig.isDispatchThrottlingOnNonBacklogConsumerEnabled() || !this.cursor.isActive()) && this.dispatchRateLimiter == null) {
            this.dispatchRateLimiter = new DispatchRateLimiter(this.topic, this.name);
        }
        return this.dispatchRateLimiter;
    }

    @Override
    public void addUnAckedMessages(int unAckMessages) {
    }

    @Override
    public RedeliveryTracker getRedeliveryTracker() {
        return this.redeliveryTracker;
    }

    @Override
    public DispatchRateLimiter getRateLimiter() {
        return this.dispatchRateLimiter;
    }
}

