/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.common.stats.Metrics;

public class MBeanStatsGenerator {
    private MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();

    public static Collection<Metrics> generate(PulsarService pulsar) {
        return new MBeanStatsGenerator(pulsar).generate();
    }

    MBeanStatsGenerator(PulsarService pulsar) {
    }

    private Collection<Metrics> generate() {
        ArrayList<Metrics> metricsCollection = new ArrayList<Metrics>();
        Set<ObjectInstance> instances = this.mbs.queryMBeans(null, null);
        for (ObjectInstance instance : instances) {
            Metrics metrics;
            String beanName = instance.getObjectName().toString();
            if (beanName.startsWith("java.lang:type=GarbageCollector") || (metrics = this.convert(instance)) == null) continue;
            metricsCollection.add(metrics);
        }
        return metricsCollection;
    }

    private Metrics convert(ObjectInstance instance) {
        ObjectName objName = instance.getObjectName();
        MBeanInfo info = null;
        try {
            info = this.mbs.getMBeanInfo(objName);
        }
        catch (Exception exception) {
            return null;
        }
        Metrics metrics = null;
        metrics = this.createMetricsByDimension(objName);
        MBeanAttributeInfo[] mBeanAttributeInfoArray = info.getAttributes();
        int n = mBeanAttributeInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanAttributeInfo attr = mBeanAttributeInfoArray[n2];
            try {
                Object value = this.mbs.getAttribute(instance.getObjectName(), attr.getName());
                metrics.put(attr.getName(), value);
            }
            catch (Exception exception) {}
            ++n2;
        }
        return metrics;
    }

    private Metrics createMetricsByDimension(ObjectName objectName) {
        HashMap dimensionMap = Maps.newHashMap();
        dimensionMap.put("MBean", objectName.toString());
        return Metrics.create((Map)dimensionMap);
    }
}

