/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.internal.PlatformDependent;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.stats.prometheus.NamespaceStatsAggregator;
import org.apache.pulsar.common.stats.JvmMetrics;
import org.apache.pulsar.common.util.SimpleTextOutputStream;
import org.apache.pulsar.functions.worker.FunctionsStatsGenerator;
import org.apache.pulsar.functions.worker.WorkerService;

public class PrometheusMetricsGenerator {
    static {
        DefaultExports.initialize();
        Gauge.build((String)"jvm_memory_direct_bytes_used", (String)"-").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return JvmMetrics.getJvmDirectMemoryUsed();
            }
        }, new String[0]).register(CollectorRegistry.defaultRegistry);
        Gauge.build((String)"jvm_memory_direct_bytes_max", (String)"-").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return PlatformDependent.maxDirectMemory();
            }
        }, new String[0]).register(CollectorRegistry.defaultRegistry);
    }

    public static void generate(PulsarService pulsar, boolean includeTopicMetrics, boolean includeConsumerMetrics, OutputStream out) throws IOException {
        ByteBuf buf = ByteBufAllocator.DEFAULT.heapBuffer();
        try {
            SimpleTextOutputStream stream = new SimpleTextOutputStream(buf);
            PrometheusMetricsGenerator.generateSystemMetrics(stream, pulsar.getConfiguration().getClusterName());
            NamespaceStatsAggregator.generate(pulsar, includeTopicMetrics, includeConsumerMetrics, stream);
            FunctionsStatsGenerator.generate((WorkerService)pulsar.getWorkerService(), (String)pulsar.getConfiguration().getClusterName(), (SimpleTextOutputStream)stream);
            out.write(buf.array(), buf.arrayOffset(), buf.readableBytes());
        }
        finally {
            buf.release();
        }
    }

    private static void generateSystemMetrics(SimpleTextOutputStream stream, String cluster) {
        Enumeration metricFamilySamples = CollectorRegistry.defaultRegistry.metricFamilySamples();
        while (metricFamilySamples.hasMoreElements()) {
            Collector.MetricFamilySamples metricFamily = (Collector.MetricFamilySamples)metricFamilySamples.nextElement();
            stream.write("# TYPE ").write(metricFamily.name).write(' ').write(PrometheusMetricsGenerator.getTypeStr(metricFamily.type)).write('\n');
            int i = 0;
            while (i < metricFamily.samples.size()) {
                Collector.MetricFamilySamples.Sample sample = (Collector.MetricFamilySamples.Sample)metricFamily.samples.get(i);
                stream.write(sample.name);
                stream.write("{cluster=\"").write(cluster).write('\"');
                int j = 0;
                while (j < sample.labelNames.size()) {
                    stream.write(",");
                    stream.write((String)sample.labelNames.get(j));
                    stream.write("=\"");
                    stream.write((String)sample.labelValues.get(j));
                    stream.write('\"');
                    ++j;
                }
                stream.write("} ");
                stream.write(Collector.doubleToGoString((double)sample.value));
                stream.write('\n');
                ++i;
            }
        }
    }

    static String getTypeStr(Collector.Type type) {
        switch (type) {
            case COUNTER: {
                return "counter";
            }
            case GAUGE: {
                return "gauge";
            }
            case SUMMARY: {
                return "summary";
            }
            case HISTOGRAM: {
                return "histogram";
            }
        }
        return "untyped";
    }
}

