/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.zookeeper.aspectj;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.jute.Record;
import org.apache.zookeeper.proto.ConnectRequest;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.DeleteRequest;
import org.apache.zookeeper.proto.ExistsRequest;
import org.apache.zookeeper.proto.GetACLRequest;
import org.apache.zookeeper.proto.GetChildren2Request;
import org.apache.zookeeper.proto.GetChildrenRequest;
import org.apache.zookeeper.proto.GetDataRequest;
import org.apache.zookeeper.proto.GetMaxChildrenRequest;
import org.apache.zookeeper.proto.GetSASLRequest;
import org.apache.zookeeper.proto.SetACLRequest;
import org.apache.zookeeper.proto.SetDataRequest;
import org.apache.zookeeper.proto.SetMaxChildrenRequest;
import org.apache.zookeeper.proto.SetSASLRequest;
import org.apache.zookeeper.proto.SetWatches;
import org.apache.zookeeper.proto.SyncRequest;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class ClientCnxnAspect {
    private static ExecutorService eventProcessExecutor;
    private static final List<EventListner> listeners;
    private static final Logger LOG;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ ClientCnxnAspect ajc$perSingletonInstance;

    static {
        listeners = Lists.newArrayList();
        LOG = LoggerFactory.getLogger(ClientCnxnAspect.class);
        try {
            ClientCnxnAspect.ajc$perSingletonInstance = new ClientCnxnAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="execution(* org.apache.zookeeper.ClientCnxn.*.processEvent(..))")
    public /* synthetic */ void processEvent() {
    }

    @Around(value="processEvent()")
    public void timedProcessEvent(final ProceedingJoinPoint joinPoint) throws Throwable {
        joinPoint.proceed();
        if (ClientCnxnAspect.eventProcessExecutor != null && !ClientCnxnAspect.eventProcessExecutor.isShutdown()) {
            ClientCnxnAspect.eventProcessExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    ClientCnxnAspect.this.processEvent(joinPoint);
                }
            });
        }
    }

    private void processEvent(ProceedingJoinPoint joinPoint) {
        long startTimeNano = this.getStartTime(joinPoint.getArgs()[0]);
        if (startTimeNano == -1L) {
            return;
        }
        Record request = this.getEventType(joinPoint.getArgs()[0]);
        if (request != null) {
            long timeElapsed = MathUtils.nowInNano() - startTimeNano;
            this.notifyListeners(this.checkType(request), TimeUnit.NANOSECONDS.toMicros(timeElapsed));
        }
    }

    private void notifyListeners(EventType eventType, long timeElapsed) {
        listeners.forEach(listener -> {
            try {
                listener.recordLatency(eventType, timeElapsed);
            }
            catch (Exception e) {
                LOG.warn("Listener failed to record latency ", (Throwable)e);
            }
        });
    }

    private EventType checkType(Record response) {
        if (response == null) {
            return EventType.other;
        }
        if (response instanceof ConnectRequest) {
            return EventType.write;
        }
        if (response instanceof CreateRequest) {
            return EventType.write;
        }
        if (response instanceof DeleteRequest) {
            return EventType.write;
        }
        if (response instanceof SetDataRequest) {
            return EventType.write;
        }
        if (response instanceof SetACLRequest) {
            return EventType.write;
        }
        if (response instanceof SetMaxChildrenRequest) {
            return EventType.write;
        }
        if (response instanceof SetSASLRequest) {
            return EventType.write;
        }
        if (response instanceof SetWatches) {
            return EventType.write;
        }
        if (response instanceof SyncRequest) {
            return EventType.write;
        }
        if (response instanceof ExistsRequest) {
            return EventType.read;
        }
        if (response instanceof GetDataRequest) {
            return EventType.read;
        }
        if (response instanceof GetMaxChildrenRequest) {
            return EventType.read;
        }
        if (response instanceof GetACLRequest) {
            return EventType.read;
        }
        if (response instanceof GetChildrenRequest) {
            return EventType.read;
        }
        if (response instanceof GetChildren2Request) {
            return EventType.read;
        }
        if (response instanceof GetSASLRequest) {
            return EventType.read;
        }
        return EventType.other;
    }

    private long getStartTime(Object packet) {
        block4: {
            try {
                if (packet.getClass().getName().equals("org.apache.zookeeper.ClientCnxn$Packet")) {
                    Field ctxField = Class.forName("org.apache.zookeeper.ClientCnxn$Packet").getDeclaredField("ctx");
                    ctxField.setAccessible(true);
                    Object zooworker = ctxField.get(packet);
                    if (zooworker != null && zooworker.getClass().getName().equals("org.apache.bookkeeper.zookeeper.ZooWorker")) {
                        Field timeField = Class.forName("org.apache.bookkeeper.zookeeper.ZooWorker").getDeclaredField("startTimeNanos");
                        timeField.setAccessible(true);
                        long startTime = (Long)timeField.get(zooworker);
                        return startTime;
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("Failed to get event-start-time from zk-response", (Throwable)e);
            }
        }
        return -1L;
    }

    private Record getEventType(Object packet) {
        block3: {
            try {
                if (packet.getClass().getName().equals("org.apache.zookeeper.ClientCnxn$Packet")) {
                    Field field = Class.forName("org.apache.zookeeper.ClientCnxn$Packet").getDeclaredField("request");
                    field.setAccessible(true);
                    Record response = (Record)field.get(packet);
                    return response;
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Failed to get event-type from zk-response", (Throwable)e);
            }
        }
        return null;
    }

    public static void registerExecutor(ExecutorService executor) {
        eventProcessExecutor = executor;
    }

    public static void addListener(EventListner listener) {
        listeners.add(listener);
    }

    public static void removeListener(EventListner listener) {
        listeners.remove(listener);
    }

    public static ClientCnxnAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.apache.pulsar.broker.zookeeper.aspectj.ClientCnxnAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    public static interface EventListner {
        public void recordLatency(EventType var1, long var2);
    }

    public static enum EventType {
        write,
        read,
        other;

    }
}

