/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarBrokerVersionStringUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarBrokerVersionStringUtils.class);
    private static final String RESOURCE_NAME = "pulsar-broker-version.properties";
    private static final String GIT_RESOURCE_NAME = "pulsar-broker-git.properties";
    private static final Pattern majorMinorPatchPattern = Pattern.compile("([1-9]+[0-9]*)\\.([1-9]+[0-9]*)\\.([1-9]+[0-9]*)(.*)");

    public static String fixVersionString(String version) {
        if (version == null) {
            return null;
        }
        Matcher majorMinorPatchMatcher = majorMinorPatchPattern.matcher(version);
        if (majorMinorPatchMatcher.matches()) {
            return version;
        }
        Pattern pattern2 = Pattern.compile("([1-9]+[0-9]*)\\.([1-9]+[0-9]*)(.*)");
        Matcher matcher2 = pattern2.matcher(version);
        if (matcher2.matches()) {
            int startMajorVersion = matcher2.start(1);
            int stopMinorVersion = matcher2.end(2);
            int startReleaseCandidate = matcher2.start(3);
            String prefix = new String(version.getBytes(), startMajorVersion, stopMinorVersion - startMajorVersion);
            String patchVersion = ".0";
            String suffix = new String(version.getBytes(), startReleaseCandidate, version.length() - startReleaseCandidate);
            return String.valueOf(prefix) + patchVersion + suffix;
        }
        return version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPropertyFromResource(String resource, String propertyName) {
        try {
            InputStream stream = PulsarBrokerVersionStringUtils.class.getClassLoader().getResourceAsStream(resource);
            if (stream == null) {
                return null;
            }
            Properties properties = new Properties();
            try {
                String propertyValue;
                properties.load(stream);
                String string = propertyValue = (String)properties.get(propertyName);
                return string;
            }
            catch (IOException iOException) {
                return null;
            }
            finally {
                stream.close();
            }
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String getNormalizedVersionString() {
        return PulsarBrokerVersionStringUtils.fixVersionString(PulsarBrokerVersionStringUtils.getPropertyFromResource(RESOURCE_NAME, "version"));
    }

    public static String getGitSha() {
        String commit = PulsarBrokerVersionStringUtils.getPropertyFromResource(GIT_RESOURCE_NAME, "git.commit.id");
        String dirtyString = PulsarBrokerVersionStringUtils.getPropertyFromResource(GIT_RESOURCE_NAME, "git.dirty");
        if (dirtyString == null || Boolean.valueOf(dirtyString).booleanValue()) {
            return String.valueOf(commit) + "(dirty)";
        }
        return commit;
    }

    public static String getBuildUser() {
        String email = PulsarBrokerVersionStringUtils.getPropertyFromResource(GIT_RESOURCE_NAME, "git.build.user.email");
        String name = PulsarBrokerVersionStringUtils.getPropertyFromResource(GIT_RESOURCE_NAME, "git.build.user.name");
        return String.format("%s <%s>", name, email);
    }

    public static String getBuildHost() {
        return PulsarBrokerVersionStringUtils.getPropertyFromResource(GIT_RESOURCE_NAME, "git.build.host");
    }

    public static String getBuildTime() {
        return PulsarBrokerVersionStringUtils.getPropertyFromResource(GIT_RESOURCE_NAME, "git.build.time");
    }
}

