/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentReplicator;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceBundles;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.SubscriptionAuthMode;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NamespacesBase
extends AdminResource {
    private static final long MAX_BUNDLES = 0x100000000L;
    private static final Logger log = LoggerFactory.getLogger(NamespacesBase.class);

    protected List<String> internalGetTenantNamespaces(String tenant) {
        this.validateAdminAccessForTenant(tenant);
        try {
            return this.getListOfNamespaces(tenant);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to get namespace list for tenant: {} - Does not exist", (Object)this.clientAppId(), (Object)tenant);
            throw new RestException(Response.Status.NOT_FOUND, "Property does not exist");
        }
        catch (Exception e) {
            log.error("[{}] Failed to get namespaces list: {}", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
    }

    protected void internalCreateNamespace(Policies policies) {
        this.validatePoliciesReadOnlyAccess();
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePolicies(this.namespaceName, policies);
        try {
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            this.zkCreateOptimistic(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies));
            log.info("[{}] Created namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (KeeperException.NodeExistsException e) {
            log.warn("[{}] Failed to create namespace {} - already exists", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Namespace already exists");
        }
        catch (Exception e) {
            log.error("[{}] Failed to create namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalDeleteNamespace(boolean authoritative) {
        boolean isEmpty;
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        if (!this.namespaceName.isGlobal()) {
            this.validateClusterOwnership(this.namespaceName.getCluster());
        }
        Map.Entry policiesNode = null;
        Policies policies = null;
        try {
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(NamespacesBase.path("policies", this.namespaceName.toString())).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist."));
            policies = (Policies)policiesNode.getKey();
            if (this.namespaceName.isGlobal()) {
                if (policies.replication_clusters.size() > 1) {
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot delete the global namespace " + this.namespaceName + ". There are still more than one replication clusters configured.");
                }
                if (policies.replication_clusters.size() == 1 && !policies.replication_clusters.contains(this.config().getClusterName())) {
                    URL replClusterUrl;
                    String replCluster = (String)Lists.newArrayList((Iterable)policies.replication_clusters).get(0);
                    ClusterData replClusterData = (ClusterData)this.clustersCache().get(AdminResource.path("clusters", replCluster)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Cluster " + replCluster + " does not exist"));
                    if (!this.config().isTlsEnabled() || !this.isRequestHttps()) {
                        replClusterUrl = new URL(replClusterData.getServiceUrl());
                    } else if (StringUtils.isNotBlank((CharSequence)replClusterData.getServiceUrlTls())) {
                        replClusterUrl = new URL(replClusterData.getServiceUrlTls());
                    } else {
                        throw new RestException(Response.Status.PRECONDITION_FAILED, "The replication cluster does not provide TLS encrypted service");
                    }
                    URI redirect = UriBuilder.fromUri((URI)this.uri.getRequestUri()).host(replClusterUrl.getHost()).port(replClusterUrl.getPort()).replaceQueryParam("authoritative", new Object[]{false}).build(new Object[0]);
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Redirecting the rest call to {}: cluster={}", new Object[]{this.clientAppId(), redirect, replCluster});
                    }
                    throw new WebApplicationException(Response.temporaryRedirect((URI)redirect).build());
                }
            }
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception e) {
            throw new RestException(e);
        }
        try {
            isEmpty = this.pulsar().getNamespaceService().getListOfPersistentTopics(this.namespaceName).isEmpty() && this.getPartitionedTopicList(TopicDomain.persistent).isEmpty() && this.getPartitionedTopicList(TopicDomain.non_persistent).isEmpty();
        }
        catch (Exception e) {
            throw new RestException(e);
        }
        if (!isEmpty) {
            log.debug("Found topics on namespace {}", (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Cannot delete non empty namespace");
        }
        try {
            policies.deleted = true;
            this.globalZk().setData(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
        }
        catch (Exception e) {
            log.error("[{}] Failed to delete namespace on global ZK {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
        try {
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(this.namespaceName);
            for (NamespaceBundle bundle : bundles.getBundles()) {
                if (!this.pulsar().getNamespaceService().getOwner(bundle).isPresent()) continue;
                this.pulsar().getAdminClient().namespaces().deleteNamespaceBundle(this.namespaceName.toString(), bundle.getBundleRange());
            }
            String globalZkPolicyPath = NamespacesBase.path("policies", this.namespaceName.toString());
            String lcaolZkPolicyPath = NamespacesBase.joinPath("/admin/local-policies", this.namespaceName.toString());
            this.globalZk().delete(globalZkPolicyPath, -1);
            this.localZk().delete(lcaolZkPolicyPath, -1);
            this.policiesCache().invalidate(globalZkPolicyPath);
            this.localCacheService().policiesCache().invalidate(lcaolZkPolicyPath);
        }
        catch (PulsarAdminException cae) {
            throw new RestException(cae);
        }
        catch (Exception e) {
            log.error("[{}] Failed to remove owned namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
        }
    }

    protected void internalDeleteNamespaceBundle(String bundleRange, boolean authoritative) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        if (!this.namespaceName.isGlobal()) {
            this.validateClusterOwnership(this.namespaceName.getCluster());
        }
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        try {
            if (this.namespaceName.isGlobal()) {
                if (policies.replication_clusters.size() > 1) {
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot delete the global namespace " + this.namespaceName + ". There are still more than one replication clusters configured.");
                }
                if (policies.replication_clusters.size() == 1 && !policies.replication_clusters.contains(this.config().getClusterName())) {
                    URL replClusterUrl;
                    String replCluster = (String)Lists.newArrayList((Iterable)policies.replication_clusters).get(0);
                    ClusterData replClusterData = (ClusterData)this.clustersCache().get(AdminResource.path("clusters", replCluster)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Cluser " + replCluster + " does not exist"));
                    if (!this.config().isTlsEnabled() || !this.isRequestHttps()) {
                        replClusterUrl = new URL(replClusterData.getServiceUrl());
                    } else if (StringUtils.isNotBlank((CharSequence)replClusterData.getServiceUrlTls())) {
                        replClusterUrl = new URL(replClusterData.getServiceUrlTls());
                    } else {
                        throw new RestException(Response.Status.PRECONDITION_FAILED, "The replication cluster does not provide TLS encrypted service");
                    }
                    URI redirect = UriBuilder.fromUri((URI)this.uri.getRequestUri()).host(replClusterUrl.getHost()).port(replClusterUrl.getPort()).replaceQueryParam("authoritative", new Object[]{false}).build(new Object[0]);
                    log.debug("[{}] Redirecting the rest call to {}: cluster={}", new Object[]{this.clientAppId(), redirect, replCluster});
                    throw new WebApplicationException(Response.temporaryRedirect((URI)redirect).build());
                }
            }
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception e) {
            throw new RestException(e);
        }
        NamespaceBundle bundle = this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
        try {
            List<String> topics = this.pulsar().getNamespaceService().getListOfPersistentTopics(this.namespaceName);
            for (String topic : topics) {
                NamespaceBundle topicBundle = this.pulsar().getNamespaceService().getBundle(TopicName.get((String)topic));
                if (!bundle.equals(topicBundle)) continue;
                throw new RestException(Response.Status.CONFLICT, "Cannot delete non empty bundle");
            }
            this.pulsar().getNamespaceService().removeOwnedServiceUnit(bundle);
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception e) {
            log.error("[{}] Failed to remove namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName.toString(), bundleRange, e});
            throw new RestException(e);
        }
    }

    protected void internalGrantPermissionOnNamespace(String role, Set<AuthAction> actions) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        try {
            AuthorizationService authService = this.pulsar().getBrokerService().getAuthorizationService();
            if (null == authService) {
                throw new RestException(Response.Status.NOT_IMPLEMENTED, "Authorization is not enabled");
            }
            authService.grantPermissionAsync(this.namespaceName, actions, role, null).get();
        }
        catch (InterruptedException e) {
            log.error("[{}] Failed to get permissions for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                log.warn("[{}] Failed to set permissions for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
                throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
            }
            if (e.getCause() instanceof IllegalStateException) {
                log.warn("[{}] Failed to set permissions for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
                throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
            }
            log.error("[{}] Failed to get permissions for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalGrantPermissionOnSubscription(String subscription, Set<String> roles) {
        this.validateSuperUserAccess();
        try {
            AuthorizationService authService = this.pulsar().getBrokerService().getAuthorizationService();
            if (null == authService) {
                throw new RestException(Response.Status.NOT_IMPLEMENTED, "Authorization is not enabled");
            }
            authService.grantSubscriptionPermissionAsync(this.namespaceName, subscription, roles, null).get();
        }
        catch (InterruptedException e) {
            log.error("[{}] Failed to get permissions for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                log.warn("[{}] Failed to set permissions for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
                throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
            }
            if (e.getCause() instanceof IllegalStateException) {
                log.warn("[{}] Failed to set permissions for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
                throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
            }
            log.error("[{}] Failed to get permissions for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalRevokePermissionsOnNamespace(String role) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        try {
            Stat nodeStat = new Stat();
            byte[] content = this.globalZk().getData(NamespacesBase.path("policies", this.namespaceName.toString()), null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            policies.auth_policies.namespace_auth.remove(role);
            this.globalZk().setData(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully revoked access for role {} - namespace {}", new Object[]{this.clientAppId(), role, this.namespaceName});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to revoke permissions for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to revoke permissions on namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to revoke permissions on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalRevokePermissionsOnSubscription(String subscriptionName, String role) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        AuthorizationService authService = this.pulsar().getBrokerService().getAuthorizationService();
        if (null == authService) {
            throw new RestException(Response.Status.NOT_IMPLEMENTED, "Authorization is not enabled");
        }
        authService.revokeSubscriptionPermissionAsync(this.namespaceName, subscriptionName, role, null);
    }

    protected Set<String> internalGetNamespaceReplicationClusters() {
        if (!this.namespaceName.isGlobal()) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot get the replication clusters for a non-global namespace");
        }
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.replication_clusters;
    }

    protected void internalSetNamespaceReplicationClusters(List<String> clusterIds) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        HashSet replicationClusterSet = Sets.newHashSet(clusterIds);
        if (!this.namespaceName.isGlobal()) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot set replication on a non-global namespace");
        }
        if (replicationClusterSet.contains("global")) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot specify global in the list of replication clusters");
        }
        Set<String> clusters = this.clusters();
        for (String clusterId : replicationClusterSet) {
            if (!clusters.contains(clusterId)) {
                throw new RestException(Response.Status.FORBIDDEN, "Invalid cluster id: " + clusterId);
            }
            this.validatePeerClusterConflict(clusterId, replicationClusterSet);
        }
        for (String clusterId : replicationClusterSet) {
            this.validateClusterForTenant(this.namespaceName.getTenant(), clusterId);
        }
        Map.Entry policiesNode = null;
        try {
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(NamespacesBase.path("policies", this.namespaceName.toString())).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist"));
            ((Policies)policiesNode.getKey()).replication_clusters = replicationClusterSet;
            this.globalZk().setData(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated the replication clusters on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update the replication clusters for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update the replication clusters on namespace {} expected policy node version={} : concurrent modification", new Object[]{this.clientAppId(), this.namespaceName, ((Stat)policiesNode.getValue()).getVersion()});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update the replication clusters on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetNamespaceMessageTTL(int messageTTL) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        if (messageTTL < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Invalid value for message TTL");
        }
        Map.Entry policiesNode = null;
        try {
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(NamespacesBase.path("policies", this.namespaceName.toString())).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist"));
            ((Policies)policiesNode.getKey()).message_ttl_in_seconds = messageTTL;
            this.globalZk().setData(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated the message TTL on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update the message TTL for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update the message TTL on namespace {} expected policy node version={} : concurrent modification", new Object[]{this.clientAppId(), this.namespaceName, ((Stat)policiesNode.getValue()).getVersion()});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update the message TTL on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalModifyDeduplication(boolean enableDeduplication) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        Map.Entry policiesNode = null;
        try {
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(NamespacesBase.path("policies", this.namespaceName.toString())).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist"));
            ((Policies)policiesNode.getKey()).deduplicationEnabled = enableDeduplication;
            this.globalZk().setData(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully {} on namespace {}", new Object[]{this.clientAppId(), enableDeduplication ? "enabled" : "disabled", this.namespaceName});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to modify deplication status for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to modify deplication status on namespace {} expected policy node version={} : concurrent modification", new Object[]{this.clientAppId(), this.namespaceName, ((Stat)policiesNode.getValue()).getVersion()});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to modify deplication status on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalUnloadNamespace() {
        log.info("[{}] Unloading namespace {}", (Object)this.clientAppId());
        this.validateSuperUserAccess();
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        List boundaries = policies.bundles.getBoundaries();
        for (int i = 0; i < boundaries.size() - 1; ++i) {
            String bundle = String.format("%s_%s", boundaries.get(i), boundaries.get(i + 1));
            try {
                this.pulsar().getAdminClient().namespaces().unloadNamespaceBundle(this.namespaceName.toString(), bundle);
                continue;
            }
            catch (PulsarServerException | PulsarAdminException e) {
                log.error(String.format("[%s] Failed to unload namespace %s", this.clientAppId(), this.namespaceName), e);
                throw new RestException(e);
            }
        }
        log.info("[{}] Successfully unloaded all the bundles in namespace {}/{}/{}", (Object)this.clientAppId(), (Object)this.namespaceName);
    }

    public void internalUnloadNamespaceBundle(String bundleRange, boolean authoritative) {
        log.info("[{}] Unloading namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange});
        this.validateSuperUserAccess();
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        this.validatePoliciesReadOnlyAccess();
        if (!this.isBundleOwnedByAnyBroker(this.namespaceName, policies.bundles, bundleRange)) {
            log.info("[{}] Namespace bundle is not owned by any broker {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange});
            return;
        }
        NamespaceBundle nsBundle = this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
        try {
            this.pulsar().getNamespaceService().unloadNamespaceBundle(nsBundle);
            log.info("[{}] Successfully unloaded namespace bundle {}", (Object)this.clientAppId(), (Object)nsBundle.toString());
        }
        catch (Exception e) {
            log.error("[{}] Failed to unload namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange, e});
            throw new RestException(e);
        }
    }

    protected void internalSplitNamespaceBundle(String bundleRange, boolean authoritative, boolean unload) {
        log.info("[{}] Split namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange});
        this.validateSuperUserAccess();
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        this.validatePoliciesReadOnlyAccess();
        NamespaceBundle nsBundle = this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
        try {
            this.pulsar().getNamespaceService().splitAndOwnBundle(nsBundle, unload).get();
            log.info("[{}] Successfully split namespace bundle {}", (Object)this.clientAppId(), (Object)nsBundle.toString());
        }
        catch (IllegalArgumentException e) {
            log.error("[{}] Failed to split namespace bundle {}/{} due to {}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange, e.getMessage()});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Split bundle failed due to invalid request");
        }
        catch (Exception e) {
            log.error("[{}] Failed to split namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange, e});
            throw new RestException(e);
        }
    }

    protected void internalSetDispatchRate(DispatchRate dispatchRate) {
        log.info("[{}] Set namespace dispatch-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, dispatchRate});
        this.validateSuperUserAccess();
        Map.Entry policiesNode = null;
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(path).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist"));
            ((Policies)policiesNode.getKey()).clusterDispatchRate.put(this.pulsar().getConfiguration().getClusterName(), dispatchRate);
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(path);
            log.info("[{}] Successfully updated the dispatchRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update the dispatchRate for cluster on namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update the dispatchRate for cluster on namespace {} expected policy node version={} : concurrent modification", new Object[]{this.clientAppId(), this.namespaceName, ((Stat)policiesNode.getValue()).getVersion()});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update the dispatchRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected DispatchRate internalGetDispatchRate() {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        DispatchRate dispatchRate = (DispatchRate)policies.clusterDispatchRate.get(this.pulsar().getConfiguration().getClusterName());
        if (dispatchRate != null) {
            return dispatchRate;
        }
        throw new RestException(Response.Status.NOT_FOUND, "Dispatch-rate is not configured for cluster " + this.pulsar().getConfiguration().getClusterName());
    }

    protected void internalSetSubscriptionDispatchRate(DispatchRate dispatchRate) {
        log.info("[{}] Set namespace subscription dispatch-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, dispatchRate});
        this.validateSuperUserAccess();
        Map.Entry policiesNode = null;
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(path).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist"));
            ((Policies)policiesNode.getKey()).subscriptionDispatchRate.put(this.pulsar().getConfiguration().getClusterName(), dispatchRate);
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(path);
            log.info("[{}] Successfully updated the subscriptionDispatchRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update the subscriptionDispatchRate for cluster on namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update the subscriptionDispatchRate for cluster on namespace {} expected policy node version={} : concurrent modification", new Object[]{this.clientAppId(), this.namespaceName, ((Stat)policiesNode.getValue()).getVersion()});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update the subscriptionDispatchRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected DispatchRate internalGetSubscriptionDispatchRate() {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        DispatchRate dispatchRate = (DispatchRate)policies.subscriptionDispatchRate.get(this.pulsar().getConfiguration().getClusterName());
        if (dispatchRate != null) {
            return dispatchRate;
        }
        throw new RestException(Response.Status.NOT_FOUND, "Subscription-Dispatch-rate is not configured for cluster " + this.pulsar().getConfiguration().getClusterName());
    }

    protected void internalSetSubscribeRate(SubscribeRate subscribeRate) {
        log.info("[{}] Set namespace subscribe-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, subscribeRate});
        this.validateSuperUserAccess();
        Map.Entry policiesNode = null;
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(path).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist"));
            ((Policies)policiesNode.getKey()).clusterSubscribeRate.put(this.pulsar().getConfiguration().getClusterName(), subscribeRate);
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(path);
            log.info("[{}] Successfully updated the subscribeRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update the subscribeRate for cluster on namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update the subscribeRate for cluster on namespace {} expected policy node version={} : concurrent modification", new Object[]{this.clientAppId(), this.namespaceName, ((Stat)policiesNode.getValue()).getVersion()});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update the subscribeRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected SubscribeRate internalGetSubscribeRate() {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        SubscribeRate subscribeRate = (SubscribeRate)policies.clusterSubscribeRate.get(this.pulsar().getConfiguration().getClusterName());
        if (subscribeRate != null) {
            return subscribeRate;
        }
        throw new RestException(Response.Status.NOT_FOUND, "Subscribe-rate is not configured for cluster " + this.pulsar().getConfiguration().getClusterName());
    }

    protected void internalSetBacklogQuota(BacklogQuota.BacklogQuotaType backlogQuotaType, BacklogQuota backlogQuota) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        if (backlogQuotaType == null) {
            backlogQuotaType = BacklogQuota.BacklogQuotaType.destination_storage;
        }
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            RetentionPolicies r = policies.retention_policies;
            if (r != null) {
                Policies p = new Policies();
                p.backlog_quota_map.put(backlogQuotaType, backlogQuota);
                if (!this.checkQuotas(p, r)) {
                    log.warn("[{}] Failed to update backlog configuration for namespace {}: conflicts with retention quota", (Object)this.clientAppId(), (Object)this.namespaceName);
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "Backlog Quota exceeds configured retention quota for namespace. Please increase retention quota and retry");
                }
            }
            policies.backlog_quota_map.put(backlogQuotaType, backlogQuota);
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated backlog quota map: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, NamespacesBase.jsonMapper().writeValueAsString((Object)policies.backlog_quota_map)});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update backlog quota map for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update backlog quota map for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update backlog quota map for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalRemoveBacklogQuota(BacklogQuota.BacklogQuotaType backlogQuotaType) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        if (backlogQuotaType == null) {
            backlogQuotaType = BacklogQuota.BacklogQuotaType.destination_storage;
        }
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            policies.backlog_quota_map.remove(backlogQuotaType);
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully removed backlog namespace={}, quota={}", new Object[]{this.clientAppId(), this.namespaceName, backlogQuotaType});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update backlog quota map for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update backlog quota map for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update backlog quota map for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetRetention(RetentionPolicies retention) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            if (!this.checkQuotas(policies, retention)) {
                log.warn("[{}] Failed to update retention configuration for namespace {}: conflicts with backlog quota", (Object)this.clientAppId(), (Object)this.namespaceName);
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Retention Quota must exceed configured backlog quota for namespace.");
            }
            policies.retention_policies = retention;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated retention configuration: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, NamespacesBase.jsonMapper().writeValueAsString((Object)policies.retention_policies)});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update retention configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update retention configuration for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update retention configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetPersistence(PersistencePolicies persistence) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        this.validatePersistencePolicies(persistence);
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            policies.persistence = persistence;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated persistence configuration: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, NamespacesBase.jsonMapper().writeValueAsString((Object)policies.persistence)});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update persistence configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update persistence configuration for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update persistence configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected PersistencePolicies internalGetPersistence() {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (policies.persistence == null) {
            return new PersistencePolicies(this.config().getManagedLedgerDefaultEnsembleSize(), this.config().getManagedLedgerDefaultWriteQuorum(), this.config().getManagedLedgerDefaultAckQuorum(), 0.0);
        }
        return policies.persistence;
    }

    protected void internalClearNamespaceBacklog(boolean authoritative) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        try {
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(this.namespaceName);
            Throwable exception = null;
            for (NamespaceBundle nsBundle : bundles.getBundles()) {
                try {
                    if (!this.pulsar().getNamespaceService().getOwner(nsBundle).isPresent()) continue;
                    this.pulsar().getAdminClient().namespaces().clearNamespaceBundleBacklog(this.namespaceName.toString(), nsBundle.getBundleRange());
                }
                catch (Exception e) {
                    if (exception != null) continue;
                    exception = e;
                }
            }
            if (exception != null) {
                if (exception instanceof PulsarAdminException) {
                    throw new RestException((PulsarAdminException)exception);
                }
                throw new RestException(exception.getCause());
            }
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception e) {
            throw new RestException(e);
        }
        log.info("[{}] Successfully cleared backlog on all the bundles for namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
    }

    protected void internalClearNamespaceBundleBacklog(String bundleRange, boolean authoritative) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
        this.clearBacklog(this.namespaceName, bundleRange, null);
        log.info("[{}] Successfully cleared backlog on namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange});
    }

    protected void internalClearNamespaceBacklogForSubscription(String subscription, boolean authoritative) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        try {
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(this.namespaceName);
            Throwable exception = null;
            for (NamespaceBundle nsBundle : bundles.getBundles()) {
                try {
                    if (!this.pulsar().getNamespaceService().getOwner(nsBundle).isPresent()) continue;
                    this.pulsar().getAdminClient().namespaces().clearNamespaceBundleBacklogForSubscription(this.namespaceName.toString(), nsBundle.getBundleRange(), subscription);
                }
                catch (Exception e) {
                    if (exception != null) continue;
                    exception = e;
                }
            }
            if (exception != null) {
                if (exception instanceof PulsarAdminException) {
                    throw new RestException((PulsarAdminException)exception);
                }
                throw new RestException(exception.getCause());
            }
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception e) {
            throw new RestException(e);
        }
        log.info("[{}] Successfully cleared backlog for subscription {} on all the bundles for namespace {}", new Object[]{this.clientAppId(), subscription, this.namespaceName});
    }

    protected void internalClearNamespaceBundleBacklogForSubscription(String subscription, String bundleRange, boolean authoritative) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
        this.clearBacklog(this.namespaceName, bundleRange, subscription);
        log.info("[{}] Successfully cleared backlog for subscription {} on namespace bundle {}/{}", new Object[]{this.clientAppId(), subscription, this.namespaceName, bundleRange});
    }

    protected void internalUnsubscribeNamespace(String subscription, boolean authoritative) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        try {
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(this.namespaceName);
            Throwable exception = null;
            for (NamespaceBundle nsBundle : bundles.getBundles()) {
                try {
                    if (!this.pulsar().getNamespaceService().getOwner(nsBundle).isPresent()) continue;
                    this.pulsar().getAdminClient().namespaces().unsubscribeNamespaceBundle(this.namespaceName.toString(), nsBundle.getBundleRange(), subscription);
                }
                catch (Exception e) {
                    if (exception != null) continue;
                    exception = e;
                }
            }
            if (exception != null) {
                if (exception instanceof PulsarAdminException) {
                    throw new RestException((PulsarAdminException)exception);
                }
                throw new RestException(exception.getCause());
            }
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception e) {
            throw new RestException(e);
        }
        log.info("[{}] Successfully unsubscribed {} on all the bundles for namespace {}", new Object[]{this.clientAppId(), subscription, this.namespaceName});
    }

    protected void internalUnsubscribeNamespaceBundle(String subscription, String bundleRange, boolean authoritative) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
        this.unsubscribe(this.namespaceName, bundleRange, subscription);
        log.info("[{}] Successfully unsubscribed {} on namespace bundle {}/{}", new Object[]{this.clientAppId(), subscription, this.namespaceName, bundleRange});
    }

    protected void internalSetSubscriptionAuthMode(SubscriptionAuthMode subscriptionAuthMode) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        if (subscriptionAuthMode == null) {
            subscriptionAuthMode = SubscriptionAuthMode.None;
        }
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            policies.subscription_auth_mode = subscriptionAuthMode;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated subscription auth mode: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, NamespacesBase.jsonMapper().writeValueAsString((Object)policies.backlog_quota_map)});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update subscription auth mode for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update subscription auth mode for namespace {}/{}/{}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update subscription auth mode for namespace {}/{}/{}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalModifyEncryptionRequired(boolean encryptionRequired) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        Map.Entry policiesNode = null;
        try {
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(NamespacesBase.path("policies", this.namespaceName.toString())).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist"));
            ((Policies)policiesNode.getKey()).encryption_required = encryptionRequired;
            this.globalZk().setData(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully {} on namespace {}", new Object[]{this.clientAppId(), encryptionRequired ? "true" : "false", this.namespaceName});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to modify encryption required status for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to modify encryption required status on namespace {} expected policy node version={} : concurrent modification", new Object[]{this.clientAppId(), this.namespaceName, ((Stat)policiesNode.getValue()).getVersion()});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to modify encryption required status on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetNamespaceAntiAffinityGroup(String antiAffinityGroup) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        log.info("[{}] Setting anti-affinity group {} for {}", new Object[]{this.clientAppId(), antiAffinityGroup, this.namespaceName});
        if (StringUtils.isBlank((CharSequence)antiAffinityGroup)) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "antiAffinityGroup can't be empty");
        }
        Map.Entry policiesNode = null;
        try {
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(NamespacesBase.path("policies", this.namespaceName.toString())).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist"));
            ((Policies)policiesNode.getKey()).antiAffinityGroup = antiAffinityGroup;
            this.globalZk().setData(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated the antiAffinityGroup {} on namespace {}", new Object[]{this.clientAppId(), antiAffinityGroup, this.namespaceName});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update the antiAffinityGroup for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update the antiAffinityGroup on namespace {} expected policy node version={} : concurrent modification", new Object[]{this.clientAppId(), this.namespaceName, ((Stat)policiesNode.getValue()).getVersion()});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update the antiAffinityGroup on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected String internalGetNamespaceAntiAffinityGroup() {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).antiAffinityGroup;
    }

    protected void internalRemoveNamespaceAntiAffinityGroup() {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        log.info("[{}] Deleting anti-affinity group for {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            policies.antiAffinityGroup = null;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully removed anti-affinity group for a namespace={}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to remove anti-affinity group for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to remove anti-affinity group for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to remove anti-affinity group for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected List<String> internalGetAntiAffinityNamespaces(String cluster, String antiAffinityGroup, String tenant) {
        this.validateAdminAccessForTenant(tenant);
        log.info("[{}]-{} Finding namespaces for {} in {}", new Object[]{this.clientAppId(), tenant, antiAffinityGroup, cluster});
        if (StringUtils.isBlank((CharSequence)antiAffinityGroup)) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "anti-affinity group can't be empty.");
        }
        this.validateClusterExists(cluster);
        try {
            List<String> namespaces = this.getListOfNamespaces(tenant);
            return namespaces.stream().filter(ns -> {
                Optional policies;
                try {
                    policies = this.policiesCache().get(AdminResource.path("policies", ns.toString()));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                String storedAntiAffinityGroup = policies.orElse(new Policies()).antiAffinityGroup;
                return antiAffinityGroup.equalsIgnoreCase(storedAntiAffinityGroup);
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.warn("Failed to list of properties/namespace from global-zk", (Throwable)e);
            throw new RestException(e);
        }
    }

    private void validatePersistencePolicies(PersistencePolicies persistence) {
        try {
            Preconditions.checkNotNull((Object)persistence);
            ServiceConfiguration config = this.pulsar().getConfiguration();
            Preconditions.checkArgument((persistence.getBookkeeperEnsemble() <= config.getManagedLedgerMaxEnsembleSize() ? 1 : 0) != 0, (String)"Bookkeeper-Ensemble must be <= %s", (int)config.getManagedLedgerMaxEnsembleSize());
            Preconditions.checkArgument((persistence.getBookkeeperWriteQuorum() <= config.getManagedLedgerMaxWriteQuorum() ? 1 : 0) != 0, (String)"Bookkeeper-WriteQuorum must be <= %s", (int)config.getManagedLedgerMaxWriteQuorum());
            Preconditions.checkArgument((persistence.getBookkeeperAckQuorum() <= config.getManagedLedgerMaxAckQuorum() ? 1 : 0) != 0, (String)"Bookkeeper-AckQuorum must be <= %s", (int)config.getManagedLedgerMaxAckQuorum());
            Preconditions.checkArgument((persistence.getBookkeeperEnsemble() >= persistence.getBookkeeperWriteQuorum() && persistence.getBookkeeperWriteQuorum() >= persistence.getBookkeeperAckQuorum() ? 1 : 0) != 0, (String)"Bookkeeper Ensemble (%s) >= WriteQuorum (%s) >= AckQuoru (%s)", (Object)persistence.getBookkeeperEnsemble(), (Object)persistence.getBookkeeperWriteQuorum(), (Object)persistence.getBookkeeperAckQuorum());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, e.getMessage());
        }
    }

    protected RetentionPolicies internalGetRetention() {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (policies.retention_policies == null) {
            return new RetentionPolicies(this.config().getDefaultRetentionTimeInMinutes(), this.config().getDefaultRetentionSizeInMB());
        }
        return policies.retention_policies;
    }

    private boolean checkQuotas(Policies policies, RetentionPolicies retention) {
        Map backlog_quota_map = policies.backlog_quota_map;
        if (backlog_quota_map.isEmpty() || retention.getRetentionSizeInMB() == 0L || retention.getRetentionSizeInMB() == -1L) {
            return true;
        }
        BacklogQuota quota = (BacklogQuota)backlog_quota_map.get(BacklogQuota.BacklogQuotaType.destination_storage);
        if (quota == null) {
            quota = this.pulsar().getBrokerService().getBacklogQuotaManager().getDefaultQuota();
        }
        return quota.getLimit() < retention.getRetentionSizeInMB() * 1024L * 1024L;
    }

    private void clearBacklog(NamespaceName nsName, String bundleRange, String subscription) {
        try {
            List<Topic> topicList = this.pulsar().getBrokerService().getAllTopicsFromNamespaceBundle(nsName.toString(), nsName.toString() + "/" + bundleRange);
            ArrayList futures = Lists.newArrayList();
            if (subscription != null) {
                if (subscription.startsWith(this.pulsar().getConfiguration().getReplicatorPrefix())) {
                    subscription = PersistentReplicator.getRemoteCluster(subscription);
                }
                for (Topic topic : topicList) {
                    if (!(topic instanceof PersistentTopic)) continue;
                    futures.add(((PersistentTopic)topic).clearBacklog(subscription));
                }
            } else {
                for (Topic topic : topicList) {
                    if (!(topic instanceof PersistentTopic)) continue;
                    futures.add(((PersistentTopic)topic).clearBacklog());
                }
            }
            FutureUtil.waitForAll((List)futures).get();
        }
        catch (Exception e) {
            log.error("[{}] Failed to clear backlog for namespace {}/{}, subscription: {}", new Object[]{this.clientAppId(), nsName.toString(), bundleRange, subscription, e});
            throw new RestException(e);
        }
    }

    private void unsubscribe(NamespaceName nsName, String bundleRange, String subscription) {
        try {
            List<Topic> topicList = this.pulsar().getBrokerService().getAllTopicsFromNamespaceBundle(nsName.toString(), nsName.toString() + "/" + bundleRange);
            ArrayList futures = Lists.newArrayList();
            if (subscription.startsWith(this.pulsar().getConfiguration().getReplicatorPrefix())) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot unsubscribe a replication cursor");
            }
            for (Topic topic : topicList) {
                Subscription sub = topic.getSubscription(subscription);
                if (sub == null) continue;
                futures.add(sub.delete());
            }
            FutureUtil.waitForAll((List)futures).get();
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("[{}] Failed to unsubscribe {} for namespace {}/{}", new Object[]{this.clientAppId(), subscription, nsName.toString(), bundleRange, e});
            if (e.getCause() instanceof BrokerServiceException.SubscriptionBusyException) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Subscription has active connected consumers");
            }
            throw new RestException(e.getCause());
        }
    }

    private void validatePeerClusterConflict(String clusterName, Set<String> replicationClusters) {
        try {
            Sets.SetView conflictPeerClusters;
            ClusterData clusterData = (ClusterData)this.clustersCache().get(NamespacesBase.path("clusters", clusterName)).orElseThrow(() -> new RestException(Response.Status.PRECONDITION_FAILED, "Invalid replication cluster " + clusterName));
            LinkedHashSet peerClusters = clusterData.getPeerClusterNames();
            if (peerClusters != null && !peerClusters.isEmpty() && !(conflictPeerClusters = Sets.intersection((Set)peerClusters, replicationClusters)).isEmpty()) {
                log.warn("[{}] {}'s peer cluster can't be part of replication clusters {}", new Object[]{this.clientAppId(), clusterName, conflictPeerClusters});
                throw new RestException(Response.Status.CONFLICT, String.format("%s's peer-clusters %s can't be part of replication-clusters %s", clusterName, conflictPeerClusters, replicationClusters));
            }
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.warn("[{}] Failed to get cluster-data for {}", new Object[]{this.clientAppId(), clusterName, e});
        }
    }

    protected BundlesData validateBundlesData(BundlesData initialBundles) {
        TreeSet<String> partitions = new TreeSet<String>();
        for (String partition : initialBundles.getBoundaries()) {
            Long partBoundary = Long.decode(partition);
            partitions.add(String.format("0x%08x", partBoundary));
        }
        if (partitions.size() != initialBundles.getBoundaries().size()) {
            log.debug("Input bundles included repeated partition points. Ignored.");
        }
        try {
            NamespaceBundleFactory.validateFullRange(partitions);
        }
        catch (IllegalArgumentException iae) {
            throw new RestException(Response.Status.BAD_REQUEST, "Input bundles do not cover the whole hash range. first:" + (String)partitions.first() + ", last:" + (String)partitions.last());
        }
        ArrayList bundles = Lists.newArrayList();
        bundles.addAll(partitions);
        return new BundlesData((List)bundles);
    }

    public static BundlesData getBundles(int numBundles) {
        if (numBundles <= 0 || (long)numBundles > 0x100000000L) {
            throw new RestException(Response.Status.BAD_REQUEST, "Invalid number of bundles. Number of numbles has to be in the range of (0, 2^32].");
        }
        Long maxVal = 0x100000000L;
        Long segSize = maxVal / (long)numBundles;
        ArrayList partitions = Lists.newArrayList();
        partitions.add(String.format("0x%08x", 0L));
        Long curPartition = segSize;
        for (int i = 0; i < numBundles; ++i) {
            if (i != numBundles - 1) {
                partitions.add(String.format("0x%08x", curPartition));
            } else {
                partitions.add(String.format("0x%08x", maxVal - 1L));
            }
            curPartition = curPartition + segSize;
        }
        return new BundlesData((List)partitions);
    }

    private void validatePolicies(NamespaceName ns, Policies policies) {
        if (ns.isV2() && policies.replication_clusters.isEmpty()) {
            policies.replication_clusters = Collections.singleton(this.config().getClusterName());
        }
        policies.replication_clusters.forEach(cluster -> this.validateClusterForTenant(ns.getTenant(), (String)cluster));
        if (policies.message_ttl_in_seconds < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Invalid value for message TTL");
        }
        if (policies.bundles != null && policies.bundles.getNumBundles() > 0) {
            policies.bundles = policies.bundles.getBoundaries() == null || policies.bundles.getBoundaries().size() == 0 ? NamespacesBase.getBundles(policies.bundles.getNumBundles()) : this.validateBundlesData(policies.bundles);
        } else {
            int defaultNumberOfBundles = this.config().getDefaultNumberOfNamespaceBundles();
            policies.bundles = NamespacesBase.getBundles(defaultNumberOfBundles);
        }
        if (policies.persistence != null) {
            this.validatePersistencePolicies(policies.persistence);
        }
    }

    protected int internalGetMaxProducersPerTopic() {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).max_producers_per_topic;
    }

    protected void internalSetMaxProducersPerTopic(int maxProducersPerTopic) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            if (maxProducersPerTopic < 0) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "maxProducersPerTopic must be 0 or more");
            }
            policies.max_producers_per_topic = maxProducersPerTopic;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated maxProducersPerTopic configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, policies.max_producers_per_topic});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update maxProducersPerTopic configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update maxProducersPerTopic configuration for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update maxProducersPerTopic configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected int internalGetMaxConsumersPerTopic() {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).max_consumers_per_topic;
    }

    protected void internalSetMaxConsumersPerTopic(int maxConsumersPerTopic) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            if (maxConsumersPerTopic < 0) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "maxConsumersPerTopic must be 0 or more");
            }
            policies.max_consumers_per_topic = maxConsumersPerTopic;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated maxConsumersPerTopic configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, policies.max_consumers_per_topic});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update maxConsumersPerTopic configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update maxConsumersPerTopic configuration for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update maxConsumersPerTopic configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected int internalGetMaxConsumersPerSubscription() {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).max_consumers_per_subscription;
    }

    protected void internalSetMaxConsumersPerSubscription(int maxConsumersPerSubscription) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            if (maxConsumersPerSubscription < 0) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "maxConsumersPerSubscription must be 0 or more");
            }
            policies.max_consumers_per_subscription = maxConsumersPerSubscription;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated maxConsumersPerSubscription configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, policies.max_consumers_per_subscription});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update maxConsumersPerSubscription configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update maxConsumersPerSubscription configuration for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update maxConsumersPerSubscription configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected long internalGetCompactionThreshold() {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).compaction_threshold;
    }

    protected void internalSetCompactionThreshold(long newThreshold) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            if (newThreshold < 0L) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "compactionThreshold must be 0 or more");
            }
            policies.compaction_threshold = newThreshold;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated compactionThreshold configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, policies.compaction_threshold});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update compactionThreshold configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update compactionThreshold configuration for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update compactionThreshold configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected long internalGetOffloadThreshold() {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).offload_threshold;
    }

    protected void internalSetOffloadThreshold(long newThreshold) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            policies.offload_threshold = newThreshold;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated offloadThreshold configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, policies.offload_threshold});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update offloadThreshold configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update offloadThreshold configuration for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update offloadThreshold configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected Long internalGetOffloadDeletionLag() {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).offload_deletion_lag_ms;
    }

    protected void internalSetOffloadDeletionLag(Long newDeletionLagMs) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            policies.offload_deletion_lag_ms = newDeletionLagMs;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated offloadDeletionLagMs configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, policies.offload_deletion_lag_ms});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update offloadDeletionLagMs configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update offloadDeletionLagMs configuration for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update offloadDeletionLag configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected SchemaAutoUpdateCompatibilityStrategy internalGetSchemaAutoUpdateCompatibilityStrategy() {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).schema_auto_update_compatibility_strategy;
    }

    protected void internalSetSchemaAutoUpdateCompatibilityStrategy(SchemaAutoUpdateCompatibilityStrategy strategy) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        this.mutatePolicy(policies -> {
            policies.schema_auto_update_compatibility_strategy = strategy;
            return policies;
        }, policies -> policies.schema_auto_update_compatibility_strategy, "schemaAutoUpdateCompatibilityStrategy");
    }

    private <T> void mutatePolicy(Function<Policies, Policies> policyTransformation, Function<Policies, T> getter, String policyName) {
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            policies = policyTransformation.apply(policies);
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated {} configuration: namespace={}, value={}", new Object[]{this.clientAppId(), policyName, this.namespaceName, getter.apply(policies)});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update {} configuration for namespace {}: does not exist", new Object[]{this.clientAppId(), policyName, this.namespaceName});
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update {} configuration for namespace {}: concurrent modification", new Object[]{this.clientAppId(), policyName, this.namespaceName});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update {} configuration for namespace {}", new Object[]{this.clientAppId(), policyName, this.namespaceName, e});
            throw new RestException(e);
        }
    }
}

