/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.BrokerHostUsage;
import org.apache.pulsar.policies.data.loadbalancer.ResourceUsage;
import org.apache.pulsar.policies.data.loadbalancer.SystemResourceUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericBrokerHostUsageImpl
implements BrokerHostUsage {
    private static final int CPU_CHECK_MILLIS = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(GenericBrokerHostUsageImpl.class);
    private final int hostUsageCheckIntervalMin;
    private long lastCollection;
    private double totalCpuLimit;
    private double cpuUsageSum = 0.0;
    private int cpuUsageCount = 0;
    private OperatingSystemMXBean systemBean;
    private SystemResourceUsage usage;

    public GenericBrokerHostUsageImpl(PulsarService pulsar) {
        this.hostUsageCheckIntervalMin = pulsar.getConfiguration().getLoadBalancerHostUsageCheckIntervalMinutes();
        this.systemBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        this.lastCollection = 0L;
        this.usage = new SystemResourceUsage();
        this.totalCpuLimit = this.getTotalCpuLimit();
        pulsar.getLoadManagerExecutor().scheduleAtFixedRate(this::checkCpuLoad, 0L, 1000L, TimeUnit.MILLISECONDS);
        pulsar.getLoadManagerExecutor().scheduleAtFixedRate(this::calculateBrokerHostUsage, 0L, this.hostUsageCheckIntervalMin, TimeUnit.MINUTES);
    }

    @Override
    public SystemResourceUsage getBrokerHostUsage() {
        return this.usage;
    }

    private void checkCpuLoad() {
        this.cpuUsageSum += this.systemBean.getSystemCpuLoad();
        ++this.cpuUsageCount;
    }

    private void calculateBrokerHostUsage() {
        SystemResourceUsage usage = new SystemResourceUsage();
        usage.setCpu(this.getCpuUsage());
        usage.setMemory(this.getMemUsage());
        this.usage = usage;
    }

    private double getTotalCpuLimit() {
        return 100 * Runtime.getRuntime().availableProcessors();
    }

    private double getTotalCpuUsage() {
        double cpuUsage = this.cpuUsageSum / (double)this.cpuUsageCount;
        this.cpuUsageSum = 0.0;
        this.cpuUsageCount = 0;
        return cpuUsage;
    }

    private ResourceUsage getCpuUsage() {
        if (this.cpuUsageCount == 0) {
            return new ResourceUsage(0.0, this.totalCpuLimit);
        }
        return new ResourceUsage(this.getTotalCpuUsage() * this.totalCpuLimit, this.totalCpuLimit);
    }

    private ResourceUsage getMemUsage() {
        double total = (double)this.systemBean.getTotalPhysicalMemorySize() / 1048576.0;
        double free = (double)this.systemBean.getFreePhysicalMemorySize() / 1048576.0;
        return new ResourceUsage(total - free, total);
    }
}

