/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import org.apache.pulsar.broker.service.schema.IncompatibleSchemaException;
import org.apache.pulsar.common.api.proto.PulsarApi;

public class BrokerServiceException
extends Exception {
    public BrokerServiceException(String msg) {
        super(msg);
    }

    public BrokerServiceException(Throwable t) {
        super(t);
    }

    public static PulsarApi.ServerError getClientErrorCode(Throwable t) {
        if (t instanceof ServerMetadataException) {
            return PulsarApi.ServerError.MetadataError;
        }
        if (t instanceof NamingException) {
            return PulsarApi.ServerError.ProducerBusy;
        }
        if (t instanceof PersistenceException) {
            return PulsarApi.ServerError.PersistenceError;
        }
        if (t instanceof ConsumerBusyException) {
            return PulsarApi.ServerError.ConsumerBusy;
        }
        if (t instanceof UnsupportedVersionException) {
            return PulsarApi.ServerError.UnsupportedVersionError;
        }
        if (t instanceof TooManyRequestsException) {
            return PulsarApi.ServerError.TooManyRequests;
        }
        if (t instanceof TopicTerminatedException) {
            return PulsarApi.ServerError.TopicTerminatedError;
        }
        if (t instanceof ServiceUnitNotReadyException || t instanceof TopicFencedException || t instanceof SubscriptionFencedException) {
            return PulsarApi.ServerError.ServiceNotReady;
        }
        if (t instanceof IncompatibleSchemaException) {
            return PulsarApi.ServerError.IncompatibleSchema;
        }
        return PulsarApi.ServerError.UnknownError;
    }

    public static class AlreadyRunningException
    extends BrokerServiceException {
        public AlreadyRunningException(String msg) {
            super(msg);
        }
    }

    public static class TooManyRequestsException
    extends BrokerServiceException {
        public TooManyRequestsException(String msg) {
            super(msg);
        }
    }

    public static class UnsupportedVersionException
    extends BrokerServiceException {
        public UnsupportedVersionException(String msg) {
            super(msg);
        }
    }

    public static class SubscriptionInvalidCursorPosition
    extends BrokerServiceException {
        public SubscriptionInvalidCursorPosition(String msg) {
            super(msg);
        }
    }

    public static class NotAllowedException
    extends BrokerServiceException {
        public NotAllowedException(String msg) {
            super(msg);
        }
    }

    public static class SubscriptionBusyException
    extends BrokerServiceException {
        public SubscriptionBusyException(String msg) {
            super(msg);
        }
    }

    public static class TopicBusyException
    extends BrokerServiceException {
        public TopicBusyException(String msg) {
            super(msg);
        }
    }

    public static class SubscriptionFencedException
    extends BrokerServiceException {
        public SubscriptionFencedException(String msg) {
            super(msg);
        }
    }

    public static class TopicFencedException
    extends BrokerServiceException {
        public TopicFencedException(String msg) {
            super(msg);
        }
    }

    public static class NamingException
    extends BrokerServiceException {
        public NamingException(String msg) {
            super(msg);
        }
    }

    public static class ServerMetadataException
    extends BrokerServiceException {
        public ServerMetadataException(Throwable t) {
            super(t);
        }

        public ServerMetadataException(String msg) {
            super(msg);
        }
    }

    public static class TopicTerminatedException
    extends BrokerServiceException {
        public TopicTerminatedException(String msg) {
            super(msg);
        }

        public TopicTerminatedException(Throwable t) {
            super(t);
        }
    }

    public static class PersistenceException
    extends BrokerServiceException {
        public PersistenceException(Throwable t) {
            super(t);
        }
    }

    public static class TopicClosedException
    extends BrokerServiceException {
        public TopicClosedException(Throwable t) {
            super(t);
        }
    }

    public static class ServiceUnitNotReadyException
    extends BrokerServiceException {
        public ServiceUnitNotReadyException(String msg) {
            super(msg);
        }
    }

    public static class ProducerBusyException
    extends BrokerServiceException {
        public ProducerBusyException(String msg) {
            super(msg);
        }
    }

    public static class ConsumerBusyException
    extends BrokerServiceException {
        public ConsumerBusyException(String msg) {
            super(msg);
        }
    }
}

