/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import java.io.IOException;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.SchemaValidationException;
import org.apache.avro.SchemaValidator;
import org.apache.avro.SchemaValidatorBuilder;
import org.apache.pulsar.broker.service.schema.NeverSchemaValidator;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaType;

public class JsonSchemaCompatibilityCheck
implements SchemaCompatibilityCheck {
    private ObjectMapper objectMapper;

    @Override
    public SchemaType getSchemaType() {
        return SchemaType.JSON;
    }

    @Override
    public boolean isCompatible(SchemaData from, SchemaData to, SchemaCompatibilityStrategy strategy) {
        if (this.isAvroSchema(from)) {
            if (this.isAvroSchema(to)) {
                return this.isCompatibleAvroSchema(from, to, strategy);
            }
            return this.isJsonSchema(to);
        }
        if (this.isJsonSchema(from)) {
            if (this.isAvroSchema(to)) {
                return true;
            }
            if (this.isJsonSchema(to)) {
                return this.isCompatibleJsonSchema(from, to);
            }
            return false;
        }
        return true;
    }

    private boolean isCompatibleAvroSchema(SchemaData from, SchemaData to, SchemaCompatibilityStrategy strategy) {
        Schema.Parser fromParser = new Schema.Parser();
        Schema fromSchema = fromParser.parse(new String(from.getData()));
        Schema.Parser toParser = new Schema.Parser();
        Schema toSchema = toParser.parse(new String(to.getData()));
        SchemaValidator schemaValidator = JsonSchemaCompatibilityCheck.createSchemaValidator(strategy, true);
        try {
            schemaValidator.validate(toSchema, Arrays.asList(fromSchema));
        }
        catch (SchemaValidationException e) {
            return false;
        }
        return true;
    }

    private ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        return this.objectMapper;
    }

    private boolean isCompatibleJsonSchema(SchemaData from, SchemaData to) {
        try {
            ObjectMapper objectMapper = this.getObjectMapper();
            JsonSchema fromSchema = (JsonSchema)objectMapper.readValue(from.getData(), JsonSchema.class);
            JsonSchema toSchema = (JsonSchema)objectMapper.readValue(to.getData(), JsonSchema.class);
            return fromSchema.getId().equals(toSchema.getId());
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean isAvroSchema(SchemaData schemaData) {
        try {
            Schema.Parser fromParser = new Schema.Parser();
            Schema fromSchema = fromParser.parse(new String(schemaData.getData()));
            return true;
        }
        catch (SchemaParseException e) {
            return false;
        }
    }

    private boolean isJsonSchema(SchemaData schemaData) {
        ObjectMapper objectMapper = this.getObjectMapper();
        try {
            JsonSchema fromSchema = (JsonSchema)objectMapper.readValue(schemaData.getData(), JsonSchema.class);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static SchemaValidator createSchemaValidator(SchemaCompatibilityStrategy compatibilityStrategy, boolean onlyLatestValidator) {
        SchemaValidatorBuilder validatorBuilder = new SchemaValidatorBuilder();
        switch (compatibilityStrategy) {
            case BACKWARD: {
                return JsonSchemaCompatibilityCheck.createLatestOrAllValidator(validatorBuilder.canReadStrategy(), onlyLatestValidator);
            }
            case FORWARD: {
                return JsonSchemaCompatibilityCheck.createLatestOrAllValidator(validatorBuilder.canBeReadStrategy(), onlyLatestValidator);
            }
            case FULL: {
                return JsonSchemaCompatibilityCheck.createLatestOrAllValidator(validatorBuilder.mutualReadStrategy(), onlyLatestValidator);
            }
        }
        return NeverSchemaValidator.INSTANCE;
    }

    private static SchemaValidator createLatestOrAllValidator(SchemaValidatorBuilder validatorBuilder, boolean onlyLatest) {
        return onlyLatest ? validatorBuilder.validateLatest() : validatorBuilder.validateAll();
    }
}

